
#include "hardware_t.h"
#include "tc_vars.h"
#include "flash_t.h"
#include "display_t.h"
//#include "math.h"
#include "signal_t.h"
#include "commif_t.h"
#include "userif_t.h"

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// 							Class UserIF
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


//######################################################################################################################################################
void UserIF::Keyboard_Interface(void)
{
	char	cmd;			//The command
	int lMenuKey = -1;
	static unsigned char state=0;	//Stores state for remote-command state-machine

//-----------------------------------------------------------------------------------------------------	
//			handle remote inputs received from UART via RS232

	UI_request = 0;				//reset UI-request
	ButtonChanged = CommIF::handleInChar(UART_RXData);

//----------------------------------------------------------------------------------------------------	
//			handle keyboard inputs
//----------------------------------------------------------------------------------------------------	

	if (Keyboard_Changed == 0) return;
	Keyboard_Changed = 0;

	ButtonChanged = 1;  //BF -> kann weg??	
			
	if      ((Keyboard_mem & 0x00080000) == 0x00) {Hardware::ResetTimer(); Buttonhandler(30, 0); RC_user_if = 1; }	// Function Button 1
	else if ((Keyboard_mem & 0x00040000) == 0x00) {Hardware::ResetTimer(); Buttonhandler(31, 0); RC_user_if = 1; }	// Function Button 2
	else if ((Keyboard_mem & 0x00020000) == 0x00) {Hardware::ResetTimer(); Buttonhandler(32, 0); RC_user_if = 1; }	// Function Button 3
	else if ((Keyboard_mem & 0x00010000) == 0x00) {Hardware::ResetTimer(); Buttonhandler(33, 0); RC_user_if = 1; }	// Function Button 4
	else if ((Keyboard_mem & 0x00400000) == 0x00) {Hardware::ResetTimer(); Buttonhandler(34, 0); RC_user_if = 1; }	// Function Button 5
	else if ((Keyboard_mem & 0x00100000) == 0x00) {Hardware::ResetTimer(); Buttonhandler(35, 0); RC_user_if = 1; }	// Function Button 6
	
	else if ((Keyboard_mem & 0x00200000) == 0x00) { Buttonhandler( 1, 0); RC_user_if = 1; }	// Channel 1 Button
	else if ((Keyboard_mem & 0x00800000) == 0x00) { Buttonhandler( 2, 0); RC_user_if = 1; }	// Channel 2 Button
	else if ((Keyboard_mem & 0x01000000) == 0x00) { Buttonhandler( 3, 0); RC_user_if = 1; }	// Channel 3 Button 
	else if ((Keyboard_mem & 0x02000000) == 0x00) { Buttonhandler( 4, 0); RC_user_if = 1; }	// Channel 4 Button		// Shortcut
	else if ((Keyboard_mem & 0x04000000) == 0x00) { Buttonhandler(26, 0); RC_user_if = 1; }	// Channel Math Button	// Shortcut 
//	else if ((Keyboard_mem & 0x06000000) == 0x00) Buttonhandler(26, 0);	// Channel Math Button
	
	else if ((Keyboard_mem & 0x00008000) == 0x00) Buttonhandler(23, 0);			// Auto Scale
	else if ((Keyboard_mem & 0x00000100) == 0x00) { Buttonhandler( 8, 0); RC_user_if = 1; }	// Save/Recall
	else if ((Keyboard_mem & 0x00000800) == 0x00) { Buttonhandler(17, 0); RC_user_if = 1; }	// Quick Print
	else if ((Keyboard_mem & 0x00002000) == 0x00) Buttonhandler( 6, 0);			// Utility
	else if ((Keyboard_mem & 0x00000001) == 0x00) Buttonhandler(15, 0);			// Pulse Width
	
//	else if ((Keyboard_mem & 0x00000020) == 0x00) Buttonhandler(-1, 0);	// Not used
//	else if ((Keyboard_mem & 0x00000002) == 0x00) Buttonhandler(-1, 0);	// Not used
	else if ((Keyboard_mem & 0x00004000) == 0x00) { Buttonhandler(16, 0); RC_user_if = 1; }	// Cursor
	else if ((Keyboard_mem & 0x00000200) == 0x00) { Buttonhandler(19, 0); RC_user_if = 1; }	// Quick Messurement 	// Kurz geschlossen
	else if ((Keyboard_mem & 0x00000400) == 0x00) { Buttonhandler( 0, 0); RC_user_if = 1; }	// Acquire				//
	else if ((Keyboard_mem & 0x00001000) == 0x00) { Buttonhandler( 5, 0); RC_user_if = 1; }	// Display
	else if ((Keyboard_mem & 0x00000010) == 0x00) Buttonhandler(14, 0);			// Edge
	else if ((Keyboard_mem & 0x00000040) == 0x00) Buttonhandler(12, 0);			// Trigger Mode /Coupling
	
	else if ((Keyboard_mem & 0x00000080) == 0x00) Buttonhandler(10, 0);			// Mode Button (Main/Delayed)
	else if ((Keyboard_mem & 0x00000004) == 0x00) { Buttonhandler(37, 0); RC_user_if = 1; }	// Run / Stop Button
	else if ((Keyboard_mem & 0x00000008) == 0x00) Buttonhandler(38, 0);			// Single Button
	
}

//######################################################################################################################################################
//Main button handler
void UserIF::Buttonhandler(int MenuKey, char Pushedlong)			// Button Handler
{
	volatile int pm, xm,ym;
	volatile int res_xm;
	
	volatile long lpm, lxm,lym;
	volatile long lres_xm;
	
	short x, pos = 0;
	int ix, ix2, xa, Ct, result;
	unsigned long buffer_long;
	unsigned long *flash_address = 0;
	
	float buf_float;
	int buf_int;
	
	long timerVal;
	long timerPeriod;


#ifdef _Debug_        	
	if (Debug_Mode) printf("BH %i MA %i\n", MenuKey, MenuActive);
#endif
	//if (ButtonChanged == 0) return;									// If No Button Pressed return.
	//ButtonChanged = 0;

	//BF if splash is active (utility menue) delete splash and redraw the screen	
	if (Splash_drawed)
	{
		Display::REMOVE_SPLASH();
		Display::DrawInitialScreen();	//Display::RefreshScreen();
		Splash_drawed = false;
	
		Continius = Continius_bak;
	
		TimebaseChanged     = 1;
		TimeOffsetChanged   = 1;
		TriggerLevelChanged = 1;
		TriggerModeChanged  = 1;
		TriggerWayChanged   = 1;
		VoltageChangedCh1   = 1;									// Was Voltage changed
		VoltageChangedCh2   = 1;									// Was Voltage changed
		VoltageChangedCh3   = 1;									// Was Voltage changed
		VoltageChangedCh4   = 1;									// Was Voltage changed          		
			
		Display::StatusUpdate();
		
		CursorChanged = 3;
		Cursor_Data_First_Draw = 1;
		Display::DRAWCURSORDATA(0);
	
		Quick_Measure_First_Draw = 1;
		Display::DRAWQMDATA(0); 	
	
		Display::DRAW_ALL_CURSOR();
		if (Continius) Hardware::Start_Record();
	
		return;
	}


	if (StatusbarChanged) Display::RemoveStatusBtn();
//	if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
	
	MenuAktive = 1;
	
	switch(MenuKey)
	{			
		//--------------------------------------------
		// Acquire Button pressed	
		//--------------------------------------------
		case 0:
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			MenuButtonCheck(-1);
						
			New_Menu = 0;
			Menu_Changed = 1;
			
			Hardware::Reset_LED(5);
			
			break;	
		}	
		
		//--------------------------------------------
		// Channel 1 Button pressed
		//--------------------------------------------	
		case 1:
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	//close any popups

			MenuButtonCheck(-1);

			if (FFT_Mode != FFT_OFF)
			{
				MenuStatus[MENU_FFT][0] = 137;				// channel 1
				Hardware::FFT_Set_Channel(0);				// set active channel without backup
			
				Display::FFT_DrawStatus(0);				//draw FFT values in status area
				
				MenuStatusChanged = 0;
				Menu_Changed = 1;
				
				return;
			}

			//button switch logic
			if (Active_Menu == MenuKey)
			{
                		if ((Channel_2_Active == 0) && (Channel_3_Active == 0) && (Channel_4_Active == 0)) break;

				if (Channel_1_Active == 0) Hardware::UpdateChannel(1, 1);
				else Hardware::UpdateChannel(1, 0);
				
				VoltageChangedCh1 = 1;
			}
			else
			{ Hardware::UpdateChannel(1, 1); }


			//BF changed for channel 3 + 4 support in XY-mode
			if (!Channel_1_Active)	//channel 1 switched off
			{	
				//If XY-Mode is active, at least channel 3 + 4 must be active - else switch off XY-Mode
				if ((MenuStatus[MENU_TIMEBASE][2] == 1)  && !(Channel_3_Active && Channel_4_Active))
				{
					MenuStatus[MENU_TIMEBASE][0] = 1;	//Main mode active
					MenuStatus[MENU_TIMEBASE][2] = 0;	//246; BF cha
					XY_Mode = 0;
					
					//Draw main grid into grid plane
					Display::RefreshScreen();	
					//GridColor_Val = GridColorArray[GridColorArrayPos];		//Grid intensity
					//MenuStatus[MENU_DISPLAY][2] = GridColorArrayPos + 133;		//Menu text item
					//Hardware::Hardware::SetupADC();							//set intensity
				}
				RemovePlane |= 0x01;
				Hardware::Hardware::ClearPlanes();
			}

			MenuStatusChanged = 1;
			if (Cursor_Enabled) Display::CALCCURSORDATA();
			
			Display::StatusUpdate();
	
			New_Menu = 1;
			Menu_Changed = 1;
			
			if (Channel_1_Active == 1)
			{
				LED_ON[0] = 1;
				LED_ON[5] = 1;
				Hardware::Send_LED();	

				MenuAktive = 1;
			}
			else
			{
				LED_ON[0] = 0;
				LED_ON[5] = 0;
				Hardware::Send_LED();	

				MenuAktive = 0;
			}
			
			break;	
		}
		
		//--------------------------------------------
		// Channel 2 Button pressed	
		//--------------------------------------------
		case 2:
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	//close any popups

			MenuButtonCheck(-1);

			if (FFT_Mode != FFT_OFF)
			{
				MenuStatus[MENU_FFT][0] = 138;
				Hardware::FFT_Set_Channel(0);		// set active channel without backup
			
				Display::FFT_DrawStatus(0);	//draw FFT values in status area
				
				MenuStatusChanged = 0;
				Menu_Changed = 1;
				Display::StatusUpdate();
				
				return;
			}

			//button switch logic		
			if (Active_Menu == MenuKey)
			{
                		if ((Channel_1_Active == 0) && (Channel_3_Active == 0) && (Channel_4_Active == 0)) break;

				if (Channel_2_Active == 0) Hardware::UpdateChannel(2, 1);
				else Hardware::UpdateChannel(2, 0);
				
				VoltageChangedCh2 = 1;
			}
			else Hardware::UpdateChannel(2, 1);
			
			//BF changed for channel 3 + 4 support in XY-mode
			if (Channel_2_Active == 0)	//channel 2 switched off
            		{
				//If XY-Mode is active, at least channel 3 + 4 must be active - else switch off XY-Mode
				if ((MenuStatus[MENU_TIMEBASE][2] == 1) && !(Channel_3_Active && Channel_4_Active))
				{
					MenuStatus[MENU_TIMEBASE][0] = 1;
					MenuStatus[MENU_TIMEBASE][2] = 0;
					XY_Mode = 0;

					//Draw main grid into grid plane
					Display::RefreshScreen();		
					//GridColor_Val = GridColorArray[GridColorArrayPos];		//Grid intensity
					//MenuStatus[MENU_DISPLAY][2] = GridColorArrayPos + 133;		//Menu text item
					//Hardware::SetupADC();						//set intensity
				}

                		RemovePlane |= 0x02;
                		Hardware::ClearPlanes();
			}
	
			MenuStatusChanged = 2;
			if (Cursor_Enabled) Display::CALCCURSORDATA();
							
			Display::StatusUpdate();				
			
            		New_Menu = 2;
			Menu_Changed = 1;
			
			if (Channel_2_Active == 1)
			{
				LED_ON[1] = 1;
				LED_ON[5] = 1;
				Hardware::Send_LED();	

				MenuAktive = 1;
			}
			else
			{
				LED_ON[1] = 0;
				LED_ON[5] = 0;
				Hardware::Send_LED();	

				MenuAktive = 0;
			}
						
			break;	
		}
		
		//--------------------------------------------
		// Channel 3 Button pressed	
		//--------------------------------------------
		case 3:
		{
			if (NumberOfChannels == 2) return;

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	//close any popups

			MenuButtonCheck(-1);

			if (FFT_Mode != FFT_OFF)
			{
				MenuStatus[MENU_FFT][0] = 139;
				Hardware::FFT_Set_Channel(0);		// set active channel without backup
			
				Display::FFT_DrawStatus(0);	//draw FFT values in status area
				
				MenuStatusChanged = 0;
				Menu_Changed = 1;
				Display::StatusUpdate();
				
				return;
			}
			
			//button switch logic	
			if (Active_Menu == MenuKey)
			{
                		if ((Channel_1_Active == 0) && (Channel_2_Active == 0) && (Channel_4_Active == 0)) break;

				if (Channel_3_Active == 0) Hardware::UpdateChannel(3, 1);
				else Hardware::UpdateChannel(3, 0);

				VoltageChangedCh3 = 1;
			}
			else
			{ Hardware::UpdateChannel(3, 1); }
			

			//BF changed for channel 3 + 4 support in XY-mode
			if (Channel_3_Active == 0)	//channel 3 switched off
			{
				//If XY-Mode is active, at least channel 1 + 2 must be active - else switch off XY-Mode
				if ((MenuStatus[MENU_TIMEBASE][2] == 1) && !(Channel_1_Active && Channel_2_Active))
				{
					MenuStatus[MENU_TIMEBASE][0] = 1;
					MenuStatus[MENU_TIMEBASE][2] = 0;
					XY_Mode = 0;

					//Draw main grid into grid plane
					Display::RefreshScreen();		
					//GridColor_Val = GridColorArray[GridColorArrayPos];		//Grid intensity
					//MenuStatus[MENU_DISPLAY][2] = GridColorArrayPos + 133;		//Menu text item
					//Hardware::SetupADC();							//set intensity
				}
				RemovePlane |= 0x04;
				Hardware::ClearPlanes();
			}

			MenuStatusChanged = 3;	
			if (Cursor_Enabled) Display::CALCCURSORDATA();
				
			Display::StatusUpdate();
			
           		New_Menu = 3;
			Menu_Changed = 1;
			
			if (Channel_3_Active == 1)
			{
				LED_ON[2] = 1;
				LED_ON[5] = 1;
				Hardware::Send_LED();	

				MenuAktive = 1;
			}
			else
			{
				LED_ON[2] = 0;
				LED_ON[5] = 0;
				Hardware::Send_LED();	

				MenuAktive = 0;
			}
			
			break;	
		}
		
		//--------------------------------------------
		// Channel 4 Button pressed	
		//--------------------------------------------
		case 4:
		{
			if (NumberOfChannels == 2) return;

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	//close any popups

			MenuButtonCheck(-1);

			if (FFT_Mode != FFT_OFF)
			{
				MenuStatus[MENU_FFT][0] = 140;
				Hardware::FFT_Set_Channel(0);		// set active channel without backup
			
				Display::FFT_DrawStatus(0);		//draw FFT values in status area

				MenuStatusChanged = 0;
				Menu_Changed = 1;
				Display::StatusUpdate();

				return;
			}
			
			//button switch logic
			if (Active_Menu == MenuKey)
			{
                		if ((Channel_1_Active == 0) && (Channel_2_Active == 0) && (Channel_3_Active == 0)) break;

				if (Channel_4_Active == 0) Hardware::UpdateChannel(4, 1);
				else Hardware::UpdateChannel(4, 0);
				
				VoltageChangedCh4 = 1;
			}
			else Hardware::UpdateChannel(4, 1);
			
			//BF changed for channel 3 + 4 support in XY-mode
			if (Channel_4_Active == 0)	//channel 4 switched off
			{
				//If XY-Mode is active, at least channel 1 + 2 must be active - else switch off XY-Mode
				if ((MenuStatus[MENU_TIMEBASE][2] == 1) && !(Channel_1_Active && Channel_2_Active))
				{
					MenuStatus[MENU_TIMEBASE][0] = 1;
					MenuStatus[MENU_TIMEBASE][2] = 0;
					XY_Mode = 0;

					//Draw main grid into grid plane
					Display::RefreshScreen();		
					//GridColor_Val = GridColorArray[GridColorArrayPos];		//Grid intensity
					//MenuStatus[MENU_DISPLAY][2] = GridColorArrayPos + 133;		//Menu text item
					//Hardware::SetupADC();							//set intensity
				}
				RemovePlane |= 0x08;
				Hardware::ClearPlanes();
			}

			MenuStatusChanged = 4;
			if (Cursor_Enabled) Display::CALCCURSORDATA();
			
			Display::StatusUpdate();
			
            		New_Menu = 4;
			Menu_Changed = 1;
			
			if (Channel_4_Active == 1)
			{
				LED_ON[3] = 1;
				LED_ON[5] = 1;
				Hardware::Send_LED();	

				MenuAktive = 1;
			}
			else
			{
				LED_ON[3] = 0;
				LED_ON[5] = 0;
				Hardware::Send_LED();	

				MenuAktive = 0;
			}
			
			break;	
		}
		
		//--------------------------------------------
		// Display Button pressed	
		//--------------------------------------------
		case 5:
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			MenuButtonCheck(-1);
						
			New_Menu     = 5;
			Menu_Changed = 1;
			
			Hardware::Set_LED(5);
			
			break;	
		}
		
		//--------------------------------------------
		// Utility Button pressed	
		//--------------------------------------------
		case 6:
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			MenuButtonCheck(-1);
							
			New_Menu = 6;
			Menu_Changed = 1;
			
			//Hardware::Reset_LED(5);
			
			break;	
		}

/* BF function not implemented yet		
		//--------------------------------------------
		// Service Button pressed	//BF doesn't exist
		//--------------------------------------------
		case 7:
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			MenuButtonCheck(-1);
							
			New_Menu = 7;
			Menu_Changed = 1;
			
			Hardware::Set_LED(5);
			
			break;	
		}
*/		
		//--------------------------------------------
		// Save / Recall Button pressed	
		//--------------------------------------------
		case 8:
		{		
			MenuButtonCheck(-1);
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = 8;
			Menu_Changed = 1;
			
			Hardware::Set_LED(5);
			
			break;	
		}
		
		//--------------------------------------------
		// Print Menu Button pressed	
		//--------------------------------------------
		case 9:
		{		
			MenuButtonCheck(-1);
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = 9;
			Menu_Changed = 1;
			
			Hardware::Reset_LED(5);
			
			break;	
		}
		
		//--------------------------------------------------------
		// Main/Delay Button pressed	(Timebase menu)
		//--------------------------------------------------------
		case 10:
		{	
			if (FFT_Mode != FFT_OFF) break;
	
			if (!XY_Mode)
			{
				//if no channel pair is active -> grey out XY-Mode
				if (!(Channel_1_Active && Channel_2_Active) && !(Channel_3_Active && Channel_4_Active))
				{ MenuStatus[MENU_TIMEBASE][2] = 246; }
				else
				{ MenuStatus[MENU_TIMEBASE][2] = 0; }
				
				//MenuItemChanged[2] = 1;
			}
			
			//No delayed mode for timebase 2ns and USTB-timebases
			if (Selected_Timebase == 0 || USTB_Mode != USTB_OFF)
			{ MenuStatus[MENU_TIMEBASE][1] = 246; }	
			else
			{
				if(MenuStatus[MENU_TIMEBASE][0] == 1 || MenuStatus[MENU_TIMEBASE][2] == 1)
				MenuStatus[MENU_TIMEBASE][1] = 0;
				else
				MenuStatus[MENU_TIMEBASE][1] = 1;
			}
/* BF USTB support is implemented for XY mode now
	
			//No XY mode for  USTB-timebases
			if (USTB_Mode != 0)
			{ MenuStatus[MENU_TIMEBASE][2] = 246; }	//MenuItemChanged[2] = 1;}	
			else
			{
				if(MenuStatus[MENU_TIMEBASE][0] == 1 || MenuStatus[MENU_TIMEBASE][1] == 1)
				MenuStatus[MENU_TIMEBASE][2] = 0;
				else
				MenuStatus[MENU_TIMEBASE][2] = 1;

				//MenuItemChanged[2] = 1;
			}
*/

			//BF -> grey out Roll/Shift mode for normal timebases
			if(USTB_Mode == USTB_OFF)
			{
				MenuStatus[MENU_TIMEBASE][3] = 246;
				MenuStatus[MENU_TIMEBASE][4] = 246;
			}
			//restore roll/shift mode setting in menu
			else if (USTB_Mode == USTB_ROLL)
			{
				MenuStatus[MENU_TIMEBASE][3] = 1;
				MenuStatus[MENU_TIMEBASE][4] = 0;
			}
			else if (USTB_Mode == USTB_SHIFT)
			{
				MenuStatus[MENU_TIMEBASE][3] = 0;
				MenuStatus[MENU_TIMEBASE][4] = 1;
			}
			

			MenuButtonCheck(-1);
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu     = 10;
			Menu_Changed = 1;
			MenuStatusChanged = 1;

			Hardware::Reset_LED(5);
			//config_changed = true; 

			break;	
		}		
		
		//--------------------------------------------
		// Trigger Mode / Coupling Button
		//--------------------------------------------
		case 12: 
		{ 	

			if (RC_overlay) return;	
			if (RC_request) return;	
		
			if(FFT_Mode != FFT_OFF) return;

			if(USTB_Mode != USTB_OFF) return;

			/* Toggle deactive		
			if (Active_Menu == 12)
			{
				if (MenuStatus[MENU_TRIGGERMODE][0] == 93)
					MenuStatus[MENU_TRIGGERMODE][0] = 94;
				else
					MenuStatus[MENU_TRIGGERMODE][0] = 93;
	
				MenuItemChanged[0] = 1;						
			}
			*/			

			New_Menu = 12;
			Menu_Changed = 1;
/*BF del
			TriggerLevelChanged = 1;
			TriggerModeChanged = 1;
			
			Hardware::UpdateTrigger();
						
			Display::StatusUpdate();			
*/			
			Hardware::Set_LED(5);
			
			break;
		}		
		
		//--------------------------------------------	
		// Edge Trigger Menu Button pressed	
		//--------------------------------------------
		case 14:
		{	
			if (RC_overlay) return;	
		
			if (RC_request) return;	

			if(FFT_Mode != FFT_OFF) return;

			if(USTB_Mode != USTB_OFF) return;
	
			MenuButtonCheck(-1);
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
					
			TriggerWay = TRIG_EDGE;
			
			New_Menu = 14;
			Menu_Changed = 1;
			
            		TriggerWayChanged = 1;

            		Display::StatusUpdate();				
			
			LED_ON[5] = 1;
			LED_ON[8] = 1;
			LED_ON[10] = 0;

			Hardware::Send_LED();
			
			Hardware::UpdateTrigger();
			
			break;	
		}
		
		//--------------------------------------------
		// Pulse Width Trigger Menu Button pressed	
		//--------------------------------------------
		case 15:
		{	
			if (RC_overlay) return;	
		
			if (RC_request) return;	

			if(FFT_Mode != FFT_OFF) return;

			if(USTB_Mode != USTB_OFF) return;
	
			MenuButtonCheck(-1);
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }		
		
            		New_Menu = 15;
			Menu_Changed = 1;


			TriggerWay = TRIG_EDGE;		
			
            		TriggerWayChanged = 1;

            		Display::StatusUpdate();			
			
			LED_ON[5]  = 1;
			LED_ON[8]  = 0;
			LED_ON[10] = 1;	
            		Hardware::Send_LED();	

            		Hardware::UpdateTrigger();	

			break;	
		}		
		
		//--------------------------------------------
		// Cursor Menu Button pressed	
		//--------------------------------------------
		case 16:
		{		
			MenuButtonCheck(-1);
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			//CursorChanged = 7; 			
			if ((Cursor_Enabled) && (Active_Menu == MenuKey) && CRS_Delta)
			{
				//switch off cursors
                		Cursor_Enabled_Old = Cursor_Enabled;
                		Cursor_Enabled = false;
				Cursor_Data_First_Draw = 0;
				//Quick_Measure_First_Draw = 0;
				MenuStatusChanged = 1;

				// remove the cursor data
				for (ix = 408 * 20; ix < 430 * 20; ix++)
				{
					*(UI_Plane1 + ix) = 0;		// delete
					*(Buffer_UI2Plane + ix) = 0;	// delete Text
					*(UI_Plane2 + ix) = 0;		//Guido add: delete button-text
					*(UI_Plane4 + ix) = 0;		// delete
					*(UI_Plane5 + ix) = 0;		// delete
				}

				LED_ON[5] = 0;
				LED_ON[6] = 0;
		
				Hardware::Send_LED();			
						
				New_Menu = 16;
				Menu_Changed = 1;
				MenuAktive = 0;
						
				Display::DRAW_ALL_CURSOR();
			}
			else
			{
				if (Active_Menu == MenuKey)
				{
					//switch on cursors
					if(CRS_Delta)		//BF new two step logic for delta cursor
					CRS_Delta = 0;
					else
					CRS_Delta = 1;
				}

				LED_ON[5] = 1;
				LED_ON[6] = 1;
							
				if (QM_Enabled)
				{
					QM_Enabled_Old = QM_Enabled;
					QM_Enabled = false;
					Quick_Measure_First_Draw = 0;
					MenuStatusChanged = 1;
			
					// remove the cursor data
					for (ix = 408 * 20; ix < 430 * 20; ix++)
					{
						*(UI_Plane1 + ix) = 0;		// delete
						*(Buffer_UI2Plane + ix) = 0;	// delete Text
						*(UI_Plane2 + ix) = 0;		//Guido add: delete button-text
						*(UI_Plane4 + ix) = 0;		// delete
						*(UI_Plane5 + ix) = 0;		// delete
					}				
					LED_ON[7] = 0;
							
					//New_Menu = 19;
					Menu_Changed = 1;
					//MenuAktive = 0;
							
					Display::CALCQMDATA();
				}	
		
				Cursor_Vertical_Active   = 1;
				Cursor_Horizontal_Active = 3;
		
				Hardware::Send_LED();	
		
				Cursor_Enabled_Old = Cursor_Enabled;
				Cursor_Enabled = true;
				
				Cursor_Data_First_Draw = 1;
				MenuStatusChanged = 1;
				
				//SelectedChannel = 0;
				
				CursorChanged = 1;
				CursorChanged = 4;
				//CursorChanged = 3;	
				
				if(FFT_Mode != FFT_OFF)
				Display::FFT_CalcCursorData();
				else
				Display::CALCCURSORDATA();
				
				Display::DRAW_ALL_CURSOR();

						
				New_Menu = 16;
				Menu_Changed = 1;
				MenuAktive = 1;
			}
#ifdef _Debug_Cursor_			
if (Debug_Mode) printf("CE : %d CB : %d CVA : %d CHA : %d \n", Cursor_Enabled, Cursor_Both_Selected, Cursor_Vertical_Active, Cursor_Horizontal_Active);
#endif			
			UpdateMenuTextPlane = true;
            		
			//config_changed = true; 
			break;	
		}

		//--------------------------------------------
		// Quick Print Button pressed
		//--------------------------------------------
		//BF -> new two step logic
		//BF QP pushed once -> print menu
		//BF QP pushed twice -> direct screenshot

		case 17: 
		{
			if(QP_request > 2) { QP_request = 0; return; }

			QP_request ++;
			if(QP_request == 1)			//first push
			{ nr_delay(300);
			Keyboard_Interface();}			// recursive call

			if(QP_request == 1)			// call print menu
			{
				New_Menu = 17;
				Menu_Changed = 1;
				Hardware::Reset_LED(5);
				QP_request = 0;
				return;
			}
			else if (QP_request == 2)		// direct screenshot
			{
				CommIF::SCREENSHOT('B');	// save to BMP 
				QP_request = 0;
				Hardware::ISR_TIMER3(0);	// close popup
				return;
			}
			return;
		}
		
		//--------------------------------------------
		// Quick Measure Button pressed
		//--------------------------------------------
		case 19:
		{ 	
           		// if ((MenuStatus[MENU_TIMEBASE][2] == 1) || (XY_Mode == 1)) return;
            		if (XY_Mode == 1) return;
			if (FFT_Mode != FFT_OFF) return;

            		MenuButtonCheck(-1);
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			
			
			if ((QM_Enabled) && (Active_Menu == MenuKey))
			{
				if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }				
			
				QM_Type_Old[0] = QM_Type[0];
				QM_Type_Old[1] = QM_Type[1];
				QM_Type_Old[2] = QM_Type[2];				
						
				QM_Type[0] = 0;
				QM_Type[1] = 0;
				QM_Type[2] = 0;
		
				//BF del QM_Channel[0] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
				//BF del QM_Channel[1] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
				//BF del QM_Channel[2] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
		
				QM_Changed[0] = 0;
				QM_Changed[1] = 0;
				QM_Changed[2] = 0;
		
				//BF del Quick_Measure_First_Draw = 1;
		
				LED_ON[5] = 0;
				LED_ON[7] = 0;
		
				New_Menu = 19;
				Menu_Changed = 1;
				MenuAktive   = 0;
		
				QM_Enabled_Old = QM_Enabled;
				QM_Enabled = false;
		
				QM_Vertical_Active = 0;
				QM_Horizontal_Active = 0;
		
				Display::CALCQMDATA();

				// remove the cursor data
				for (ix = 408 * 20; ix < 430 * 20; ix++)
				{
					*(UI_Plane1 + ix) = 0;		// delete
					*(Buffer_UI2Plane + ix) = 0;	// delete Text
					*(UI_Plane2 + ix) = 0;		//Guido add: delete button-text
					*(UI_Plane4 + ix) = 0;		// delete
					*(UI_Plane5 + ix) = 0;		// delete
				}


			}
			else
			{ 	
				LED_ON[5] = 1;
				LED_ON[7] = 1;
					
				QM_Enabled_Old = QM_Enabled;
				QM_Enabled = true;
		
				QM_Vertical_Active = 3;
				QM_Horizontal_Active = 3;
			
				Quick_Measure_First_Draw = 1;		
				MenuStatusChanged = 1;
				
				if (QM_Type[0] == 0)
				{
					if (QM_Type_Old[0] == 0)
					{
						QM_Type_Old[0] = 5;             // Freqency
						QM_Type_Old[1] = 8;            // Peak-Peak
						QM_Type_Old[2] = 0;

						QM_Channel[0] = MenuStatus[MENU_QUICKMEASURE][0] - 26;	//BF add from below
						QM_Channel[1] = MenuStatus[MENU_QUICKMEASURE][0] - 26;	//BF add from below
						QM_Channel[2] = MenuStatus[MENU_QUICKMEASURE][0] - 26;	//BF add from below
					}

					QM_Type[0] = QM_Type_Old[0];
					QM_Type[1] = QM_Type_Old[1];
					QM_Type[2] = QM_Type_Old[2];
			
					//BF del QM_Channel[0] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
					//BF del QM_Channel[1] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
					//BF del QM_Channel[2] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
                		}
				
				if (QM_Type[0] > 0) QM_Changed[0] = 1;
				if (QM_Type[1] > 0) QM_Changed[1] = 1;
				if (QM_Type[2] > 0) QM_Changed[2] = 1;
			
				if (Cursor_Enabled)
				{
					Cursor_Enabled_Old = Cursor_Enabled;
					Cursor_Enabled = false;
					Cursor_Data_First_Draw = 0;
		
					//MenuStatusChanged = 1;
		
					// remove the cursor data
					for (ix = 408 * 20; ix < 430 * 20; ix++)
					{
						*(UI_Plane1 + ix) = 0;		// delete
						*(Buffer_UI2Plane + ix) = 0;	// delete Text
						*(UI_Plane2 + ix) = 0;		//Guido add: delete button-text
						*(UI_Plane4 + ix) = 0;		// delete
						*(UI_Plane5 + ix) = 0;		// delete
					}
		
					LED_ON[6] = 0;
							
					//New_Menu = 16;
					Menu_Changed = 1;
					//MenuAktive = 0;
							
					Display::DRAW_ALL_CURSOR();
				}
                				
				Display::CALCQMDATA();
				
                		New_Menu     = 19;
				Menu_Changed = 1;
				MenuAktive   = 1;
				UpdateMenuTextPlane = true;
			}
			
			Hardware::Send_LED();
			//config_changed = true; 	
			
			break;
		}
		
		//--------------------------------------------
		// Autoscale Button pressed
		//--------------------------------------------
		case 23:
		{	
			if (RC_overlay) return;	
		
			if (RC_request) return;	

			if (FFT_Mode != FFT_OFF) return;	//BF no AutoScale if FFT is active

            		if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

            		SingleMode = 0;
            		Continius = 1;
		
			New_Menu = 23;
			Menu_Changed = 1;
			Hardware::Reset_LED(5);
			
			AS_request = 1;
            		Hardware::AutoScale();

			break;
        	}

		//--------------------------------------------
		// Math Button pressed
		//--------------------------------------------
		case 26:
		{		
            		//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
            		if (XY_Mode == 1) break;

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			MenuButtonCheck(-1);
			
			// math menu was active and FFT was active bevore - switch back to old settings
			if (Channel_Math_Active && (Active_Menu == MENU_MATH) && (MenuStatus[MENU_MATH][1] == 1))
			{
				FFT_Mode = FFT_OFF;
				Display::FFT_DrawStatus(1);		//clear UI-Planes
				Hardware::FFT_Restore_Channels();

				Hardware::Zero_Levels_Restore();	
			}
			// math menu was inactive and FFT was active bevore - backup settings and switch to FFT settings 
			else if (!Channel_Math_Active && (MenuStatus[MENU_MATH][1] == 1))
			{
				Hardware::FFT_Set_Channel(1);				//set active channel in backup mode
				
				Hardware::Zero_Levels_Center();				//set zerolevels to the middle of the grid 
				
				FFT_Mode = MenuStatus[MENU_FFT][2] - 65;		// setting FFT-mode must be done after switching zero levels!
			}
			// math menu was inactive and FFT was inactive bevore - check math channels for normal math functions
			else if (!Channel_Math_Active && (MenuStatus[MENU_MATH][1] == 0))
			{
				Channel_1_Active = 1;		// Math with only one channel makes no sense
				Channel_2_Active = 1;
				LED_ON[0] = 1;
				LED_ON[1] = 1;
			}

			Display::RefreshScreen();	

			// toggle math menu status
			if ((Active_Menu == MenuKey) && (Channel_Math_Active == 1))
			{							
				if (Channel_Math_Active) Channel_Math_Active = 0;
				else Channel_Math_Active = 1;
			}
			else 
			{	Channel_Math_Active = 1;}

            		New_Menu = MENU_MATH;
			Menu_Changed = 1;
			
			if (Channel_Math_Active == 1)
            		{
				LED_ON[4] = 1;			// switch on LED
				MenuAktive = 1;			// activate buttons
            		}
			else if (!Channel_Math_Active || USTB_Mode != USTB_OFF)
            		{
				LED_ON[4] = 0;		// switch off LED
				MenuAktive = 0;		// grey out the buttons
		
				RemovePlane |= 0x10;
				Hardware::ClearPlanes();
            		}

			LED_ON[5] = 0;
			Hardware::Send_LED();
			config_changed = true; 	
			break;	
		}
		
		//--------------------------------------------
		// Function Button 1 pressed
		//--------------------------------------------
		case 30 :
		{
			// Button handler for function button 1 	BF new function
			F1_Btnhandler();
			break;
		}	

		//--------------------------------------------
		// Function Button 2 pressed
		//--------------------------------------------
		case 31 :
		{
			// Button handler for function button 2 	BF new function
			F2_Btnhandler();
			break;
		}

		//--------------------------------------------	
		// Function Button 3
		//--------------------------------------------
		case 32 :
		{
			// Button handler for function button 3 	BF new function
			F3_Btnhandler();
			break;
		}
		
		//--------------------------------------------
		// Function Button 4
		//--------------------------------------------
		case 33 :
		{
			// Button handler for function button 4 	BF new function
			F4_Btnhandler();
			break;
		}
		
		//--------------------------------------------
		// Function Button 5
		//--------------------------------------------
		case 34 :
		{
			// Button handler for function button 5 	BF new function
			F5_Btnhandler();
			break;
		}
		
		//--------------------------------------------
		// Function Button 6
		//--------------------------------------------
		case 35 :
		{		
			// Button handler for function button 6 	BF new function
			F6_Btnhandler();
			break;
		}
		
		//--------------------------------------------
        	// Run / Stop Button pressed
		//--------------------------------------------
		case 37 :
		{	
			if (Continius == 1)	// Run mode was active
			{
				Continius = 0;

				// Run/Stop to red
				LED_ON[12] = 0;
				LED_ON[13] = 1;
				// Single green
				LED_ON[14] = 0;
				LED_ON[15] = 1;
		
				SIGNAL_StartFr_idx = SIGNALFaktor_idx;
				Selected_Voltage_CH1_Old = Selected_Voltage_CH1;
				Selected_Voltage_CH2_Old = Selected_Voltage_CH2;
				Selected_Voltage_CH3_Old = Selected_Voltage_CH3;
				Selected_Voltage_CH4_Old = Selected_Voltage_CH4;
		
				TriggerMode_bak = MenuStatus[MENU_TRIGGERMODE][0];
				
				Hardware::Stop_Record();
			}
			else	// Stop mode was active
			{
				if (RC_request)		// coming back from signal recall
				{
					RC_request = 0;
					RC_overlay = 0;
				}
				else
				{
					if (USTB_Mode != USTB_OFF)
					Signal::USTB_Clear_Buffer();

					MenuStatus[MENU_TRIGGERMODE][0] = TriggerMode_bak;
					Display::MenuPopupInit(9, MENU_TRIGGERMODE, 92);		//BF #007
	
					MenuItemChanged[0] = 1;	
					Menu_Changed = 1;
					TriggerLevelChanged = 1;
					//TriggerModeChanged = 1;
			
					Hardware::UpdateTrigger();	
					//Display::StatusUpdate();
					Display::DRAW_ALL_CURSOR();
				}
					
				Continius = 1;
				SingleMode = 0;

				// Run/Stop green
				LED_ON[12] = 1;
				LED_ON[13] = 0;
				// Single off
				LED_ON[14] = 0;
				LED_ON[15] = 0;
		
				Hardware::Start_Record();	
			}

			Hardware::Send_LED();
		
			TriggerModeChanged = 1;
			Display::StatusUpdate();

			break;
        	}

		//--------------------------------------------
        	// Single Button pressed
		//--------------------------------------------
		case 38 :
		{	
            		//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;

			if (RC_overlay) return;	
		
			if (RC_request) return;	

			if (FFT_Mode != FFT_OFF) return;	

			if (USTB_Mode != USTB_OFF) return;	

			if (!Continius)		// stop mode is active
			{
				// Run / Stop out
				LED_ON[12] = 0;
				LED_ON[13] = 0;
		
				// Single orange
				LED_ON[14] = 1;
				LED_ON[15] = 1;

				Hardware::Send_LED();

				SingleMode = 1;
			
				MenuStatus[MENU_TRIGGERMODE][0] = TRIG_NORM;	//force to normal trigger
				Display::MenuPopupInit(9, MENU_TRIGGERMODE, 92);	//BF #007
				MenuItemChanged[0] = 1;		
				Menu_Changed = 1;
				TriggerLevelChanged = 1;
				TriggerModeChanged = 1;
	
				Hardware::UpdateTrigger();			
				Display::StatusUpdate();
	
				nr_delay(100);	

				if (adc_started == false) Hardware::Start_Record();
			}
			break;
        }
		
		//--------------------------------------------
		// Test Funktion 0 Q
		//--------------------------------------------
		case 40 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 0 (Q)  adjusting ADC zero offsets\r\n");
			
			for (ix = 0; ix < 100; ix+=4)
			{
				printf("S1_%d : %3d %3d %3d %3d\r\n", ix, SIGNAL1[ix], SIGNAL1[ix + 1], SIGNAL1[ix + 2], SIGNAL1[ix + 3]);
				nr_delay(10);
			}

			printf("\r\nSetting ADC offsets\r\n\r\n");

	
TestVar++;
if(TestVar > 25) TestVar = 0;
switch(TestVar)
{	
	case 0: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 0; break;}
	case 1: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 1; break;}
	case 2: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 0; break;}
	case 3: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 1; break;}
	case 4: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 0; break;}
	case 5: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 1; break;}
	case 6: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 0; break;}
	case 7: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 1; break;}
	case 8: {ADC_Offset[test_channel-1][0] = 1;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 0; break;}
	case 9: {ADC_Offset[test_channel-1][0] = 1;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 1; break;}
	case 10: {ADC_Offset[test_channel-1][0] = 1;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 0; break;}
	case 11: {ADC_Offset[test_channel-1][0] = 1;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 1; break;}
	case 12: {ADC_Offset[test_channel-1][0] = 1;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 0; break;}
	case 13: {ADC_Offset[test_channel-1][0] = 1;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 1; break;}
	case 14: {ADC_Offset[test_channel-1][0] = 1;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 0; break;}
	
	case 15: {ADC_Offset[test_channel-1][0] = 2;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 0; break;}
	case 16: {ADC_Offset[test_channel-1][0] = 2;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 0; break;}
	case 17: {ADC_Offset[test_channel-1][0] = 2;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 0; break;}
	case 18: {ADC_Offset[test_channel-1][0] = 2;ADC_Offset[test_channel-1][1] = 2;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 0; break;}
	case 19: {ADC_Offset[test_channel-1][0] = 2;ADC_Offset[test_channel-1][1] = 2;ADC_Offset[test_channel-1][2] = 2;ADC_Offset[test_channel-1][3] = 0; break;}
	case 20: {ADC_Offset[test_channel-1][0] = 2;ADC_Offset[test_channel-1][1] = 2;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 0; break;}
	case 21: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 2; break;}
	case 22: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 2; break;}
	case 23: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 2;ADC_Offset[test_channel-1][3] = 2; break;}
	case 24: {ADC_Offset[test_channel-1][0] = 1;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 2; break;}
	case 25: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 2;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 2; break;}

//	case 26: { printf("\r\nAuto calibrating ADC voltage offsets\r\n\r\n");Calibrate_ADC(test_channel); break;}

}			
		
			printf("Channel %d ADC offset = %d %d %d %d\n", test_channel, ADC_Offset[test_channel-1][0],
										      ADC_Offset[test_channel-1][1],
										      ADC_Offset[test_channel-1][2],
										      ADC_Offset[test_channel-1][3]);

			printf("****************************************************************************************\n");
/*


			if (ADC_Debug_Mode) ADC_Debug_Mode = false;
			else ADC_Debug_Mode = true;

			if (Debug_Mode)
			{
				if (ADC_Debug_Mode) printf("ADC Debug Mode enabled\n");
				else printf("ADC Debug Mode disabled\n");
			}

            		config_changed = true;
*/
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 1 W
		//--------------------------------------------
		case 41 :
		{	
			printf("****************************************************************************************\n");
			printf("Test function 1 decrement zeroes (shift + W)\n");
			
			// Guido: make testfunction work for the selected testchannel:
			switch (test_channel)
			{

				case 1:
				{
					for (ix = 0; ix < 100; ix+=4)
					{
						printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL1[ix], SIGNAL1[ix + 1], SIGNAL1[ix + 2], SIGNAL1[ix + 3]);
						nr_delay(10);
					}

					printf("CH1 Virtual Zero Level = %d\n", Virtual_ZeroLevelCH1);
					printf("CH1 Zero Level         = %d\n\n", ZeroLevelCH1);
					
					printf("decrementing zero correction\n\n");
					switch(Selected_Voltage_CH1)
					{
						case 0: DAC_Correction[test_channel-1][Selected_Voltage_CH1-1] --; break;//  1 mV
						case 1: DAC_Correction[test_channel-1][Selected_Voltage_CH1-1] --; break;//  2 mV
						case 2: DAC_Correction[test_channel-1][Selected_Voltage_CH1-1] --; break;//  5 mV
						case 3: DAC_Correction[test_channel-1][Selected_Voltage_CH1-3] --; break;// 10 mV
						case 4: DAC_Correction[test_channel-1][Selected_Voltage_CH1-3] --; break;// 20 mV
						case 5: DAC_Correction[test_channel-1][Selected_Voltage_CH1-3] --; break;// 50 mV
						case 6: DAC_Correction[test_channel-1][Selected_Voltage_CH1-6] --; break;//100 mV
						case 7: DAC_Correction[test_channel-1][Selected_Voltage_CH1-6] --; break;//200 mV
						case 8: DAC_Correction[test_channel-1][Selected_Voltage_CH1-6] --; break;//500 mV
						case 9: DAC_Correction[test_channel-1][Selected_Voltage_CH1-9] --; break;// 1 V
						case 10: DAC_Correction[test_channel-1][Selected_Voltage_CH1-9] --; break;//2 V
						case 11: DAC_Correction[test_channel-1][Selected_Voltage_CH1-9] --; break;//5 V
					}
			
					printf("CH1 DAC correction 1   = %d\n", DAC_Correction[test_channel-1][0]);
					printf("CH1 DAC correction 2   = %d\n", DAC_Correction[test_channel-1][1]);
					printf("CH1 DAC correction 3   = %d\n", DAC_Correction[test_channel-1][2]);
			
					printf("****************************************************************************************\n");
					break;			
				}
				case 2:
				{
					for (ix = 0; ix < 100; ix+=4)
					{
						printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL2[ix], SIGNAL2[ix + 1], SIGNAL2[ix + 2], SIGNAL2[ix + 3]);
						nr_delay(10);
					}

					printf("CH2 Virtual Zero Level = %d\n", Virtual_ZeroLevelCH2);
					printf("CH2 Zero Level         = %d\n\n", ZeroLevelCH2);
					
					printf("decrementing zero correction\n\n");
					switch(Selected_Voltage_CH2)
					{
						case 0: DAC_Correction[test_channel-1][Selected_Voltage_CH2-1] --; break;//  1 mV
						case 1: DAC_Correction[test_channel-1][Selected_Voltage_CH2-1] --; break;//  2 mV
						case 2: DAC_Correction[test_channel-1][Selected_Voltage_CH2-1] --; break;//  5 mV
						case 3: DAC_Correction[test_channel-1][Selected_Voltage_CH2-3] --; break;// 10 mV
						case 4: DAC_Correction[test_channel-1][Selected_Voltage_CH2-3] --; break;// 20 mV
						case 5: DAC_Correction[test_channel-1][Selected_Voltage_CH2-3] --; break;// 50 mV
						case 6: DAC_Correction[test_channel-1][Selected_Voltage_CH2-6] --; break;//100 mV
						case 7: DAC_Correction[test_channel-1][Selected_Voltage_CH2-6] --; break;//200 mV
						case 8: DAC_Correction[test_channel-1][Selected_Voltage_CH2-6] --; break;//500 mV
						case 9: DAC_Correction[test_channel-1][Selected_Voltage_CH2-9] --; break;// 1 V
						case 10: DAC_Correction[test_channel-1][Selected_Voltage_CH2-9] --; break;//2 V
						case 11: DAC_Correction[test_channel-1][Selected_Voltage_CH2-9] --; break;//5 V
					}
			
					printf("CH2 DAC correction 1   = %d\n", DAC_Correction[test_channel-1][0]);
					printf("CH2 DAC correction 2   = %d\n", DAC_Correction[test_channel-1][1]);
					printf("CH2 DAC correction 3   = %d\n", DAC_Correction[test_channel-1][2]);
			
					printf("****************************************************************************************\n");
					break;			
				}
				case 3:
				{
					for (ix = 0; ix < 100; ix+=4)
					{
						printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL3[ix], SIGNAL3[ix + 1], SIGNAL3[ix + 2], SIGNAL3[ix + 3]);
						nr_delay(10);
					}

					printf("CH3 Virtual Zero Level = %d\n", Virtual_ZeroLevelCH3);
					printf("CH3 Zero Level         = %d\n\n", ZeroLevelCH3);
					
					printf("decrementing zero correction\n\n");
					switch(Selected_Voltage_CH3)
					{
						case 0: DAC_Correction[test_channel-1][Selected_Voltage_CH3-1] --; break;//  1 mV
						case 1: DAC_Correction[test_channel-1][Selected_Voltage_CH3-1] --; break;//  2 mV
						case 2: DAC_Correction[test_channel-1][Selected_Voltage_CH3-1] --; break;//  5 mV
						case 3: DAC_Correction[test_channel-1][Selected_Voltage_CH3-3] --; break;// 10 mV
						case 4: DAC_Correction[test_channel-1][Selected_Voltage_CH3-3] --; break;// 20 mV
						case 5: DAC_Correction[test_channel-1][Selected_Voltage_CH3-3] --; break;// 50 mV
						case 6: DAC_Correction[test_channel-1][Selected_Voltage_CH3-6] --; break;//100 mV
						case 7: DAC_Correction[test_channel-1][Selected_Voltage_CH3-6] --; break;//200 mV
						case 8: DAC_Correction[test_channel-1][Selected_Voltage_CH3-6] --; break;//500 mV
						case 9: DAC_Correction[test_channel-1][Selected_Voltage_CH3-9] --; break;// 1 V
						case 10: DAC_Correction[test_channel-1][Selected_Voltage_CH3-9] --; break;//2 V
						case 11: DAC_Correction[test_channel-1][Selected_Voltage_CH3-9] --; break;//5 V
					}
			
					printf("CH3 DAC correction 1   = %d\n", DAC_Correction[test_channel-1][0]);
					printf("CH3 DAC correction 2   = %d\n", DAC_Correction[test_channel-1][1]);
					printf("CH3 DAC correction 3   = %d\n", DAC_Correction[test_channel-1][2]);
			
					printf("****************************************************************************************\n");
					break;			
				}
				case 4:
				{
					for (ix = 0; ix < 100; ix+=4)
					{
						printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL4[ix], SIGNAL4[ix + 1], SIGNAL4[ix + 2], SIGNAL4[ix + 3]);
						nr_delay(10);
					}

					printf("CH4 Virtual Zero Level = %d\n", Virtual_ZeroLevelCH4);
					printf("CH4 Zero Level         = %d\n\n", ZeroLevelCH4);
					
					printf("decrementing zero correction\n\n");
					switch(Selected_Voltage_CH4)
					{
						case 0: DAC_Correction[test_channel-1][Selected_Voltage_CH4-1] --; break;//  1 mV
						case 1: DAC_Correction[test_channel-1][Selected_Voltage_CH4-1] --; break;//  2 mV
						case 2: DAC_Correction[test_channel-1][Selected_Voltage_CH4-1] --; break;//  5 mV
						case 3: DAC_Correction[test_channel-1][Selected_Voltage_CH4-3] --; break;// 10 mV
						case 4: DAC_Correction[test_channel-1][Selected_Voltage_CH4-3] --; break;// 20 mV
						case 5: DAC_Correction[test_channel-1][Selected_Voltage_CH4-3] --; break;// 50 mV
						case 6: DAC_Correction[test_channel-1][Selected_Voltage_CH4-6] --; break;//100 mV
						case 7: DAC_Correction[test_channel-1][Selected_Voltage_CH4-6] --; break;//200 mV
						case 8: DAC_Correction[test_channel-1][Selected_Voltage_CH4-6] --; break;//500 mV
						case 9: DAC_Correction[test_channel-1][Selected_Voltage_CH4-9] --; break;// 1 V
						case 10: DAC_Correction[test_channel-1][Selected_Voltage_CH4-9] --; break;//2 V
						case 11: DAC_Correction[test_channel-1][Selected_Voltage_CH4-9] --; break;//5 V
					}
			
					printf("CH4 DAC correction 1   = %d\n", DAC_Correction[test_channel-1][0]);
					printf("CH4 DAC correction 2   = %d\n", DAC_Correction[test_channel-1][1]);
					printf("CH4 DAC correction 3   = %d\n", DAC_Correction[test_channel-1][2]);
			
					printf("****************************************************************************************\n");
					break;			
				}
			}
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 2 E
		//--------------------------------------------
		case 42 :
		{	
			printf("****************************************************************************************\n");
			printf("Test function 2 increment zeroes (shift + E)\n");

			// Guido: make testfunction work for the selected testchannel:
			switch (test_channel)
			{

				case 1:
				{
					for (ix = 0; ix < 100; ix+=4)
					{
						printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL1[ix], SIGNAL1[ix + 1], SIGNAL1[ix + 2], SIGNAL1[ix + 3]);
						nr_delay(10);
					}

					printf("CH1 Virtual Zero Level = %d\n", Virtual_ZeroLevelCH1);
					printf("CH1 Zero Level         = %d\n\n", ZeroLevelCH1);
					
					printf("incrementing zero correction\n\n");
					switch(Selected_Voltage_CH1)
					{
						case 0: DAC_Correction[test_channel-1][Selected_Voltage_CH1-1] ++; break;//  1 mV
						case 1: DAC_Correction[test_channel-1][Selected_Voltage_CH1-1] ++; break;//  2 mV
						case 2: DAC_Correction[test_channel-1][Selected_Voltage_CH1-1] ++; break;//  5 mV
						case 3: DAC_Correction[test_channel-1][Selected_Voltage_CH1-3] ++; break;// 10 mV
						case 4: DAC_Correction[test_channel-1][Selected_Voltage_CH1-3] ++; break;// 20 mV
						case 5: DAC_Correction[test_channel-1][Selected_Voltage_CH1-3] ++; break;// 50 mV
						case 6: DAC_Correction[test_channel-1][Selected_Voltage_CH1-6] ++; break;//100 mV
						case 7: DAC_Correction[test_channel-1][Selected_Voltage_CH1-6] ++; break;//200 mV
						case 8: DAC_Correction[test_channel-1][Selected_Voltage_CH1-6] ++; break;//500 mV
						case 9: DAC_Correction[test_channel-1][Selected_Voltage_CH1-9] ++; break;// 1 V
						case 10: DAC_Correction[test_channel-1][Selected_Voltage_CH1-9] ++; break;//2 V
						case 11: DAC_Correction[test_channel-1][Selected_Voltage_CH1-9] ++; break;//5 V
					}
			
					printf("CH1 DAC correction 1   = %d\n", DAC_Correction[test_channel-1][0]);
					printf("CH1 DAC correction 2   = %d\n", DAC_Correction[test_channel-1][1]);
					printf("CH1 DAC correction 3   = %d\n", DAC_Correction[test_channel-1][2]);
			
					printf("****************************************************************************************\n");
					break;			
				}
				case 2:
				{
					for (ix = 0; ix < 100; ix+=4)
					{
						printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL2[ix], SIGNAL2[ix + 1], SIGNAL2[ix + 2], SIGNAL2[ix + 3]);
						nr_delay(10);
					}

					printf("CH2 Virtual Zero Level = %d\n", Virtual_ZeroLevelCH2);
					printf("CH2 Zero Level         = %d\n\n", ZeroLevelCH2);
					
					printf("incrementing zero correction\n\n");
					switch(Selected_Voltage_CH2)
					{
						case 0: DAC_Correction[test_channel-1][Selected_Voltage_CH2-1] ++; break;//  1 mV
						case 1: DAC_Correction[test_channel-1][Selected_Voltage_CH2-1] ++; break;//  2 mV
						case 2: DAC_Correction[test_channel-1][Selected_Voltage_CH2-1] ++; break;//  5 mV
						case 3: DAC_Correction[test_channel-1][Selected_Voltage_CH2-3] ++; break;// 10 mV
						case 4: DAC_Correction[test_channel-1][Selected_Voltage_CH2-3] ++; break;// 20 mV
						case 5: DAC_Correction[test_channel-1][Selected_Voltage_CH2-3] ++; break;// 50 mV
						case 6: DAC_Correction[test_channel-1][Selected_Voltage_CH2-6] ++; break;//100 mV
						case 7: DAC_Correction[test_channel-1][Selected_Voltage_CH2-6] ++; break;//200 mV
						case 8: DAC_Correction[test_channel-1][Selected_Voltage_CH2-6] ++; break;//500 mV
						case 9: DAC_Correction[test_channel-1][Selected_Voltage_CH2-9] ++; break;// 1 V
						case 10: DAC_Correction[test_channel-1][Selected_Voltage_CH2-9] ++; break;//2 V
						case 11: DAC_Correction[test_channel-1][Selected_Voltage_CH2-9] ++; break;//5 V
					}
			
					printf("CH2 DAC correction 1   = %d\n", DAC_Correction[test_channel-1][0]);
					printf("CH2 DAC correction 2   = %d\n", DAC_Correction[test_channel-1][1]);
					printf("CH2 DAC correction 3   = %d\n", DAC_Correction[test_channel-1][2]);
			
					printf("****************************************************************************************\n");
					break;			
				}
				case 3:
				{
					for (ix = 0; ix < 100; ix+=4)
					{
						printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL3[ix], SIGNAL3[ix + 1], SIGNAL3[ix + 2], SIGNAL3[ix + 3]);
						nr_delay(10);
					}

					printf("CH3 Virtual Zero Level = %d\n", Virtual_ZeroLevelCH3);
					printf("CH3 Zero Level         = %d\n\n", ZeroLevelCH3);
					
					printf("incrementing zero correction\n\n");
					switch(Selected_Voltage_CH3)
					{
						case 0: DAC_Correction[test_channel-1][Selected_Voltage_CH3-1] ++; break;//  1 mV
						case 1: DAC_Correction[test_channel-1][Selected_Voltage_CH3-1] ++; break;//  2 mV
						case 2: DAC_Correction[test_channel-1][Selected_Voltage_CH3-1] ++; break;//  5 mV
						case 3: DAC_Correction[test_channel-1][Selected_Voltage_CH3-3] ++; break;// 10 mV
						case 4: DAC_Correction[test_channel-1][Selected_Voltage_CH3-3] ++; break;// 20 mV
						case 5: DAC_Correction[test_channel-1][Selected_Voltage_CH3-3] ++; break;// 50 mV
						case 6: DAC_Correction[test_channel-1][Selected_Voltage_CH3-6] ++; break;//100 mV
						case 7: DAC_Correction[test_channel-1][Selected_Voltage_CH3-6] ++; break;//200 mV
						case 8: DAC_Correction[test_channel-1][Selected_Voltage_CH3-6] ++; break;//500 mV
						case 9: DAC_Correction[test_channel-1][Selected_Voltage_CH3-9] ++; break;// 1 V
						case 10: DAC_Correction[test_channel-1][Selected_Voltage_CH3-9] ++; break;//2 V
						case 11: DAC_Correction[test_channel-1][Selected_Voltage_CH3-9] ++; break;//5 V
					}
			
					printf("CH3 DAC correction 1   = %d\n", DAC_Correction[test_channel-1][0]);
					printf("CH3 DAC correction 2   = %d\n", DAC_Correction[test_channel-1][1]);
					printf("CH3 DAC correction 3   = %d\n", DAC_Correction[test_channel-1][2]);
			
					printf("****************************************************************************************\n");
					break;			
				}
				case 4:
				{
					for (ix = 0; ix < 100; ix+=4)
					{
						printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL4[ix], SIGNAL4[ix + 1], SIGNAL4[ix + 2], SIGNAL4[ix + 3]);
						nr_delay(10);
					}

					printf("CH4 Virtual Zero Level = %d\n", Virtual_ZeroLevelCH4);
					printf("CH4 Zero Level         = %d\n\n", ZeroLevelCH4);
					
					printf("incrementing zero correction\n\n");
					switch(Selected_Voltage_CH4)
					{
						case 0: DAC_Correction[test_channel-1][Selected_Voltage_CH4-1] ++; break;//  1 mV
						case 1: DAC_Correction[test_channel-1][Selected_Voltage_CH4-1] ++; break;//  2 mV
						case 2: DAC_Correction[test_channel-1][Selected_Voltage_CH4-1] ++; break;//  5 mV
						case 3: DAC_Correction[test_channel-1][Selected_Voltage_CH4-3] ++; break;// 10 mV
						case 4: DAC_Correction[test_channel-1][Selected_Voltage_CH4-3] ++; break;// 20 mV
						case 5: DAC_Correction[test_channel-1][Selected_Voltage_CH4-3] ++; break;// 50 mV
						case 6: DAC_Correction[test_channel-1][Selected_Voltage_CH4-6] ++; break;//100 mV
						case 7: DAC_Correction[test_channel-1][Selected_Voltage_CH4-6] ++; break;//200 mV
						case 8: DAC_Correction[test_channel-1][Selected_Voltage_CH4-6] ++; break;//500 mV
						case 9: DAC_Correction[test_channel-1][Selected_Voltage_CH4-9] ++; break;// 1 V
						case 10: DAC_Correction[test_channel-1][Selected_Voltage_CH4-9] ++; break;//2 V
						case 11: DAC_Correction[test_channel-1][Selected_Voltage_CH4-9] ++; break;//5 V
					}
			
					printf("CH4 DAC correction 1   = %d\n", DAC_Correction[test_channel-1][0]);
					printf("CH4 DAC correction 2   = %d\n", DAC_Correction[test_channel-1][1]);
					printf("CH4 DAC correction 3   = %d\n", DAC_Correction[test_channel-1][2]);
			
					printf("****************************************************************************************\n");
					break;			
				}
			}
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 3 R
		//--------------------------------------------
		case 43 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 3 Change adc_change register (shift + R)\r\n");

			Hardware::Stop_Record();
			nr_delay(50);
			if (adc_change12_reg == 0)
			{
				adc_change12_reg = 0x01000000;
				adc_change34_reg = 0x01000000;
			}
			else
			{
				adc_change12_reg = 0x00000000;
				adc_change34_reg = 0x00000000;
			}
			Hardware::SetupADC();
			nr_delay(50);	

			if (!SingleMode && Continius && !AS_request && !RC_request)
			{ Hardware::Start_Record(); } 

			printf("* adc_change12_reg :  %8x    * adc_change34_reg : %8x *\r\n", adc_change12_reg, adc_change34_reg);
			printf("****************************************************************************************\r\n");


			break;
		}
		
		//--------------------------------------------
		// Test Funktion 4 T
		//--------------------------------------------
		case 44 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 4 - switch OS compatibility mode - (shift + T)\r\n");	
	
			//switch OS compatibility mode
			if (OS_CompMode) OS_CompMode = 0;
			else OS_CompMode = 1;
			if (test_channel < 1) test_channel = 1;
			printf("\nOS_CompMode = %d\n", OS_CompMode);
			printf("****************************************************************************************\r\n");

			
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 5 Z
		//--------------------------------------------
		case 45 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 5 - switch testchannel - (shift + Z)\r\n");	

			//test channel
			test_channel++;
			if (test_channel > NumberOfChannels) test_channel = 1;
			if (test_channel < 1) test_channel = 1;
			printf("\nTest channel = %d\n", test_channel);
			printf("****************************************************************************************\r\n");

			break;
		}		
		
		//--------------------------------------------
		// Test Funktion 6 U
		//--------------------------------------------
		case 46 :
		{		
			printf("****************************************************************************************\r\n");
			printf("Test function 6 - read ADC - (shift + U)\r\n");	

			long buffer_long;

			buffer_long = Hardware::READADC(1);    // Read correction
			buffer_long = Hardware::READADC(1);
	
			Hardware::READADC_ALL2(1, &readout_sigbuf[0], 4096);
			Hardware::PREPARE_READADC(ADC_Offset[0][0],ADC_Offset[0][1],ADC_Offset[0][2],ADC_Offset[0][3], 4096);
				
			// Get new Signal Data
			if (Selected_Timebase < 7) //Highspeed
			{
				if (MenuStatus[MENU_ACQUIRE][1] == 1)
				{ Hardware::READADC_ALL(1, &SIGNAL1[0], 0, ADC_ZERO, 1, 1); }
				else
				{ Hardware::READADC_ALL(1, &SIGNAL1[0], 0, ADC_ZERO, 0, 1); }
		
			}
			else	//Lowspeed
			{
				if (MenuStatus[MENU_ACQUIRE][1] == 1)
				{ Hardware::READADC_ALL(1, &SIGNAL1[0], 0, ADC_ZERO, 1, 0); }
				else
				{ Hardware::READADC_ALL(1, &SIGNAL1[0], 0, ADC_ZERO, 0, 0); }
			}
			
			//print signal values
			for (ix = 0; ix < 160; ix+=4)
			{
				printf("S1_%d : %3d %3d %3d %3d\r\n", ix, SIGNAL1[ix], SIGNAL1[ix + 1], SIGNAL1[ix + 2], SIGNAL1[ix + 3]);
				nr_delay(10);
			}
			printf("\r\n****************************************************************************************\r\n");
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 7 I
		//--------------------------------------------
		case 47 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 7 - Transfer USB Data - (shift + I)\r\n");	


			if (USB_Data_Requested && Transfer_man_data)
			{ USB_Data_Requested = 0; Transfer_man_data = 0; printf("USB Transfer switched off\n\r"); }	
			else
			{ USB_Data_Requested = 1; Transfer_man_data = 1; printf("USB Transfer switched on\n\r"); }	
			
			USB_OnlyTrigger = false;

			break;

			printf("\r\n****************************************************************************************\r\n");

		}
		
		//--------------------------------------------
		// Test Funktion 8 O
		//--------------------------------------------
		case 48 :
		{		
			printf("****************************************************************************************\r\n");
			printf("Test function 8 - save protected config data - (shift + O)\r\n");	
			
			AMDFlash::Write_Protected_Flash();	
	

			printf("\r\n****************************************************************************************\r\n");
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 9 P
		//--------------------------------------------
		case 49 :
		{
			printf("****************************************************************************************\r\n");
			printf("Test function 9 - read ADC 1 - (P)\r\n");	

			long buffer_long;

			buffer_long = Hardware::READADC(1);    // Read correction
			buffer_long = Hardware::READADC(1);
	
			Hardware::READADC_ALL2(1, &readout_sigbuf[0], 4096);
			Hardware::PREPARE_READADC(ADC_Offset[0][0],ADC_Offset[0][1],ADC_Offset[0][2],ADC_Offset[0][3], 4096);
				
			// Get new Signal Data
			if (Selected_Timebase < 7) //Highspeed
			{
				if (MenuStatus[MENU_ACQUIRE][1] == 1)
				{ Hardware::READADC_ALL(1, &SIGNAL1[0], 0, ADC_ZERO, 1, 1); }
				else
				{ Hardware::READADC_ALL(1, &SIGNAL1[0], 0, ADC_ZERO, 0, 1); }
		
			}
			else	//Lowspeed
			{
				if (MenuStatus[MENU_ACQUIRE][1] == 1)
				{ Hardware::READADC_ALL(1, &SIGNAL1[0], 0, ADC_ZERO, 1, 0); }
				else
				{ Hardware::READADC_ALL(1, &SIGNAL1[0], 0, ADC_ZERO, 0, 0); }
			}

			//printf("CH1 alpha correction   = %d\r\n", alpha[0]);
			//printf("CH1 beta correction    =  ");floatprintf(beta[0]);printf("\r\n\r\n");

		
			//print signal values
			for (ix = 0; ix < 160; ix+=4)
			{
				printf("S1_%d : %3d %3d %3d %3d\r\n", ix, SIGNAL1[ix], SIGNAL1[ix + 1], SIGNAL1[ix + 2], SIGNAL1[ix + 3]);
				nr_delay(10);
			}
			printf("\r\n****************************************************************************************\r\n");
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 10 A
		//--------------------------------------------
		case 50 :
		{	
            		printf("****************************************************************************************\r\n");
			printf("Test function 10 (A) - display ADC-values - \r\n");
			
			printf("            Channel 1                    Channel 2                  Channel 3                    Channel 4 \r\n");
			for (ix = 0; ix < 160; ix+=4)
			{
				printf("S1_%d : %3d %3d %3d %3d    ", ix, SIGNAL1[ix], SIGNAL1[ix + 1], SIGNAL1[ix + 2], SIGNAL1[ix + 3]);
				printf("S2_%d : %3d %3d %3d %3d    ", ix, SIGNAL2[ix], SIGNAL2[ix + 1], SIGNAL2[ix + 2], SIGNAL2[ix + 3]);
				if (NumberOfChannels == 4)
				{
					printf("S3_%d : %3d %3d %3d %3d    ", ix, SIGNAL3[ix], SIGNAL3[ix + 1], SIGNAL3[ix + 2], SIGNAL3[ix + 3]);
					printf("S4_%d : %3d %3d %3d %3d    ", ix, SIGNAL4[ix], SIGNAL4[ix + 1], SIGNAL4[ix + 2], SIGNAL4[ix + 3]);
				}
				printf("\n");
				//nr_delay(10);
			}
			printf("\n");
			//printf("Draw factor            = %d\r\n\r\n", draw_factor);
		
			//printf("CH1 alpha correction   = %d\r\n", alpha[0]);
			//printf("CH1 beta correction    =  ");floatprintf(beta[0]);printf("\r\n\r\n");
			
			//printf("CH2 alpha correction   = %d\r\n", alpha[1]);
			//printf("CH2 beta correction    =  ");floatprintf(beta[1]);printf("\r\n\r\n");
			//printf("ZeroLevelCH1            = %d\n", ZeroLevelCH1);
			//printf("Virtual_ZeroLevelCH1    = %d\n\n", Virtual_ZeroLevelCH1);

			printf("Voltage range CH1       = %d\n", Selected_Voltage_CH1);
			printf("Voltage range CH2       = %d\n", Selected_Voltage_CH2);

			if (NumberOfChannels == 4)
			{
				printf("Voltage range CH3       = %d\n", Selected_Voltage_CH3);
				printf("Voltage range CH4       = %d\n", Selected_Voltage_CH4);
			}
			printf("\n");
			printf("CH1 ADC1 Voltage offset = %d\r\n",ADC_Offset[0][0]);
			printf("CH1 ADC2 Voltage offset = %d\r\n",ADC_Offset[0][1]);
			printf("CH1 ADC3 Voltage offset = %d\r\n",ADC_Offset[0][2]);
			printf("CH1 ADC4 Voltage offset = %d\r\n\r\n",ADC_Offset[0][3]);
			
			printf("CH2 ADC1 Voltage offset = %d\r\n",ADC_Offset[1][0]);
			printf("CH2 ADC2 Voltage offset = %d\r\n",ADC_Offset[1][1]);
			printf("CH2 ADC3 Voltage offset = %d\r\n",ADC_Offset[1][2]);
			printf("CH2 ADC4 Voltage offset = %d\r\n\r\n",ADC_Offset[1][3]);
			
			if (NumberOfChannels == 4)
			{
				printf("CH3 ADC1 Voltage offset = %d\r\n",ADC_Offset[2][0]);
				printf("CH3 ADC2 Voltage offset = %d\r\n",ADC_Offset[2][1]);
				printf("CH3 ADC3 Voltage offset = %d\r\n",ADC_Offset[2][2]);
				printf("CH3 ADC4 Voltage offset = %d\r\n\r\n",ADC_Offset[2][3]);
				
				printf("CH4 ADC1 Voltage offset = %d\r\n",ADC_Offset[3][0]);
				printf("CH4 ADC2 Voltage offset = %d\r\n",ADC_Offset[3][1]);
				printf("CH4 ADC3 Voltage offset = %d\r\n",ADC_Offset[3][2]);
				printf("CH4 ADC4 Voltage offset = %d\r\n\r\n",ADC_Offset[3][3]);
			}


			printf("CH1 DAC correction 1   = %d\n", DAC_Correction[0][0]);
			printf("CH1 DAC correction 2   = %d\n", DAC_Correction[0][1]);
			printf("CH1 DAC correction 3   = %d\n", DAC_Correction[0][2]);
			
			printf("CH2 DAC correction 1   = %d\n", DAC_Correction[1][0]);
			printf("CH2 DAC correction 2   = %d\n", DAC_Correction[1][1]);
			printf("CH2 DAC correction 3   = %d\n", DAC_Correction[1][2]);
			
			if (NumberOfChannels == 4)
			{
				printf("CH3 DAC correction 1   = %d\n", DAC_Correction[2][0]);
				printf("CH3 DAC correction 2   = %d\n", DAC_Correction[2][1]);
				printf("CH3 DAC correction 3   = %d\n", DAC_Correction[2][2]);
	
				printf("CH4 DAC correction 1   = %d\n", DAC_Correction[3][0]);
				printf("CH4 DAC correction 2   = %d\n", DAC_Correction[3][1]);
				printf("CH4 DAC correction 3   = %d\n", DAC_Correction[3][2]);
			}
			printf("\r\n****************************************************************************************\r\n");
            		break;
		}
		
		//--------------------------------------------
		// Test Funktion 11 S
		//--------------------------------------------
		case 51 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 11 (S) - test switch 1 on/off - \r\n");
			
			//toggle test switch
			if(test_sw1){ test_sw1 = 0; printf("Test switch 1 is off"); }
			else { test_sw1 = 1; printf("Test switch 1 is on"); }

			printf("\r\n****************************************************************************************\r\n");
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 12 D
		//--------------------------------------------
		case 52 :
		{	
			//Test offset
			if (test_channel == 1)
			test_offs_a++;
			else
			test_offs_b++;
			printf("\ntest offset a = %d ; test offset b = %d\n", test_offs_a , test_offs_b);
/*
			if (Debug_Mode) Debug_Mode = false;
			else Debug_Mode = true;
		
			if (Debug_Mode) printf("Debug Mode enabled\n");
			else printf("Debug Mode disabled\n");
		
			config_changed = true;
*/
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 13 F
		//--------------------------------------------
		case 53 :
		{	
			//Test zero
			if (test_channel == 1)
			test_zero_a+=10;
			else
			test_zero_b+=10;
			//printf("\ntest zero a = %d ; test zero b = %d\n", test_zero_a , test_zero_b);
/*
			//reset_watchdog->np_piodata = 0x00;						// Disable WatchDog
			AMDFlash::Clear_Data_FLASH();
			printf("Flash formated\n");
			//reset_watchdog->np_piodata = 0x01;						// Enable WatchDog
			//Reset_the_Watchdog();
			printf("Reset Hardware\n");
			nr_delay(3000);						
*/
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 14 G
		//--------------------------------------------
		case 54 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 14 (G) - switch gain - \r\n");

			GainIdx++;

			if(GainIdx > 4) GainIdx = 0;

			if (Channel_1_Active) Hardware::SetSwitches(1, Selected_Voltage_CH1);
			if (Channel_2_Active) Hardware::SetSwitches(2, Selected_Voltage_CH2);
			if (Channel_3_Active) Hardware::SetSwitches(3, Selected_Voltage_CH3);
			if (Channel_4_Active) Hardware::SetSwitches(4, Selected_Voltage_CH4);
			MenuStatus[MENU_HARDWARE][1] = GainIdx + 230;			//Set gain menu 

			printf("Gain Index = %d\r\n", GainIdx);

			printf("****************************************************************************************\r\n");

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 15 H/h
		//--------------------------------------------
		case 55 :
		{	
	
			printf("\r\n");
			printf("***************************************************************************\r\n");
			printf("* Keyboard Commands : Menus                                               *\r\n");
			printf("***************************************************************************\r\n");
			printf("* Channel 1     : i  *  Mode / Timebase : b * Display      : d * File : f *\r\n");
			printf("* Channel 2     : j  *  Cursor          : c * Trigger Edge : e *          *\r\n");
			printf("* Channel 3     : k  *  Quick Measure   : q * Mode / Coup  : t *          *\r\n");
			printf("* Channel 4     : l  *  Quick Meas Sett : w * Pulse Width  : p *          *\r\n");
			printf("* Channel Math  : o  *  Acquire         : a * Utility      : u *          *\r\n");
			printf("***************************************************************************\r\n");
			printf("* Extended Commands : Help Keys                                           *\r\n");
			printf("***************************************************************************\r\n");
			printf("* This Help Screen  : h / Shift + H * Test switch 2          : Shift + Y  *\r\n");
			printf("* Enable Debug Mode     : Shift + D * Test switch 3          : Shift + X  *\r\n");
			printf("* Clear Data Flash      : Shift + F * Manual DAC Calibration : Shift + W  *\r\n");
			printf("* Test switch 1         : Shift + S * Manual DAC Calibration : Shift + E  *\r\n");
			printf("* Reset Hardware        : Shift + R * Read ADC 1             : Shift + P  *\r\n");
			printf("* Manual ADC calibration: Shift + Q * Interpolate CH1        : Shift + I  *\r\n");
			printf("* Switch test channel   : Shift + Z * Search Mode            : Shift + M  *\r\n");
			printf("* Switch Gain Index     : Shift + G * Show Trigger Vals      : Shift + J  *\r\n");
			printf("* Smooth CH I           : Shift + K * Smooth CH II           : Shift + L  *\r\n");
			printf("* OS Compatibility Mode : Shift + T * Display ADC values     : Shift + A  *\r\n");
			printf("* Plane Colordemo       : Shift + C *                                     *\r\n");
			//printf("* Show ADC-Data     :     Shift + A * Search Mode            : Shift + M  *\r\n");
			printf("* Show Variables        : ,         * Switch FFT status displ: Shift + V  *\r\n");
			//printf("*                   :     !         *                        : -          *\r\n");
			//printf("* M-Factor CHI + 10 :     Shift + 2 * M-Factor CHI - 10      : Shift + 3  *\r\n");
			printf("* Read ADC              : Shift + U * Display ADC offsets    : =          *\r\n");
			printf("* Write prot. flash     : Shift + O *                                     *\r\n");
			printf("* Solid grid lines      : x         *                                     *\r\n");
			printf("* Dotted grid lines     : z         *                                     *\r\n");
			printf("*-------------------------------------------------------------------------*\r\n");
			printf("* All test switches off: Vertical pixel connection of next Pixel          *\r\n");
			printf("* Test switch 1 on     : Line drawing with Bresenham line algrithm        *\r\n");
			printf("* Test switch 2 on     : Pixel connection Pmin - Pmax no smoothing        *\r\n");
			printf("* Test switch 3 on     : Signal smoothing (only Pmin/Pmax post processing *\r\n");
			printf("*                                                                         *\r\n");
		//            printf("* Timebase manipulation : Press ShiftKey +                                *\r\n");
		//            printf("*      1       2       3     4    5    6    7      8      9         0     *\r\n");
		//            printf("* -0x10000 -0x1000 -0x100 -0x10 -0x1 +0x1 +0x10 +0x100 +0x1000 +0x100000  *\r\n");
			printf("***************************************************************************\r\n");
			printf("\r\n");

			break;
		}		
		
		//--------------------------------------------
		// Test Funktion 16 J
		//--------------------------------------------
		case 56 :
		{		
			//Reset test values
			test_channel = 1;
			test_offs_a  = 0;
			test_offs_b  = 0;
			test_zero_a  = 0;
			test_zero_b  = 0;
			test_div_a   = 1;
			test_div_b   = 1;
			test_rel_a   = 0;
			test_rel_b   = 0;
			printf("\nTest values resetted\n");

			//printf("ctr %x actr %x tb %x pr %x tvr1 %x tvr2 %x trr %x trw %x tp1 %i adc_ch %x \r\n", ctrl_reg, adc_ctrl_reg, timebase_reg, pre_reg, trg_val_CHI_reg, trg_val_CHII_reg, trig_range_reg, trig_width_reg, Trigger_Pos_CH1, adc_change12_reg);

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 17 K
		//--------------------------------------------
		case 57 :
		{	/*BF del not used	
			if (SmoothEnabledCH1) SmoothEnabledCH1 = 0;
			else SmoothEnabledCH1 = 1;
		
			if (Debug_Mode)
			{
				if (SmoothEnabledCH1) printf("Smooth CH I enabled\n");
				else printf("Smooth CH I disabled\n");
			}
			*/
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 18 L
		//--------------------------------------------
		case 58 :
		{	/*BF del not used	
			if (SmoothEnabledCH2) SmoothEnabledCH2 = 0;
			else SmoothEnabledCH2 = 1;
		
			if (Debug_Mode)
			{
				if (SmoothEnabledCH2) printf("Smooth CH II enabled\n");
				else printf("Smooth CH II disabled\n");
			}
			*/
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 19 Ö
		//--------------------------------------------
		case 59 :
		{		
			//Test 
            		if (test_channel == 1)
			test_rel_a++;
			else
			test_rel_b++;
			printf("\ntest rel a = %d ; test rel b = %d\n", test_rel_a , test_rel_b);

			//TestFir();

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 20 Y
		//--------------------------------------------
		case 60 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 20 (Y) - test switch 2 on/off - \r\n");
			
			//toggle test switch
			if(test_sw2){ test_sw2 = 0; printf("Test switch 2 is off\r\n"); }
			else { test_sw2 = 1; printf("Test switch 2 is on\r\n"); }

			printf("****************************************************************************************\r\n");
			
			//Display::ColorDemo5();
			break;
		}	
		
		//--------------------------------------------
		// Test Funktion 21 X
		//--------------------------------------------
		case 61 :
		{
			printf("****************************************************************************************\r\n");
			printf("Test function 21 (X) - test switch 3 on/off - \r\n");
			
			//toggle test switch
			if(test_sw3){ test_sw3 = 0; printf("Test switch 3 is off\r\n"); }
			else { test_sw3 = 1; printf("Test switch 3 is on\r\n"); }

			printf("****************************************************************************************\r\n");
			
			//Display::ColorDemo6();
			break;	
		}	

		//--------------------------------------------
		// Test Funktion 22 C
		//--------------------------------------------
		case 62 :
		{		
			test_values = 1;

			Display::ColorDemo2();
			//CommIF::SCREENSHOT();
			//while (1 != 0);
			break;
		}	

		//--------------------------------------------
		// Test Funktion 23 V
		//--------------------------------------------
		case 63 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 23 (Shift + V) - switch FFT status variant - \r\n");

			if (FFT_Layout){ FFT_Layout = false; printf("Status layout with yellow background\r\n");}
			else { FFT_Layout = true; printf("Status layout black design\r\n"); }
			printf("****************************************************************************************\r\n");
				
			Display::RefreshScreen();	
            		config_changed = true;		

			break;
		}		
		
		//--------------------------------------------
		// Test Funktion 24 B
		//--------------------------------------------
		case 64 :
		{		
			if (Command_Mode) Command_Mode = false;
			else Command_Mode = true;
		
			if (Debug_Mode)
			{
				if (Command_Mode) printf("Command Mode enabled\n");
				else printf("Command Mode disabled\n");
			}
		
			config_changed = true;
			break;
		} 

		//--------------------------------------------	
		// Test Funktion 25 N
		//--------------------------------------------
		case 65 :
		{	
		    	//Display::GRIDXY(GRID_XY_XOFFS, GRID_YOFFS, Grid_Plane);

			//printf("Add  : %d\n", nm_math_pfx(0x040A, 0x00643040, 0x00C8FFB0));
			//printf("Sub  : %d\n", nm_math_pfx(0x000A, 0x00643040, 0x00C8FFB0));
			//printf("Mult : %d\n", nm_math_pfx(0x0212, 0x00643040, 0x00C8FFB0));

            		// Multiplikation
            /*
			xm = 0x00010101;
			ym = 0x00010101;
			res_xm = nm_math_pfx(0x0201, xm, ym);
	
			printf("math op1 : %d z1 : %d op2 : %d z2 : %d mult1 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
	
			xm = 0x00010502;
			ym = 0x00010502;
			res_xm = nm_math_pfx(0x0201, xm, ym);

			printf("math op1 : %d z1 : %d op2 : %d z2 : %d mult2 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));

			xm = 0x01F47E92;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0203, xm, ym);

			printf("math op1 : %d z1 : %d op2 : %d z2 : %d mult3 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));

            		xm = 0x01F47E6A;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0203, xm, ym);

            		printf("math op1 : %d z1 : %d op2 : %d z2 : %d mult4 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));

            		xm = 0x01F47E90;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0203, xm, ym);

		    	printf("math op1 : %d z1 : %d op2 : %d z2 : %d mult5 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));

           		xm = 0x01F47E65;
		    	ym = 0x01F47E7D;
		   	res_xm = nm_math_pfx(0x0203, xm, ym);

		    	printf("math op1 : %d z1 : %d op2 : %d z2 : %d mult6 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));

            		xm = 0x01F47E99;
		    	ym = 0x01F47E7D;
		    	res_xm = nm_math_pfx(0x0203, xm, ym);

		    	printf("math op1 : %d z1 : %d op2 : %d z2 : %d mult7 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
            */

            		// Addition
			xm = 0x00010101;
			ym = 0x00010101;
			res_xm = nm_math_pfx(0x0401, xm, ym);

            		printf("mth op1: %d z1: %d op2: %d z2: %d delA: %d delB: %d\n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, ((xm & 0xFF00) >> 8) - xm & 0xFF, ((ym & 0xFF00) >> 8) - ym & 0xFF);
            		//printf("mth ad1 = %x  res: %d  b1: %d b2: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
            		printf("mth ad1 = %x  res: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), ((res_xm & 0x00000F00) >> 8));

			xm = 0x00010502;
			ym = 0x00010502;
			res_xm = nm_math_pfx(0x0401, xm, ym);

            		printf("mth op1: %d z1: %d op2: %d z2: %d delA: %d delB: %d\n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, ((xm & 0xFF00) >> 8) - xm & 0xFF, ((ym & 0xFF00) >> 8) - ym & 0xFF);
            		//printf("mth ad2 = %x  res: %d  b1: %d b2: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
            		printf("mth ad2 = %x  res: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), ((res_xm & 0x00000F00) >> 8));

			xm = 0x01F47E92;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0403, xm, ym);

			printf("mth op1: %d z1: %d op2: %d z2: %d delA: %d delB: %d\n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, ((xm & 0xFF00) >> 8) - xm & 0xFF, ((ym & 0xFF00) >> 8) - ym & 0xFF);
			//printf("mth ad3 = %x  res: %d  b1: %d b2: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
			printf("mth ad3 = %x  res: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), ((res_xm & 0x00000F00) >> 8));
		
			xm = 0x01F47E6A;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0403, xm, ym);

			printf("mth op1: %d z1: %d op2: %d z2: %d delA: %d delB: %d\n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, ((xm & 0xFF00) >> 8) - xm & 0xFF, ((ym & 0xFF00) >> 8) - ym & 0xFF);
			//printf("mth ad4 = %x  res: %d  b1: %d b2: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
			printf("mth ad4 = %x  res: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), ((res_xm & 0x00000F00) >> 8));
		
			xm = 0x01F47E92;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0403, xm, ym);

			printf("mth op1: %d z1: %d op2: %d z2: %d delA: %d delB: %d\n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, ((xm & 0xFF00) >> 8) - xm & 0xFF, ((ym & 0xFF00) >> 8) - ym & 0xFF);
			//printf("mth ad5 = %x  res: %d  b1: %d b2: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
			printf("mth ad5 = %x  res: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), ((res_xm & 0x00000F00) >> 8));
		
			xm = 0x01F47E6A;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0403, xm, ym);

			printf("mth op1: %d z1: %d op2: %d z2: %d delA: %d delB: %d\n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, ((xm & 0xFF00) >> 8) - xm & 0xFF, ((ym & 0xFF00) >> 8) - ym & 0xFF);
			//printf("mth ad6 = %x  res: %d  b1: %d b2: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
			printf("mth ad6 = %x  res: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), ((res_xm & 0x00000F00) >> 8));
		
			xm = 0x01F47E99;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0403, xm, ym);

			printf("mth op1: %d z1: %d op2: %d z2: %d delA: %d delB: %d\n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, ((xm & 0xFF00) >> 8) - xm & 0xFF, ((ym & 0xFF00) >> 8) - ym & 0xFF);
			//printf("mth ad7 = %x  res: %d  b1: %d b2: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
			printf("mth ad7 = %x  res: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), ((res_xm & 0x00000F00) >> 8));
		
			xm = 0x01F47EA0;
			ym = 0x01F47E7D;
			res_xm = nm_math_pfx(0x0403, xm, ym);

			printf("mth op1: %d z1: %d op2: %d z2: %d delA: %d delB: %d\n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, ((xm & 0xFF00) >> 8) - xm & 0xFF, ((ym & 0xFF00) >> 8) - ym & 0xFF);
			//printf("mth ad8 = %x  res: %d  b1: %d b2: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
			printf("mth ad8 = %x  res: %d  tst : %d \n\n", res_xm, (res_xm & 0xFF), ((res_xm & 0x00000F00) >> 8));



            // Subtraction
            /*		
		    xm = 0x00010101;//0x00643040;
		    ym = 0x00010101;//0x00C8FFB0;
		    res_xm = nm_math_pfx(0x0001, xm, ym);

            printf("math op1 : %d z1 : %d op2 : %d z2 : %d sub1 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
		
		    xm = 0x00010502;//0x00643040;
		    ym = 0x00010502;//0x00C8FFB0;
		    res_xm = nm_math_pfx(0x0001, xm, ym);

		    printf("math op1 : %d z1 : %d op2 : %d z2 : %d sub2 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
		
		    xm = 0x01F47E92;
		    ym = 0x01F47E7D;
		    res_xm = nm_math_pfx(0x0003, xm, ym);

		    printf("math op1 : %d z1 : %d op2 : %d z2 : %d sub3 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
		
            xm = 0x01F47E6A;
		    ym = 0x01F47E7D;
		    res_xm = nm_math_pfx(0x0003, xm, ym);

		    printf("math op1 : %d z1 : %d op2 : %d z2 : %d sub4 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
            			
            xm = 0x01F47E90;
		    ym = 0x01F47E7D;
		    res_xm = nm_math_pfx(0x0003, xm, ym);

		    printf("math op1 : %d z1 : %d op2 : %d z2 : %d sub5 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
		
            xm = 0x01F47E65;
		    ym = 0x01F47E7D;
		    res_xm = nm_math_pfx(0x0003, xm, ym);

		    printf("math op1 : %d z1 : %d op2 : %d z2 : %d sub6 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", xm & 0xFF, (xm & 0xFF00) >> 8, ym & 0xFF, (ym & 0xFF00) >> 8, res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));	
		
            xm = 0x01F47E99;
		    ym = 0x01F47E7D;
		    res_xm = nm_math_pfx(0x0003, xm, ym);

		    printf("math op1 : %d z1 : %d op2 : %d z2 : %d sub7 = %d  res : %d  b1 : %d b2 : %d  test : %d \n", res_xm, (res_xm & 0xFF), (res_xm & 0x100) >> 8, (res_xm & 0x200) >> 9, 255 - ((res_xm & 0x3FC00) >> 10));
            */           	
			break;
		}		
		
		//--------------------------------------------
		// Test Funktion 26 M
		//--------------------------------------------
		case 66 :
		{	
            		// Clear All Planes
            		//for (ix = 0; ix < 153600; ix++) Planes[ix] = 0;	

            		Display::GRID(GRID_XOFFS, GRID_YOFFS, Grid_Plane);		
            /*	
		   	 Search_Step = 0;
            		
            		if (Search_Mode) Search_Mode = false;
            		else Search_Mode = true;

			if (Debug_Mode)
			{
				if (Search_Mode) printf("Search Mode enabled\n");
				else printf("Search Mode disabled\n");
			}

            		printf("SearchResult : %i\n", Hardware::SearchZeros());
            */
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 27 ;
		//--------------------------------------------
		case 67 :
		{	
			for (ix = 0; ix < 3; ix++)
			{
				printf("QMT %2i = %2i QMC = %2i QMCC = %2i QMSC = %2i QMEI = %2i QMEII = %2i\n", ix, QM_Type[ix], QM_Channel[ix], QM_Changed[ix], QM_Second_Channel[ix], QM_CHI_Edge[ix], QM_CHII_Edge[ix]);
			}
  	
			break;
		}		
		
		//--------------------------------------------
		// Test Funktion 28 :
		//--------------------------------------------
		case 68 :
		{	
		
			for (ix = 0; ix < 32; ix++)
			{
				printf("M %2i =", ix);
		
				for (ix2 = 0; ix2 < 6; ix2++)
				{
					printf("  I %i : %3i", ix2, MenuStatus[ix][ix2]);
		
				}
				printf("\n");
			}

			break;
		}

		//--------------------------------------------
		// Test Funktion 69 ,
		//--------------------------------------------
		case 69 :
		{	
			printf("\r\n");
			printf("*****************************************************************************\r\n");
			printf("* Variables                           *                                     *\r\n");
			printf("*****************************************************************************\r\n");
			printf("* Channel_1_Active        : %5d     * Channel_2_Active         : %5d    *\r\n", Channel_1_Active, Channel_2_Active);
			printf("* Channel_3_Active        : %5d     * Channel_4_Active         : %5d    *\r\n", Channel_3_Active, Channel_4_Active);
			printf("* Channel_1_Active_bak    : %5d     * Channel_2_Active_bak     : %5d    *\r\n", Channel_1_Active_bak, Channel_2_Active_bak);
			printf("* Channel_3_Active_bak    : %5d     * Channel_4_Active_bak     : %5d    *\r\n", Channel_3_Active_bak, Channel_4_Active_bak);
			printf("* Gain Index              : %5d     * Debug Mode               : %5d    *\r\n", GainIdx, Debug_Mode);
			printf("*                                     * ADC Debug Mode           : %5d    *\r\n", ADC_Debug_Mode);
			printf("* Timebase_Offset_Pos     : %5d     * Command Debug Mode       : %5d    *\r\n", Timebase_Offset_Pos, Command_Mode);
			printf("* SIGNAL_OFFSET           : %5d     * Calc Mode                : %5d    *\r\n", SIGNAL_OFFSET, Calc_Mode);
			printf("* Signal Start            : %5d     * Search Mode              : %5d    *\r\n", SignalStartStop[Timebase_Idx][0], Search_Mode);
			printf("* Signal Stop             : %5d     * Search Auto              : %5d    *\r\n", SignalStartStop[Timebase_Idx][1], Search_Auto);
			printf("* Signal Start Calc       : %5d     *                                     *\r\n", SignalStartStop[Timebase_Idx][0] + (int)((float) Timebase_Offset_Pos * OffsetFactorTable[Timebase_Idx]));
			printf("* Signal Stop Calc        : %5d     * Continius                : %5d    *\r\n", SignalStartStop[Timebase_Idx][1] + (int)((float) Timebase_Offset_Pos * OffsetFactorTable[Timebase_Idx]), Continius);
			printf("* Zoom factor             : "); Display::floatprintf(ZoomFactorTable[Timebase_Idx]);
			printf("     * Zoom factor delayed      : "); Display::floatprintf(ZoomFactorDel);printf("    *\r\n");
			printf("* SingleMode              : %5d     *                                     *\r\n", SingleMode);
			printf("* Offset Factor           : "); Display::floatprintf(OffsetFactorTable[Timebase_Idx]);printf("     *                                     *\r\n");
//BF used???			printf("* Single Restart ????     : %5d    *\r\n", Single_Restart);
			printf("* ADC_Data_Available      : %5d     * VSync Needed             : %5d    *\r\n", ADC_Data_Available, VSync_Needed);
			printf("* Keyboard_Changed        : %5d     * ZoomFactor               : ", Keyboard_Changed); Display::floatprintf(ZoomFactor); printf("    *\r\n");
			printf("* ------------------------------------*-------------------------------------*\r\n");
			printf("* UserInterface_request   : %5d     * pre_reg                  :  %4x    *\r\n", UI_request, pre_reg);
			printf("* ctrl_reg                :  %4x     * adc_ctrl_reg             :  %4x    *\r\n", ctrl_reg, adc_ctrl_reg);
			printf("* channel_Adr_add12       :  %4x     * channel_Adr_add34        :  %4x    *\r\n",channel_Adr_add12 , channel_Adr_add34);
			printf("* trg_val_CHI_reg         :  %4x     * trg_val_CHII_reg         :  %4x    *\r\n", trg_val_CHI_reg, trg_val_CHII_reg);
			printf("* trg_val_CHIII_reg       :  %4x     * trg_val_CHIV_reg         :  %4x    *\r\n", trg_val_CHIII_reg, trg_val_CHIV_reg);
			printf("* trig_range_reg          :  %4x     * trig_holdoff_reg         :  %4x    *\r\n", trig_range_reg, trig_holdoff_reg);
			printf("* trig_width_reg          :  %4x     *                                     *\r\n", trig_width_reg);
			printf("* adc_change12_reg        : %8x  * adc_change34_reg         : %8x *\r\n", adc_change12_reg, adc_change34_reg);
			printf("* adc_ctr12_reg           : %8x  * adc_ctr34_reg            : %8x *\r\n", adc_ctr12_reg, adc_ctr34_reg);
			printf("* ------------------------------------*-------------------------------------*\r\n");
			printf("* Selected_Timebase       : %5d     * dmode_Selected_Timebase  : %5d    *\r\n", Selected_Timebase, dmode_Selected_Timebase);
			printf("* Timebase_Idx            : %5d     * SIGNALFaktor_idx         : %5d    *\r\n", Timebase_Idx, SIGNALFaktor_idx);
			printf("* SIGNAL_StartFr_idx      : %5d     * timebase_reg             : %8x *\r\n", SIGNAL_StartFr_idx, timebase_reg);
			printf("*                                     "); printf("* Timebase_Ratio           : "); Display::floatprintf(Timebase_Ratio);printf("    *\r\n");
			printf("* Cursor_Delayed_1        : %5d     *                                     *\r\n", Cursor_Delayed_1);
			printf("* Cursor_Delayed_2        : %5d     * Cursor_Delayed_Size      : %5d    *\r\n", Cursor_Delayed_2, Cursor_Delayed_Size);
			printf("* dmode_Window_Offset_Pos : %5d     *                                     *\r\n", dmode_Window_Offset_Pos);
			printf("* draw_start              : %5d     * draw_dm_ixstart          : %5d    *\r\n", draw_start, draw_dm_ixstart);
//			printf("* draw_factor             : %5d     * draw_dm_ixoffset         : %5d    *\r\n", draw_factor, draw_dm_ixoffset);
			printf("* draw_factor             : %5d     *                                     *\r\n", draw_factor);
			printf("* MemWinStart             : %5d     * draw_dm_ixfactor         : %5d    *\r\n", MemWinStart, draw_dm_ixfactor);
			printf("* Trig_Pos_Mem            : %5d     * Trig_Pos_Display         : %5d    *\r\n", Trig_Pos_Mem, Trig_Pos_Display);
			printf("* Trig_Pos_Mem_old        : %5d     * Trig_Pos_Display_old     : %5d    *\r\n", Trig_Pos_Mem_old, Trig_Pos_Display_old);
			printf("* ------------------------------------*-------------------------------------*\r\n");
			printf("* Triggering              : %5d     *                                     *\r\n", triggering );
			printf("* SelectedTriggerSource   : %5d     * SelectedTriggerSourceOld : %5d    *\r\n", Selected_Trigger_Source, Selected_Trigger_Source_Old);
			printf("* TriggerWay              : %5d     * ExtraTrg Mode            : %5d    *\r\n",TriggerWay , ExtraTrg_Mode);
			//BF printf("* SelectedEdgeExtern      : %5d     * TriggerWay               : %5d    *\r\n", SelectedEdgeExtern, TriggerWay );
			printf("* Trigger_Pos_CH1         : %5d     * Trigger_Pos_CH2          : %5d    *\r\n", Trigger_Pos_CH1, Trigger_Pos_CH2);
			printf("* Trigger_Pos_CH3         : %5d     * Trigger_Pos_CH4          : %5d    *\r\n", Trigger_Pos_CH3, Trigger_Pos_CH4);
			printf("* Trigger_Pos_CHE         : %5d     *                          :          *\r\n", Trigger_Pos_CHE);
			printf("* HoldOff_Value           : %5d     * trig_holdoff_reg         : %8x *\r\n", HoldOff_Value, trig_holdoff_reg);
			printf("* ------------------------------------*-------------------------------------*\r\n");
			printf("* Selected_Voltage_CH1    : %5d     * CH1_DAC_Offset           : %5d    *\r\n", Selected_Voltage_CH1, CH1_DAC_Offset);
			printf("* Selected_Voltage_CH2    : %5d     * CH2_DAC_Offset           : %5d    *\r\n", Selected_Voltage_CH2, CH2_DAC_Offset);
			printf("* Selected_Voltage_CH3    : %5d     * CH3_DAC_Offset           : %5d    *\r\n", Selected_Voltage_CH3, CH3_DAC_Offset);
			printf("* Selected_Voltage_CH4    : %5d     * CH4_DAC_Offset           : %5d    *\r\n", Selected_Voltage_CH4, CH4_DAC_Offset);
			printf("* CH1 DAC correction 1    : %5d     * CH3 DAC correction 1     : %5d    *\r\n", DAC_Correction[0][0], DAC_Correction[2][0]);
			printf("* CH1 DAC correction 2    : %5d     * CH3 DAC correction 2     : %5d    *\r\n", DAC_Correction[0][1], DAC_Correction[2][1]);
			printf("* CH1 DAC correction 3    : %5d     * CH3 DAC correction 3     : %5d    *\r\n", DAC_Correction[0][2], DAC_Correction[2][2]);
			printf("* CH2 DAC correction 1    : %5d     * CH4 DAC correction 1     : %5d    *\r\n", DAC_Correction[1][0], DAC_Correction[3][0]);
			printf("* CH2 DAC correction 2    : %5d     * CH4 DAC correction 2     : %5d    *\r\n", DAC_Correction[1][1], DAC_Correction[3][1]);
			printf("* CH2 DAC correction 3    : %5d     * CH4 DAC correction 3     : %5d    *\r\n", DAC_Correction[1][2], DAC_Correction[3][2]);
			printf("* CH1 ADC 1 Offset        : %5d     * CH3 ADC 1 Offset         : %5d    *\r\n", ADC_Offset[0][0], ADC_Offset[2][0]);
			printf("* CH1 ADC 2 Offset        : %5d     * CH3 ADC 2 Offset         : %5d    *\r\n", ADC_Offset[0][1], ADC_Offset[2][1]);
			printf("* CH1 ADC 3 Offset        : %5d     * CH3 ADC 3 Offset         : %5d    *\r\n", ADC_Offset[0][2], ADC_Offset[2][2]);
			printf("* CH1 ADC 4 Offset        : %5d     * CH3 ADC 4 Offset         : %5d    *\r\n", ADC_Offset[0][3], ADC_Offset[2][3]);
			printf("* CH2 ADC 1 Offset        : %5d     * CH4 ADC 1 Offset         : %5d    *\r\n", ADC_Offset[1][0], ADC_Offset[3][0]);
			printf("* CH2 ADC 2 Offset        : %5d     * CH4 ADC 2 Offset         : %5d    *\r\n", ADC_Offset[1][1], ADC_Offset[3][1]);
			printf("* CH2 ADC 3 Offset        : %5d     * CH4 ADC 3 Offset         : %5d    *\r\n", ADC_Offset[1][2], ADC_Offset[3][2]);
			printf("* CH2 ADC 4 Offset        : %5d     * CH4 ADC 4 Offset         : %5d    *\r\n", ADC_Offset[1][3], ADC_Offset[3][3]);
			printf("* ------------------------------------*-------------------------------------*\r\n");
			printf("* Virtual_ZeroLevelCH1    : %5d     * ZeroLevelCH1             : %5d    *\r\n", Virtual_ZeroLevelCH1, ZeroLevelCH1);
			printf("* Virtual_ZeroLevelCH2    : %5d     * ZeroLevelCH2             : %5d    *\r\n", Virtual_ZeroLevelCH2, ZeroLevelCH2);
			printf("* Virtual_ZeroLevelCH3    : %5d     * ZeroLevelCH3             : %5d    *\r\n", Virtual_ZeroLevelCH3, ZeroLevelCH3);
			printf("* Virtual_ZeroLevelCH4    : %5d     * ZeroLevelCH4             : %5d    *\r\n", Virtual_ZeroLevelCH4, ZeroLevelCH4);
			printf("* SwitchesCH1             : %5d     * SwitchesCH2              : %5d    *\r\n", SwitchesCH1, SwitchesCH2);
			printf("* SwitchesCH3             : %5d     * SwitchesCH4              : %5d    *\r\n", SwitchesCH3, SwitchesCH4);
			printf("* SwitchesTB              : %5d     *                                     *\r\n", SwitchesTB );
			printf("* CursVertPos Real1       : %5d     *  CursVertPos Real2       : %5d    *\r\n", Cursor_Vertical_Position_Real1, Cursor_Vertical_Position_Real2);
			printf("* CursVertPos RealXY1     : %5d     *  CursVertPos RealXY2     : %5d    *\r\n", Cursor_Vertical_Position_Real_XY_1, Cursor_Vertical_Position_Real_XY_2);
			printf("* CursHorPos Real1        : %5d     *  CursHorPos Real1        : %5d    *\r\n", Cursor_Horizontal_Position_Real1, Cursor_Horizontal_Position_Real2);
			printf("* m2k_filter_Mode         :  %4x     *  kill_adc                :  %4x    *\r\n", m2k_filter_Mode, kill_adc);		//BF -> check usage
			printf("* zeros_filter_Mode       :  %4x     *  tc_hw_version           : %8x *\r\n", zeros_filter_Mode, tc_hw_version);	//BF -> check usage
			printf("*****************************************************************************\r\n");
			printf("\n");






			break;
		}
		
		//--------------------------------------------
		// Test Funktion 70 .
		//--------------------------------------------
		case 70 :
		{		

			printf("\r\n");
			printf("*****************************************************************************\r\n");
			printf("* Interrupts                          *                                     *\r\n");
			printf("*****************************************************************************\r\n");		
			printf("* ADC Interrupt Edge      : %5d     * Keyboard IRQ Edge        : %5d    *\r\n", acq_ready->np_pioedgecapture, key_int->np_pioedgecapture);
			printf("* ADC Interrupt           : %5d     * Keyboard IRQ             : %5d    *\r\n", acq_ready->np_piodata, acq_ready->np_piodata);
		//            printf("*                                    *                                    *\n");
			printf("*****************************************************************************\r\n");
			printf("\r\n");
		
			break;
		}

		//--------------------------------------------
		// Test Funktion 71 -
		//--------------------------------------------
		case 71 :
		{		
			xm = 100;
			ym = 20;
			res_xm = nm_mult(xm, ym);
	
			printf("mult 100 x 20 = %d\n", res_xm);
	
			xm = -100;
			ym = 20;
			res_xm = nm_mult(xm, ym);
	
			printf("mult -100 x 20 = %d\n", res_xm);		
	
			xm = 54;
			ym = 55;
			res_xm = nm_mult(xm, ym);
	
			printf("mult 74 x 55 = %d\n", res_xm);
			
			xm = -74;
			ym = 55;
			res_xm = nm_mult(xm, ym);
	
			printf("mult -54 x 55 = %d\n", res_xm);		

			break;
		}

		//--------------------------------------------
		// Test Funktion 31 !
		//--------------------------------------------
		case 80 :
		{		
/*			if (multi_active)
			{
				multi_active = false;
				SwitchesCH1 &= 0x7FFF;					
				SetSwitches(1, -1);
			}
			else
			{
				multi_active = true;
				SwitchesCH1 |= 0x8000;					
				SetSwitches(1, -1);
			}


            		printf("CH I Multiplier Active : %d\n", multi_active);
*/
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 31 "
		//--------------------------------------------
		case 81 :
		{		
			pre_reg--;
		
			Hardware::SetupADC();	
			
			printf("pre_reg : %i\n", pre_reg);

			break;
		}

		//--------------------------------------------
		// Test Funktion 32 §
		//--------------------------------------------
		case 82 :
		{		
			pre_reg++;
		
			Hardware::SetupADC();	
			
			printf("pre_reg : %i\n", pre_reg);

			break;
		}

		//--------------------------------------------
		// Test Funktion 33 $
		//--------------------------------------------
		case 83 :
		{	
		
			pre_reg -= 10;
		
			Hardware::SetupADC();	
		
			printf("pre_reg : %i\n", pre_reg);

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 34 %
		//--------------------------------------------
		case 84 :
		{		
			pre_reg += 10;
		
			Hardware::SetupADC();	
		
			printf("pre_reg : %i\n", pre_reg);

			break;
		}

		//--------------------------------------------
		// Test Funktion 35 &
		//--------------------------------------------
		case 85 :
		{		
			if (XY_Mode) XY_Mode = 0;
			else XY_Mode = 1;
				
			printf("Display Mode %d\n", XY_Mode);

			break;
		}

		//--------------------------------------------
		// Test Funktion 36 /
		//--------------------------------------------
		case 86 :
		{		
			if (SIGNALFaktor_idx == 0) pre_reg = pre_reg - 6;
			else if (SIGNALFaktor_idx == 1) pre_reg = pre_reg - 10;
			else if (SIGNALFaktor_idx == 2) pre_reg = pre_reg - 18;
			else if (SIGNALFaktor_idx == 3) pre_reg = pre_reg - 55;
			else if (SIGNALFaktor_idx == 4) pre_reg = pre_reg - 90;
		
			Hardware::SetupADC();
		
		
			printf("Test Pre Reg manipulation\n");

			break;
		}

		//--------------------------------------------
		// Test Funktion 37 (
		//--------------------------------------------
		case 87 :
		{	
			printf("MenuPopupStatus\n");
			for (ix2 = 0; ix2 < 30; ix2++)
			{
				printf("MPS[%2d] : ", ix2);
				
				for (ix = 0; ix < 21; ix++)
				{
				printf("%2d ", MenuPopupStatus[ix2][ix]);
				}
				printf("\n");
			}

			break;
		}

		//--------------------------------------------
		// Test Funktion 38 )
		//--------------------------------------------
		case 88 :
		{		
			ix = (int) (Pulse11.Read_Value() * 100000000);			
			printf("PV 11 RV : % d Va : %d St : %d Ex : %d\n", ix, Pulse11_Value, Pulse11_Steps, Pulse11_Expo);
			ix = (int) (Pulse12.Read_Value() * 100000000);			
			printf("PV 12 RV : % d Va : %d St : %d Ex : %d\n", ix, Pulse12_Value, Pulse12_Steps, Pulse12_Expo);
		
			ix = (int) (Pulse21.Read_Value() * 100000000);			
			printf("PV 21 RV : % d Va : %d St : %d Ex : %d\n", ix, Pulse21_Value, Pulse21_Steps, Pulse21_Expo);
			ix = (int) (Pulse22.Read_Value() * 100000000);			
			printf("PV 22 RV : % d Va : %d St : %d Ex : %d\n", ix, Pulse22_Value, Pulse22_Steps, Pulse22_Expo);

			break;
		}

		//--------------------------------------------
		// Test Funktion 39 =
		//--------------------------------------------
		case 89 :
		{
			printf("*****************************************************************************\n");
			printf("* CH 1 V  0 : %3d    CH 2 V  0 : %3d    CH 3 V  0 : %3d    CH 4 V  0 : %3d  *\n",ADC_Offset[0][0],ADC_Offset[1][0],ADC_Offset[2][0],ADC_Offset[3][0]);
			printf("* CH 1 V  1 : %3d    CH 2 V  1 : %3d    CH 3 V  1 : %3d    CH 4 V  1 : %3d  *\n",ADC_Offset[0][1],ADC_Offset[1][1],ADC_Offset[2][1],ADC_Offset[3][1]);
			printf("* CH 1 V  2 : %3d    CH 2 V  2 : %3d    CH 3 V  2 : %3d    CH 4 V  2 : %3d  *\n",ADC_Offset[0][2],ADC_Offset[1][2],ADC_Offset[2][2],ADC_Offset[3][2]);
			printf("* CH 1 V  3 : %3d    CH 2 V  3 : %3d    CH 3 V  3 : %3d    CH 4 V  3 : %3d  *\n",ADC_Offset[0][3],ADC_Offset[1][3],ADC_Offset[2][3],ADC_Offset[3][3]);
		
			printf("*****************************************************************************\n");
			printf("\n");

			break;
		}  	
	
		//--------------------------------------------
		// Test Funktion 40 x
		//--------------------------------------------
		case 91 :
		{		
			printf("****************************************************************************************\r\n");
			printf("Test function 40 (x) - free - \r\n");
			
			

			printf("\r\n****************************************************************************************\r\n");
			
			
			break;
		}
		//--------------------------------------------
		// Test Funktion 41 z
		//--------------------------------------------
		case 92 :
		{		
			printf("****************************************************************************************\r\n");
			printf("Test function 41 (z) - free - \r\n");
			
		
			

			printf("\r\n****************************************************************************************\r\n");
			
			
			break;
		}





	}
	if (Splash_drawed == false) UpdateMenuTextPlane = true;
}	

//######################################################################################################################################################
// BF insert
//Function button 1 pressed
void UserIF::F1_Btnhandler(void)					// Button Handler for function button
{ 
	short pos = 0;
	int ix;

#ifdef _Debug_		
       	printf("F1 Btn start\n");
#endif

	if (MenuPopupActive > 0) Hardware::ResetTimer();
//	if (ZeroPopupChanged > 0) Hardware::ResetTimer();

	if ((Active_Menu == 1) && (Channel_1_Active == false)) return;
	if ((Active_Menu == 2) && (Channel_2_Active == false)) return;
	if ((Active_Menu == 3) && (Channel_3_Active == false)) return;
	if ((Active_Menu == 4) && (Channel_4_Active == false)) return;
	if ((Active_Menu == 26) && (Channel_Math_Active == false)) return;	// BF del ???

	if ((Active_Menu == 16) && (Cursor_Enabled == false)) return;
	if ((Active_Menu == 19) && (QM_Enabled == false)) return;
	if ((Active_Menu == 20) && (QM_Enabled == false)) return;
	if ((Active_Menu == 21) && (QM_Enabled == false)) return;
	if ((Active_Menu == 22) && (QM_Enabled == false)) return;

	MenuButtonCheck(0);
	
	switch(Active_Menu)
	{
		// Acquire -> Normal
		case 0 :
		{			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_ACQUIRE][0] == 0)
			{
				MenuStatus[MENU_ACQUIRE][0] = 1;
				MenuItemChanged[0] = 1;

				MenuStatus[MENU_ACQUIRE][1] = 0;
				MenuItemChanged[1] = 1;

				MenuItemChanged[2] = 1;
				MenuStatus[MENU_ACQUIRE][2] = 0;

				New_Menu = 0;
				Menu_Changed = 1;
			}
				
			break;	
		}				

		// Channel 1 -> Coupling
		case 1 :
		{

			if (Channel_1_Active == 0) break;

			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 13)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 13)
			{
				pos = -1;
				MenuPopupStep(13, &MenuStatus[MENU_CHANNEL1][0], &pos, &pos, 1, 6, 2);
			}

			New_Menu = 1;
			Menu_Changed = 1;

			Display::DRAWMENUPOPUP(13);
			
			Hardware::SetSwitches(1, -1);

			//S Display::Update_Channel_Data(1);
		
			break;
		}

		// Channel 2 -> Coupling
		case 2 :
		{
			if (Channel_2_Active == 0) break;
			
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 14)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 14)
			{
				pos = -1;
				MenuPopupStep(14, &MenuStatus[MENU_CHANNEL2][0], &pos, &pos, 2, 6, 2);

			}				

			New_Menu = 2;
			Menu_Changed = 1;
								
			Display::DRAWMENUPOPUP(14);
			
			Hardware::SetSwitches(1, -1);

			//S Display::Update_Channel_Data(2);
	
			break;
		}

		// Channel 3 -> Coupling
		case 3 :
		{
			if (Channel_3_Active == 0) break;
			
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 15)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 15)
			{
				pos = -1;
				MenuPopupStep(15, &MenuStatus[MENU_CHANNEL3][0], &pos, &pos, 3, 6, 2);
			}				

			New_Menu = 3;
			Menu_Changed = 1;
							
			Display::DRAWMENUPOPUP(15);
			
			Hardware::SetSwitches(1, -1);

			//S Display::Update_Channel_Data(3);

			break;
		}

		// Channel 4 -> Coupling
		case 4 :
		{
			if (Channel_4_Active == 0) break;
			
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 16)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 16)
			{
				pos = -1;
				MenuPopupStep(16, &MenuStatus[MENU_CHANNEL4][0], &pos, &pos, 4, 6, 2);
			}				

			New_Menu = 4;
			Menu_Changed = 1;
				
			Display::DRAWMENUPOPUP(16);
			
			Hardware::SetSwitches(1, -1);
			
			//S Display::Update_Channel_Data(4);

			break;
		}						

		// Display -> Persist
		case 5 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_DISPLAY][0] == 240) MenuStatus[MENU_DISPLAY][0] = 241;
			else MenuStatus[MENU_DISPLAY][0] = 240;
			
			New_Menu = 5;
			Menu_Changed = 1;
	
			break;
		}		

		// Utility - About Oscilloscope		#004
		case 6 :
		{		
			Continius_bak = Continius;
			Continius = false;
			Hardware::ClearPlanes();
			Display::DRAW_SPLASH(false);
			break;
		}		

		
		// Timebase -> Main
		case 10 :
		{			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (MenuStatus[MENU_TIMEBASE][0] == 0);	// || XY_Mode == 1)	//Check if main mode is not active
			{
				//dmode_Window_Offset_Pos++; // for removing the cursor from delayed mode
				
				config_changed = 1;

				if (USTB_Mode != USTB_OFF)
				Signal::USTB_Clear_Buffer();
			
				if (MenuStatus[MENU_TIMEBASE][1] == 1)		//Delayed mode active?
				{			
					MenuItemChanged[1] = 1;
					MenuStatus[MENU_TIMEBASE][1] = 0;	//switch delayed mode off
									
				}
				else if (MenuStatus[MENU_TIMEBASE][2] == 1)	//XY-mode active?	
				{
					MenuItemChanged[2] = 1;
					MenuStatus[MENU_TIMEBASE][2]  = 0;	//switch XY-mode off
					XY_Mode            = 0; 		//switch XY-mode off, needed in On_Zero

					//BF added for restoring zero levels
					ZeroLevelCH1 = ZeroLevelCH1_Main_bak;
					ZeroLevelCH2 = ZeroLevelCH2_Main_bak;
					ZeroLevelCH3 = ZeroLevelCH3_Main_bak;
					ZeroLevelCH4 = ZeroLevelCH4_Main_bak;
					
					Virtual_ZeroLevelCH1 = Virtual_ZeroLevelCH1_Main_bak;
					Virtual_ZeroLevelCH2 = Virtual_ZeroLevelCH2_Main_bak;
					Virtual_ZeroLevelCH3 = Virtual_ZeroLevelCH3_Main_bak;
					Virtual_ZeroLevelCH4 = Virtual_ZeroLevelCH4_Main_bak;

					ON_Zero_Channel_1();
					ON_Zero_Channel_2();
					ON_Zero_Channel_3();	
					ON_Zero_Channel_4();	

				}

				//Draw main grid into grid plane
				Display::GRID(GRID_XOFFS, GRID_YOFFS, Grid_Plane);		
				//GridColor_Val = GridColorArray[GridColorArrayPos];		//Grid intensity
				//MenuStatus[MENU_DISPLAY][2] = GridColorArrayPos + 133;		//Menu text item
				//Hardware::SetupADC();							//set intensity
				
				MenuStatus[MENU_TIMEBASE][0] = 1;	//Main mode active
			
				TimebaseChanged     = 1;
				TriggerWayChanged   = 1;
				TriggerModeChanged  = 1;
				TriggerLevelChanged = 1;
	
				Hardware::SetupADC();

				Display::StatusUpdate();
	
				New_Menu     = 10;
				Menu_Changed = 1;
				Hardware::ClearPlanes();			
			}
			
			Display::DRAW_ALL_CURSOR();	
			
			Hardware::UpdateTrigger();
				
			break;		
		}

		// Trigger Mode -> Mode
		case 12 :
		{
			//BF add -> no normal trigger for USTB
			if (USTB_Mode != USTB_OFF)
			{
				MenuStatus[MENU_TRIGGERMODE][0] = 92;	//set automode
				return;
			}

			Menu_Popup_visible = 1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 9)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 9)
			{
				pos = -1;
				MenuPopupStep(9, &MenuStatus[MENU_TRIGGERMODE][0], &pos, &pos, 12, 92, 2);	

				New_Menu = 12;
				Menu_Changed = 1;
				TriggerLevelChanged = 1;
				TriggerModeChanged = 1;
		
				Hardware::UpdateTrigger();
				
				Display::StatusUpdate();	
			}				
			
			Display::DRAWMENUPOPUP(9);
			break;
		}			

		// Edge -> Rising/Falling
		case 14 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_TRIGGEREDGE][0] == 2) MenuStatus[MENU_TRIGGEREDGE][0] = 3;
			else MenuStatus[MENU_TRIGGEREDGE][0] = 2;
			
			TriggerLevelChanged = 1;
			TriggerWayChanged = 1;
			
			Hardware::UpdateTrigger();
			
			New_Menu = 14;
			Menu_Changed = 1;

			Display::StatusUpdate();

			break;	
		
		}		

		// Pulse Width -> Source
		case 15 :
		{		
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 7)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 7)
			{
				pos = -1;
				MenuPopupStep(7, &MenuStatus[MENU_PULSEWIDTH][0], &pos, &pos, 15, 137, 2);
				
				New_Menu = 15;
				Menu_Changed = 1;
				TriggerWayChanged = 1;
			}				
			
			Display::StatusUpdate();		
			Display::DRAWMENUPOPUP(7);
			
			Hardware::UpdateTrigger();
			
			break;			
		}				
	
		// Cursor -> Source
		case 16 :
		{
			if (!Cursor_Enabled) break;

			if(FFT_Mode != FFT_OFF) break;

			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 1)) Display::DRAWMENUPOPDOWN();
			if (MenuPopupActive == 1)
			{
				pos = -1;
				MenuPopupStep(1, &MenuStatus[MENU_CURSOR][0], &pos, &pos, 16, 27, 2);
				MenuItemChanged[3] = 1;
				MenuItemChanged[4] = 1;
				Display::CALCCURSORDATA();
				
				CursorChanged = 3;
				New_Menu = 16;
				Menu_Changed = 1;
			}
			else if (MenuPopupActive == -1)
			{
				New_Menu = 16;
				Menu_Changed = 1;
			}
			Display::DRAWMENUPOPUP(1);

			break;
		}
		// Quick Print -> Save to BMP
		// BF -> new screenshot function from Niklas 
		case 17 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			//MenuItemChanged[0] = 1;
							
			New_Menu = 17;
			Menu_Changed = 1;

			CommIF::SCREENSHOT('B');	//save to BMP
			//CommIF::SendShot();		

			break;					
		}


		// Hardware - ADC Register settings		BF #004
		case 18 :
		{	

			if ((MenuPopupActive > -1) && (MenuPopupActive != 37))
			{ Display::DRAWMENUPOPDOWN(); }
			
			if (MenuPopupActive == 37)
			{
				pos = -1;
				MenuPopupStep(37, &MenuStatus[MENU_HARDWARE][0], &pos, &pos, MENU_HARDWARE, 223, 2);
			}

			New_Menu = MENU_HARDWARE;
			Menu_Changed = 1;

			switch(MenuStatus[MENU_HARDWARE][0])
			{
				case 223: //Factory setting	 
				{ AMDFlash::ReadProtReg(); break; }		//BF standard factory setting causes resonance problems at high frequencies

				case 224: //High Freq/		
				{ 
					adc_change12_reg = 0x01000000;		//BF Bit 24 for spike suppression
					adc_change34_reg = 0x01000000;		//BF Bit 24 for spike suppression
					channel_Adr_add12 = 0x5F0A;
					channel_Adr_add34 = 0x5F0A;
					break;	
				}	
	
				case 225: //Test 1
				{
					adc_change12_reg = 0x20000;		//BF Falks setting
					adc_change34_reg = 0x20000;		//BF Falks setting
					break;
			    	}	
				case 226: //Test 2
				{ 
					adc_change12_reg = 0x03020800;		//BF Bit 24 for spike suppression
					adc_change34_reg = 0x03020800;		//BF Bit 24 for spike suppression
					//channel_Adr_add12 = 0x5F0A;
					//channel_Adr_add34 = 0x5F0A;	
					break;
			   	}
				case 227: //Test 3
				{ 	
					adc_change12_reg = 0x01020800;		//BF Bit 24 for spike suppression
					adc_change34_reg = 0x01020800;		//BF Bit 24 for spike suppression
					//channel_Adr_add12 = 0x570A;		//BF Flash Value of hardware rev.
					//channel_Adr_add34 = 0x5F5F;	
					break;
				}
				case 228: //Test 4
				{ 	
					adc_change12_reg = 0x00000000;		//BF Bit 24 for spike suppression
					adc_change34_reg = 0x00000000;		//BF Bit 24 for spike suppression
					//channel_Adr_add12 = 0x570A;		//BF Flash Value of hardware rev.
					//channel_Adr_add34 = 0x5F5F;	
					break;
				}	
				case 229: //Test 5
				{ 	
					adc_change12_reg = 0x02020800;		//BF Bit 24 for spike suppression
					adc_change34_reg = 0x02020800;		//BF Bit 24 for spike suppression
					//channel_Adr_add12 = 0x570A;		//BF Flash Value of hardware rev.
					//channel_Adr_add34 = 0x5F5F;	
					break;
				}



			}
			//Hardware::Stop_Record();
			//nr_delay(50);

			Hardware::SetupADC();
			nr_delay(50);

			Display::DRAWMENUPOPUP(37);	

			//if (!SingleMode && Continius && !AS_request && !RC_request)
			//{ Hardware::Start_Record(); } 

			break;
		}			

		
		// Quick Measurement -> Source
		case 19 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
			if (QM_Enabled == 0) break;
		
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 3)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 3)
			{
				pos = -1;
				MenuPopupStep(3, &MenuStatus[MENU_QUICKMEASURE][0], &pos, &pos, 19, 27, 2);
				
				New_Menu = 19;
				Menu_Changed = 1;
			}				
		
			Display::DRAWMENUPOPUP(3);
			break;
		}	
		
		// Quick Measurement Delay Settings
		case 20 :
		{	
		//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
		if (QM_Enabled == 0) break;

			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 5)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 5)
			{
				pos = -1;
				MenuPopupStep(5, &MenuStatus[MENU_QMDELAY][0], &pos, &pos, 20, 27, 2);
				
				New_Menu = 20;
				Menu_Changed = 1;
			}				
		
			Display::DRAWMENUPOPUP(5);
			break;
		}	

		// Quick Measurement Phase Settings
		case 21 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if ((MenuPopupActive > -1) && (MenuPopupActive != 24)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 24)
			{
				pos = -1;
				MenuPopupStep(24, &MenuStatus[MENU_QMPHASES][0], &pos, &pos, MENU_QMPHASES, 27, 2);
				
				New_Menu = MENU_QMPHASES;
				Menu_Changed = 1;
			}				
		
			Display::DRAWMENUPOPUP(24);
			break;
		}	

		// Quick Measurement Thresholds
		case 22 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;

			if (QM_Enabled == 0) break;
			if ((MenuPopupActive > -1) && (MenuPopupActive != 26)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 26)
			{
				pos = -1;
				MenuPopupStep(26, &MenuStatus[MENU_QMTHRESHOLDS][0], &pos, &pos, MENU_QMTHRESHOLDS, 27, 2);
			}

			New_Menu = MENU_QMTHRESHOLDS;
			Menu_Changed = 1;

			Display::DRAWMENUPOPUP(26);					
			
			
			break;
		}	

		// AutoScale -> Undo
		case 23 :
		{
			if (FFT_Mode != FFT_OFF) break;		// no autoscale in FFT-mode

			Hardware::Restore_From_Flash();
			if (!SingleMode && Continius && !AS_request && !RC_request)
			{ Hardware::Start_Record(); } 

			break;
		}

		// Trigger Mode TV
		case 24 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			break;
		}

		// More Utilities - CH1 Delay			BF #001
		case 25 :
		{	

			if ((MenuPopupActive > -1) && (MenuPopupActive != 33))
			{ Display::DRAWMENUPOPDOWN(); }
			
			if (MenuPopupActive == 33)
			{
				pos = -1;
				MenuPopupStep(33, &MenuStatus[MENU_EXTUTILS][0], &pos, &pos, MENU_EXTUTILS, 203, 2);
			}

			New_Menu = MENU_EXTUTILS;
			Menu_Changed = 1;

			CH1_Del_Correct = MenuStatus[MENU_EXTUTILS][0] - 203;

			Display::DRAWMENUPOPUP(33);	

			break;
		}					

		// Math - Settings sub menu
		case 26 :
		{			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			MenuItemChanged[2] = 1;
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
	
			if (MenuStatus[MENU_MATH][1] == 1)	New_Menu = 27;		// FFT  Settings Menu
			else if (MenuStatus[MENU_MATH][2] == 1) New_Menu = 29;		// Math Settings Menu
			else if (MenuStatus[MENU_MATH][3] == 1) New_Menu = 29;		// Math Settings Menu
			else if (MenuStatus[MENU_MATH][4] == 1) New_Menu = 29;		// Math Settings Menu						

			Menu_Changed = 1;
		
			//printf("We are here and NewMenu is %d Active_Menu is %d MenuAktive is %d\n", New_Menu, Active_Menu, MenuAktive);
			
			break;
		}

		// FFT - Settings - source channel
		case 27 :
		{	

			if ((MenuPopupActive > -1) && (MenuPopupActive != 29))
			{ Display::DRAWMENUPOPDOWN(); }
			
			if (MenuPopupActive == 29)	//if popup is active...
			{
				pos = -1;
				MenuPopupStep(29, &MenuStatus[MENU_FFT][0], &pos, &pos, MENU_FFT, 137, 2);	//...step to next entry
			}

			New_Menu = MENU_FFT;
			Menu_Changed = 1;

			Display::DRAWMENUPOPUP(29);		// display popup
			
			Hardware::FFT_Set_Channel(0);		// set active channel without backup
			
			Display::FFT_DrawStatus(0);		//draw FFT values in status area

			break;
		}					
		
		// Math Settings Scale
		case 29 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			MathToggle = 0;
			
			Menu_Changed = 1;
			MenuItemChanged[0] = 1;
			MenuItemChanged[1] = 1;
			
			break;
		}				
	}					
#ifdef _Debug_			
			if (Debug_Mode) printf("Function Button 1\n");		
#endif
}
// BF insert end
//######################################################################################################################################################
// BF insert
//Function button 2 pressed
void UserIF::F2_Btnhandler(void)					// Button Handler for function button
{

	short pos = 0;
	int ix;

	if (MenuPopupActive > 0) Hardware::ResetTimer();

	if ((Active_Menu == 1) && (Channel_1_Active == false)) return;
	if ((Active_Menu == 2) && (Channel_2_Active == false)) return;
	if ((Active_Menu == 3) && (Channel_3_Active == false)) return;
	if ((Active_Menu == 4) && (Channel_4_Active == false)) return;
	//if ((Active_Menu == 26) && (Channel_Math_Active == false)) return;

	if ((Active_Menu == 16) && (Cursor_Enabled == false)) return;
	if ((Active_Menu == 19) && (QM_Enabled == false)) return;
	if ((Active_Menu == 20) && (QM_Enabled == false)) return;
	if ((Active_Menu == 21) && (QM_Enabled == false)) return;
	if ((Active_Menu == 22) && (QM_Enabled == false)) return;

	MenuButtonCheck(1);
			
	switch(Active_Menu)
	{
		// Acquire -> Averaging
		case 0 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_ACQUIRE][1] == 0)
			{
				MenuItemChanged[0] = 1;
				MenuStatus[MENU_ACQUIRE][0] = 0;
		
				MenuItemChanged[1] = 1;
				MenuStatus[MENU_ACQUIRE][1] = 1;

				MenuItemChanged[2] = 1;
				MenuStatus[MENU_ACQUIRE][2] = 0;

				New_Menu = 0;
				Menu_Changed = 1;
			}
				
			break;							
		}

		// Channel 1 -> BW Linit
		case 1 :
		{
			if (Channel_1_Active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_CHANNEL1][1] == 240) MenuStatus[MENU_CHANNEL1][1] = 241;
			else MenuStatus[MENU_CHANNEL1][1] = 240;					
			
			Hardware::SetSwitches(1, -1);

			New_Menu = 1;
			Menu_Changed = 1;
			
			break;
		}

		// Channel 2 -> BW Linit
		case 2 :
		{
			if (Channel_2_Active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_CHANNEL2][1] == 240) MenuStatus[MENU_CHANNEL2][1] = 241;
			else MenuStatus[MENU_CHANNEL2][1] = 240;
			
			Hardware::SetSwitches(2, -1);

			New_Menu = 2;
			Menu_Changed = 1;
			
			break;
		}

		// Channel 3 -> BW Linit
		case 3 :
		{
			if (Channel_3_Active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_CHANNEL3][1] == 240) MenuStatus[MENU_CHANNEL3][1] = 241;
			else MenuStatus[MENU_CHANNEL3][1] = 240;
			
			Hardware::SetSwitches(3, -1);

			New_Menu = 3;
			Menu_Changed = 1;
			
			break;
		}

		// Channel 4 -> BW Limit
		case 4 :
		{
			if (Channel_4_Active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_CHANNEL4][1] == 240) MenuStatus[MENU_CHANNEL4][1] = 241;
			else MenuStatus[MENU_CHANNEL4][1] = 240;
			
			Hardware::SetSwitches(4, -1);

			New_Menu = 4;
			Menu_Changed = 1;
			
			break;
		}		

		// Display -> Clear Display
		case 5 :
		{		
			if ((Continius == false) || (MenuStatus[MENU_DISPLAY][0] == 241)) Hardware::ClearPlanes();
			break;
		}
		
		// Utility -> Calibrate Zero Lines	#004
		case 6 :
		{
			UI_request = 0;
			Search_Step = 0;
			Search_Mode = true;
			
			Hardware::SearchZeros();
			//Hardware::Calibrate_ZeroOffsets();	

			if (Continius)
			{
				LED_ON[12] = 1;
				LED_ON[13] = 0;
				Hardware::Send_LED();
			}

			break;		
		}	
				
		// Service
		case 7 :
		{		
			//
			break;
		}

		// Save / Recall  - > Save
		case 8 :
		{	
			AMDFlash::SaveTrace();	//BF #016
			break;
		}
		
		// Timebase -> Delayed Mode (function button 2)
		case 10 :
		{			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			if (MenuStatus[MENU_TIMEBASE][1] == 1)	{break;}	//Check delayed mode is not active yet

			if (Selected_Timebase ==  0) {break;}			//BF #003 no delayed mode for timebase 2ns


			if (MenuStatus[MENU_TIMEBASE][0] == 1)			//main mode active?
			{
				MenuItemChanged[0]           = 1;
				MenuStatus[MENU_TIMEBASE][0] = 0;		//switch off main mode
			}			
			else if (MenuStatus[MENU_TIMEBASE][2] == 1)		//XY-mode active?
			{
				MenuItemChanged[2]           = 1;
				MenuStatus[MENU_TIMEBASE][2] = 0;		//switch off XY-mode		
				XY_Mode 	             = 0;

				//BF added for restoring zero levels
				ZeroLevelCH1 = ZeroLevelCH1_Main_bak;
				ZeroLevelCH2 = ZeroLevelCH2_Main_bak;
				ZeroLevelCH3 = ZeroLevelCH3_Main_bak;
				ZeroLevelCH4 = ZeroLevelCH4_Main_bak;
				
				Virtual_ZeroLevelCH1 = Virtual_ZeroLevelCH1_Main_bak;
				Virtual_ZeroLevelCH2 = Virtual_ZeroLevelCH2_Main_bak;
				Virtual_ZeroLevelCH3 = Virtual_ZeroLevelCH3_Main_bak;
				Virtual_ZeroLevelCH4 = Virtual_ZeroLevelCH4_Main_bak;

				ON_Zero_Channel_1();
				ON_Zero_Channel_2();
				ON_Zero_Channel_3();
				ON_Zero_Channel_4();

			}
//BF menu logic for FFT must be checked
			else if (MenuStatus[MENU_MATH][1] == 1)			//FFT active?
			{
				MenuItemChanged[1] = 1;
				MenuStatus[MENU_MATH][1]  = 0;			//Switch off FFT
				MenuStatus[MENU_MATH][3]  = 1;			//Set 1 - 2 as default
				MenuItemChanged[3] = 1;
				if (Channel_Math_Active)			//Math function active?
				{
					LED_ON[4] = 0;
					Channel_Math_Active = 0;		//switch off math function
				}

				Hardware::Send_LED();

			}
//BF end

			MenuStatus[MENU_TIMEBASE][1] = 1;			// switch on delayed mode

			New_Menu     = 10;
			Menu_Changed = 1;
/*
				Display::GRIDDELAYED(GRID_XOFFS, GRID_YOFFS, Grid_Plane);		//draw grid
				GridColor_Val = GridColorArray[GridColorArrayPos_Delayed];		//grid intensity
				MenuStatus[MENU_DISPLAY][2] = GridColorArrayPos_Delayed + 133;		//menu item text
				Hardware::SetupADC();								//set intensity
*/
			Display::RefreshScreen();

			config_changed = 1;
			
			
//BF del not used	dmode_SIGNAL_StartFr_idx = SIGNAL_StartFr_idx;
//BF del #003			dmode_Selected_Timebase  = Selected_Timebase;
			dmode_Selected_Timebase  =  0;	//BF #003
//BF del			dmode_SIGNALFaktor_idx   = SIGNALFaktor_idx;			//BF #003 ???? to be checked

/* BF redundant	
			if (dmode_SIGNALFaktor_idx == 0)
				dmode_Selected_Timebase--;
			else
				dmode_SIGNALFaktor_idx--;
	
			Timebase_Ratio = Timebase_Delayed_Factor_Matrix[Selected_Timebase][SIGNALFaktor_idx] / Timebase_Delayed_Factor_Matrix[dmode_Selected_Timebase][dmode_SIGNALFaktor_idx];
	
			Cursor_Delayed_1 = ((GRID_WIDTH/2) - (int) (((float) GRID_WIDTH / Timebase_Ratio) / 2)) + dmode_Window_Offset_Pos;
			Cursor_Delayed_2 = Cursor_Delayed_1 + (int) ((float) GRID_WIDTH / Timebase_Ratio);
			Cursor_Delayed_Size = Cursor_Delayed_2 - Cursor_Delayed_1;
*/	
			Hardware::RecalcTimeParameters();
			
			Display::DRAW_ALL_CURSOR();
			Hardware::ClearPlanes();
	
			TimebaseChanged     = 1;
			SIGNALFaktorChanged = 1;
				
			Display::DRAWSTATUS(0, 1);
				
			break;	
		}
	
		// Trigger Mode -> Coupling
		case 12 :
		{
			Menu_Popup_visible = 1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 10)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 10)
			{
				pos = -1;
				MenuPopupStep(10, &MenuStatus[MENU_TRIGGERMODE][1], &pos, &pos, 12, 95, 2);
				
				New_Menu = 12;
				Menu_Changed = 1;
			}				
			
			Hardware::UpdateTrigger();	
			
			Display::DRAWMENUPOPUP(10);
			break;
		}					
	
		// Edge -> source
		case 14 :
		{				
			Menu_Popup_visible = 1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 28)) { Display::DRAWMENUPOPDOWN(); }

/*BF del test
			// check if any channel is inactive and not available -> then grey out
			if (!Channel_1_Active) MenuPopupStatus[7][0] = 1;
			if (!Channel_2_Active) MenuPopupStatus[7][1] = 1;
			if (NumberOfChannels == 4)
			{
				if (!Channel_3_Active) MenuPopupStatus[7][2] = 1;
				if (!Channel_4_Active) MenuPopupStatus[7][3] = 1;
			}
			else { MenuPopupStatus[7][2] = 0; MenuPopupStatus[7][3] = 0; }
			
			//if no trigger source is active search for the next available channel
			if ((MenuPopupStatus[7][0] != 3) && (MenuPopupStatus[7][1] != 3) && (MenuPopupStatus[7][2] != 3) && (MenuPopupStatus[7][3] != 3) && (MenuPopupStatus[7][4] != 3)) //BF #019
			{
				if (Channel_1_Active) MenuPopupStatus[7][0] = 3;
				else if (Channel_2_Active) MenuPopupStatus[7][1] = 3;
				else if (Channel_3_Active) MenuPopupStatus[7][2] = 3;
				else if (Channel_4_Active) MenuPopupStatus[7][3] = 3;
			}
*/
			//process menu popup
			if (MenuPopupActive == 28)
			{
				pos = -1;
				MenuPopupStep(28, &MenuStatus[MENU_TRIGGEREDGE][1], &pos, &pos, 28, 137, 2);
				
				New_Menu = Active_Menu;
				Menu_Changed = 1;
			}	

/*BF del #019
			//get new trigger source
			if (MenuPopupStatus[7][0] == 3) MenuStatus[MENU_TRIGGEREDGE][1] = 138;
			else if (MenuPopupStatus[7][1] == 3) MenuStatus[MENU_TRIGGEREDGE][1] = 139;
			else if (MenuPopupStatus[7][2] == 3) MenuStatus[MENU_TRIGGEREDGE][1] = 140;
			else if (MenuPopupStatus[7][3] == 3) MenuStatus[MENU_TRIGGEREDGE][1] = 141;
			else if (MenuPopupStatus[7][3] == 3) MenuStatus[MENU_TRIGGEREDGE][1] = 141;
*/	
			
/*BF del #019
			MenuStatus[MENU_TRIGGEREDGE][2] = 0;
			MenuItemChanged[2] = 1;	
		
			MenuStatus[MENU_TRIGGEREDGE][3] = 0;
			MenuItemChanged[3] = 1;
*/
			MenuItemChanged[1] = 1;	
			Display::DRAWMENUPOPUP(28);
			
			//BF del Selected_Trigger_Source = MenuStatus[MENU_TRIGGEREDGE][1] - 136;
			
//BF del #019			SelectedEdgeExtern = 0;               // No External


			if (MenuStatus[MENU_TRIGGEREDGE][1] == 141)	//external active?
			{
				if ( MenuStatus[MENU_TRIGGERMODE][0] == 94 )	// if Combi-Trigger active -> switch to Auto and set Combi Trigger inactive
				{ MenuStatus[MENU_TRIGGERMODE][0] = 92; MenuPopupStatus[9][0] = 3; TriggerModeChanged = 1;}
				MenuPopupStatus[9][2] = 1;
				MenuItemChanged[2] = 1;			
				//MenuStatus[MENU_TRIGGEREDGE][2] = 128;	//BF set External trigger menu active -> in StatusUpdate()
			}
			else
			{
				if ( MenuStatus[MENU_TRIGGEREDGE][2] != 246 )
				{ MenuItemChanged[2] = 1; MenuStatus[MENU_TRIGGEREDGE][2] = 246; MenuPopupStatus[9][2] = 2;}	//BF set External trigger menu inactive and Combi Trigger available again
			}

			if (MenuStatus[MENU_TRIGGEREDGE][1] == 142)	//TV active?
			{
				if ( MenuStatus[MENU_TRIGGERMODE][0] == 94 )	// if Combi-Trigger active -> switch to Auto and set Combi Trigger inactive
				{ MenuStatus[MENU_TRIGGERMODE][0] = 92; MenuPopupStatus[9][0] = 3; TriggerModeChanged = 1;}
				MenuPopupStatus[9][2] = 1;
				MenuItemChanged[3] = 1;
				//MenuStatus[MENU_TRIGGEREDGE][3] = 131;	//BF set TV trigger menu active -> in StatusUpdate()
			}
			else
			{
				if ( MenuStatus[MENU_TRIGGEREDGE][3] != 246 )
				{ MenuItemChanged[3] = 1; MenuStatus[MENU_TRIGGEREDGE][3] = 246; MenuPopupStatus[9][2] = 2;}	//BF set TV trigger menu inactive and Combi Trigger available again
			}
			
			TriggerLevelChanged = 1;
			TriggerWayChanged = 1;		

			Hardware::UpdateTrigger();
				
			Display::StatusUpdate();
		
			break;
		}
		
		// Pulse Width -> Pulse
		case 15 :
		{
			break;
			/*
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_PULSEWIDTH][1] == 2) MenuStatus[MENU_PULSEWIDTH][1] = 3;
			else MenuStatus[MENU_PULSEWIDTH][1] = 2;

			New_Menu = 15;
			Menu_Changed = 1;
			TriggerWayChanged = 1;

			Display::StatusUpdate();
			
			Hardware::UpdateTrigger();
			
			break;	
			*/
		}
	
		// Cursor -> X1
		case 16 :
		{	
			if (Cursor_Enabled == 0) break;
			{
				if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
						
				if (Cursor_Vertical_Active_Old == 2) MenuItemChanged[2] = 1;
				else if (Cursor_Vertical_Active_Old == 4) MenuItemChanged[5] = 1;
				else if (Cursor_Horizontal_Active_Old == 1) MenuItemChanged[3] = 1;
				else if (Cursor_Horizontal_Active_Old == 2) MenuItemChanged[4] = 1;
				else if (Cursor_Horizontal_Active_Old == 4) MenuItemChanged[5] = 1;
						
				Cursor_Vertical_Active = 1;
				Cursor_Horizontal_Active = 3;
	
				if(FFT_Mode != FFT_OFF)
				Display::FFT_CalcCursorData();
				else
				Display::CALCCURSORDATA();
							
				New_Menu = 16;
				Menu_Changed = 1;
	
				Display::DRAW_ALL_CURSOR();
			}
			break;				
		}
		
		// Quick Print -> Save to PGM
		// BF -> new screenshot function from Niklas 
		case 17 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			//MenuItemChanged[1] = 1;
							
			New_Menu = 17;
			Menu_Changed = 1;

			CommIF::SCREENSHOT('P');	// save to PGM

			break;					
		}					

			
		// Hardware - Pre Amp Gain		BF #004
		// set scaling factors depending on hardware
		case 18 :
		{	
			if ((MenuPopupActive > -1) && (MenuPopupActive != 38))
			{ Display::DRAWMENUPOPDOWN(); }
			
			if (MenuPopupActive == 38)
			{
				pos = -1;
				MenuPopupStep(38, &MenuStatus[MENU_HARDWARE][1], &pos, &pos, MENU_HARDWARE, 230, 2);
			}

			GainIdx = MenuStatus[MENU_HARDWARE][1] - 230;	//set gain index to get the correct scaling

			if (Channel_1_Active) Hardware::SetSwitches(1, Selected_Voltage_CH1);
			if (Channel_2_Active) Hardware::SetSwitches(2, Selected_Voltage_CH2);
			if (Channel_3_Active) Hardware::SetSwitches(3, Selected_Voltage_CH3);
			if (Channel_4_Active) Hardware::SetSwitches(4, Selected_Voltage_CH4);

			New_Menu = MENU_HARDWARE;
			Menu_Changed = 1;
			
			config_changed = true;		//Save new values to flash

			Display::DRAWMENUPOPUP(38);	

			break;
		}			
	
		// Quick Measurement -> Select
		case 19 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
			if (QM_Enabled == 0) break;

			Menu_Popup_visible = 1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 4)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 4)
			{
				MenuPopupStep(4, &MenuStatus[MENU_QUICKMEASURE][1], &MenuStatus[MENU_QUICKMEASURE][2], &MenuStatus[MENU_QMDELAY][4], 19, 52, 2);
				MenuStatus[21][4] = MenuStatus[MENU_QMDELAY][4];
	
				if (((MenuStatus[MENU_QUICKMEASURE][1] - 52) == 4) || ((MenuStatus[MENU_QUICKMEASURE][1] - 52) == 13))
				{
				if (MenuStatus[MENU_QUICKMEASURE][4] == 244) MenuItemChanged[4] = 1;
				MenuStatus[MENU_QUICKMEASURE][4] = 242;
				}
				else
				{
				if (MenuStatus[MENU_QUICKMEASURE][4] == 242) MenuItemChanged[4] = 1;
				MenuStatus[MENU_QUICKMEASURE][4] = 244;
				}
	
				MenuItemChanged[1] = 1;
				MenuItemChanged[2] = 1;		
						
				New_Menu = 19;
				Menu_Changed = 1;
			}				
			
			Display::DRAWMENUPOPUP(4);
			
			Hardware::ResetTimer();
			
			break;
		}	
	
		// Quick Measurement Settings
		case 20 :
		{		
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_QMDELAY][1] == 2) MenuStatus[MENU_QMDELAY][1] = 3;
			else MenuStatus[MENU_QMDELAY][1] = 2;
		
			New_Menu = 20;
			Menu_Changed = 1;

			break;
		}
	
		// Quick Measurement Thresholds
		case 22 :
		{		
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if ((MenuPopupActive > -1) && (MenuPopupActive != 27)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 27)
			{
				pos = -1;
				MenuPopupStep(27, &MenuStatus[MENU_QMTHRESHOLDS][1], &pos, &pos, 22, 49, 2);

				New_Menu = 22;
				Menu_Changed = 1;
			}				
		
			Display::DRAWMENUPOPUP(27);
			break;
		}


		// Autoscale -> Slow TB
		case 23 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			if (MenuStatus[MENU_AUTOSCALE][1] == 240) MenuStatus[MENU_AUTOSCALE][1] = 241;
			else MenuStatus[MENU_AUTOSCALE][1] = 240;
			
			MenuItemChanged[1] = 1;
			New_Menu = 23;
			Menu_Changed = 1;
			
			break;
		}
	
	
		// Trigger Mode TV
		case 24 :
		{
			Menu_Popup_visible =1; // TMW added to repair multiple records after menu popup

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_TRIGGERTV][1] == 2) MenuStatus[MENU_TRIGGERTV][1] = 3;
			else MenuStatus[MENU_TRIGGERTV][1] = 2;		
		
			New_Menu = 24;
			Menu_Changed = 1;

			break;	
		}	

		// More Utilities - CH2 Delay			BF #001
		case 25 :
		{	

			if ((MenuPopupActive > -1) && (MenuPopupActive != 34))
			{ Display::DRAWMENUPOPDOWN(); }
			
			if (MenuPopupActive == 34)
			{
				pos = -1;
				MenuPopupStep(34, &MenuStatus[MENU_EXTUTILS][1], &pos, &pos, MENU_EXTUTILS, 203, 2);
			}

			New_Menu = MENU_EXTUTILS;
			Menu_Changed = 1;

			CH2_Del_Correct = MenuStatus[MENU_EXTUTILS][1] - 203;

			Display::DRAWMENUPOPUP(34);	

			break;
		}					


		// Math - FFT
		case 26 :
		{		

 			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (MenuStatus[MENU_MATH][1] == 0)			// execute only when FFT was not active yet
			{
				if (MenuStatus[MENU_MATH][2] == 1)
				{
					MenuItemChanged[2] = 1;
					MenuStatus[MENU_MATH][2] = 0;
				}
				
				else if (MenuStatus[MENU_MATH][3] == 1)
				{
					MenuItemChanged[3] = 1;
					MenuStatus[MENU_MATH][3] = 0;
				}
				
				else if (MenuStatus[MENU_MATH][4] == 1)
				{
					MenuItemChanged[4] = 1;
					MenuStatus[MENU_MATH][4] = 0;
				}

				MenuStatus[MENU_MATH][1] = 1;			// FFT active

				Hardware::FFT_Set_Channel(1);			// set active channel with backup
				
				Hardware::Zero_Levels_Center();			// set zerolevels to the middle of the grid 
				
				FFT_Mode = MenuStatus[MENU_FFT][2] - 65;	// setting FFT-mode must be done after switching zero levels!

				Display::RefreshScreen();	

				Menu_Changed = 1;
				//MenuAktive = 1;				// activate buttons
				//MenuStatusChanged = 1;
			}
;
			New_Menu = MENU_MATH;

			Display::DRAW_ALL_CURSOR();

			//Save new values to flash
			config_changed = true;

			break;				
		}

		// FFT - Settings - Window
		case 27 :
		{
			if ((MenuPopupActive > -1) && (MenuPopupActive != 30)) { Display::DRAWMENUPOPDOWN(); }

			if (MenuPopupActive == 30)
			{
				pos = -1;
				MenuPopupStep(30, &MenuStatus[MENU_FFT][1], &pos, &pos, 27, 193, 2);
				New_Menu = MENU_FFT;
				Menu_Changed = 1; 	
			}
			
			Display::DRAWMENUPOPUP(30);	
			
			// set FFT-Window     	193 = Rect 	=> -1
			//			194 = von Hann	=> 0
			//			195 = Blackman	=> 1
			FFT_Windex = MenuStatus[MENU_FFT][1] - 194;
			
			// create window
			for(int i=0,r=0 ;i < FFT_Length; i++)
			{
				win_tab[i] = FFT_Window[FFT_Windex][r];
			
				if (FFT_Length == FFT_512)
				r+=2;
				else
				r++;	
			}
			Display::FFT_DrawStatus(0);

			break;
		}
		
/* BF del not needed in new FFT 
		
		// FFT - Settings - Scale	
		case 28 :	// BF Changed case 27 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
		
			FFTToggle = 0;
		
			MenuItemChanged[1] = 1;
			MenuItemChanged[2] = 1;	

			New_Menu = 27;
			Menu_Changed = 1;	

			break;
		}				
*/
/* BF not needed in new FFT 		
		// Math Settings Offset
		case 29 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			MathToggle = 1;
			
			Menu_Changed = 1;
			MenuItemChanged[0] = 1;
			MenuItemChanged[1] = 1;
			
			break;
		}	
*/			
	}					
#ifdef _Debug_			
	if (Debug_Mode) printf("Function Button 2\n");		
#endif

}
// BF insert end
//######################################################################################################################################################
// BF insert
//Function button 3 pressed
void UserIF::F3_Btnhandler(void)					// Button Handler for function button
{
	short pos = 0;
	int ix;

#ifdef _Debug_		
       	printf("F3 Btn start\n");
#endif	

	if (MenuPopupActive > 0) Hardware::ResetTimer();
//	if (ZeroPopupChanged > 0) Hardware::ResetTimer();

	if ((Active_Menu == 1) && (Channel_1_Active == false)) return;
	if ((Active_Menu == 2) && (Channel_2_Active == false)) return;
	if ((Active_Menu == 3) && (Channel_3_Active == false)) return;
	if ((Active_Menu == 4) && (Channel_4_Active == false)) return;
	//if ((Active_Menu == 26) && (Channel_Math_Active == false)) return;

	if ((Active_Menu == 16) && (Cursor_Enabled == false)) return;
	if ((Active_Menu == 19) && (QM_Enabled == false)) return;
	if ((Active_Menu == 20) && (QM_Enabled == false)) return;
	if ((Active_Menu == 21) && (QM_Enabled == false)) return;
	if ((Active_Menu == 22) && (QM_Enabled == false)) return;

	
	MenuButtonCheck(2);

	switch(Active_Menu)
	{	
		// Acquire -> Noise suppression
		case 0 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_ACQUIRE][2] == 0)
			{
				MenuItemChanged[0] = 1;
				MenuStatus[MENU_ACQUIRE][0] = 0;
		
				MenuItemChanged[1] = 1;
				MenuStatus[MENU_ACQUIRE][1] = 0;

				MenuItemChanged[2] = 1;
				MenuStatus[MENU_ACQUIRE][2] = 1;

				New_Menu = 0;
				Menu_Changed = 1;
			}
				
			break;							
		}


		// Channel 1 -> Invert
		case 1 :
		{
			if (Channel_1_Active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_CHANNEL1][2] == 240) MenuStatus[MENU_CHANNEL1][2] = 241;
			else MenuStatus[MENU_CHANNEL1][2] = 240;

			TriggerLevelChanged = 1;
			TriggerWayChanged = 1;
			
			Hardware::UpdateTrigger();						
			Display::StatusUpdate();

			New_Menu = 1;
			Menu_Changed = 1;
			
			break;
		}
	
		// Channel 2 -> Invert
		case 2 :
		{
			if (Channel_2_Active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_CHANNEL2][2] == 240) MenuStatus[MENU_CHANNEL2][2] = 241;
			else MenuStatus[MENU_CHANNEL2][2] = 240;
			
			TriggerLevelChanged = 1;
			TriggerWayChanged = 1;
			
			Hardware::UpdateTrigger();						
			Display::StatusUpdate();

			New_Menu = 2;
			Menu_Changed = 1;
			
			break;
		}
	
		// Channel 3 -> Invert
		case 3 :
		{
			if (Channel_3_Active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_CHANNEL3][2] == 240) MenuStatus[MENU_CHANNEL3][2] = 241;
			else MenuStatus[MENU_CHANNEL3][2] = 240;
			
			TriggerLevelChanged = 1;
			TriggerWayChanged = 1;
			
			Hardware::UpdateTrigger();						
			Display::StatusUpdate();

			New_Menu = 3;
			Menu_Changed = 1;
			
			break;
		}
	
		// Channel 4 -> Invert
		case 4 :
		{
			if (Channel_4_Active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_CHANNEL4][2] == 240) MenuStatus[MENU_CHANNEL4][2] = 241;
			else MenuStatus[MENU_CHANNEL4][2] = 240;
			
			TriggerLevelChanged = 1;
			TriggerWayChanged = 1;
			
			Hardware::UpdateTrigger();
			Display::StatusUpdate();

			New_Menu = 4;
			Menu_Changed = 1;
			
			break;
		}		
			
		// Utility->Calibrate ADCs		-> BF added new menu function
		case 6 :
		{		
			UI_request = 0;
			printf("\r\nCalibrating ADC\r\n");

 			// spike correction
 	 		//Hardware::Get_Spike_Correction_Idx(); 

			Hardware::Calibrate_ADC_ZeroOffsets();	
			
			break;
		}
					
		// Service
		case 7 :
		{		
			//
			break;
		}

		// Save / Recall  - > Recall Signal
		case 8 :
		{	
			AMDFlash::RecallTrace();	//BF #016
			break;
		}

		// Print
		case 9 :
		{		
	//
			break;
		}

		// Timebase-> X-Y Mode (function button 3 pressed)
		case 10 :
		{		
			//BF del for ch 3 + 4 support  if ((Channel_1_Active == false) || (Channel_2_Active == false)) break;
			
			//only if channel 1 + 2 or 3 + 4 or all are active, else leave
 			if (!(Channel_1_Active && Channel_2_Active) && !(Channel_3_Active && Channel_4_Active))	break;

			//BF added for restoring zero levels
			ZeroLevelCH1_Main_bak = ZeroLevelCH1;
    			ZeroLevelCH2_Main_bak = ZeroLevelCH2;
			ZeroLevelCH3_Main_bak = ZeroLevelCH3;
			ZeroLevelCH4_Main_bak = ZeroLevelCH4;
			
			Virtual_ZeroLevelCH1_Main_bak = Virtual_ZeroLevelCH1;
			Virtual_ZeroLevelCH2_Main_bak = Virtual_ZeroLevelCH2;
			Virtual_ZeroLevelCH3_Main_bak = Virtual_ZeroLevelCH3;
			Virtual_ZeroLevelCH4_Main_bak = Virtual_ZeroLevelCH4;

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_TIMEBASE][2] == 0)				//Check if XY-mode is not active yet
			{
				if (MenuStatus[MENU_TIMEBASE][0] == 1)			//main mode active?
				{
					MenuItemChanged[0] = 1;
					MenuStatus[MENU_TIMEBASE][0]  = 0;			//switch off main mode
				}
				else if (MenuStatus[MENU_TIMEBASE][1] == 1)		//delayed mode active?
				{				
					MenuItemChanged[1] = 1;
					MenuStatus[MENU_TIMEBASE][1]  = 0;			//switch off delayed mode
				}
				
				if (QM_Enabled)
				{
					QM_Enabled_Old           = QM_Enabled;
					QM_Enabled               = false;
					Quick_Measure_First_Draw = 0;
					MenuStatusChanged        = 1;
		
					// remove the cursor data
					for (ix = 408 * 20; ix < 430 * 20; ix++)
					{
						*(UI_Plane1 + ix) = 0;		// delete
						*(Buffer_UI2Plane + ix) = 0;	// delete Text
						*(UI_Plane2 + ix) = 0;		//Guido add: delete button-text
						*(UI_Plane4 + ix) = 0;		// delete
						*(UI_Plane5 + ix) = 0;		// delete
					}
		
					LED_ON[7] = 0;
						
					//New_Menu = 19;
					Menu_Changed = 1;
					//MenuAktive = 0;
						
					Display::CALCQMDATA();
				}

				if (Channel_Math_Active)		//Math function active?
				{
					LED_ON[4] = 0;
					Channel_Math_Active = 0;	//switch off math function
				}
	
				if (USTB_Mode != USTB_OFF)
				Signal::USTB_Clear_Buffer();

				Hardware::Send_LED();
		
				//Draw XY-grid into the grid plane
				//Display::GRIDXY(GRID_XY_XOFFS, GRID_YOFFS, Grid_Plane);		//draw grid
				//GridColor_Val = GridColorArray[GridColorArrayPos];		//grid intensity
				//MenuStatus[MENU_DISPLAY][2] = GridColorArrayPos + 133;		//menu text item
				//Hardware::SetupADC();							//set intensity

				MenuStatus[MENU_TIMEBASE][2] = 1;				//Switch XY-mode on
				XY_Mode      = 1;

				New_Menu     = 10;
				Menu_Changed = 1;

				config_changed = 1;

				if(Channel_1_Active && Channel_2_Active)
				{
					//Virtual_ZeroLevelCH1 = 0;
					//Virtual_ZeroLevelCH2 = 0;
					
					ON_Zero_Channel_1();
					ON_Zero_Channel_2();
				}
			

				if(Channel_3_Active && Channel_4_Active)
				{
					//Virtual_ZeroLevelCH3 = 0;
					//Virtual_ZeroLevelCH4 = 0;
					
					ON_Zero_Channel_3();
					ON_Zero_Channel_4();
				}

				Hardware::SetupADC();
				
				Display::DRAWSTATUS(0, 1);
				Hardware::ClearPlanes();
			}

			Display::RefreshScreen();
			Display::DRAW_ALL_CURSOR();
				
			break;							
		}

	
		// Trigger Mode -> Reject	//BF #020
		//BF this function has no effect to nothing and is therefore extremely useless!!!
		case 12 :
		{
/* BF del
			Menu_Popup_visible = 1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 12)) { Display::DRAWMENUPOPDOWN(); }

			if (MenuPopupActive == 12)
			{
				pos = -1;
				MenuPopupStep(12, &MenuStatus[MENU_TRIGGERMODE][2], &pos, &pos, 12, 97, 2);
			}		
		

			New_Menu           = 12;
			Menu_Changed       = 1;
			MenuItemChanged[2] = 1;
			Display::DRAWMENUPOPUP(12);
*/			break;
		}

		// Edge -> External
		case 14 :
		{	
			if (MenuStatus[MENU_TRIGGEREDGE][1] != 141) return;	// BF only available if external source is active
			
			Menu_Popup_visible = 1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 8)) { Display::DRAWMENUPOPDOWN(); }	

			if (MenuPopupActive == 8)
			{
				pos = -1;
				MenuPopupStep(8, &MenuStatus[MENU_TRIGGEREDGE][2], &pos, &pos, 14, 128, 2);
			}				

			//MenuStatus[MENU_TRIGGEREDGE][3] = 0; 	//BF set TV menu inactiv
/*BF del
			if (MenuStatus[MENU_TRIGGEREDGE][2] == 0)
			{				
				//BF del MenuItemChanged[1] = 1;
				//BF del MenuStatus[MENU_TRIGGEREDGE][1] = 0;
						
				MenuItemChanged[2] = 1;		
				MenuStatus[MENU_TRIGGEREDGE][2] = 1;
				
				MenuItemChanged[3] = 1;
				MenuStatus[MENU_TRIGGEREDGE][3] = 0;		

				TriggerLevelChanged = 1;
				TriggerWayChanged = 1;	

				if (MenuPopupStatus[8][0] == 3)
				{					
					Selected_Trigger_Source = 5;	
					SelectedEdgeExtern = 0;             // External
				}
				else if (MenuPopupStatus[8][1] == 3)
				{					
					Selected_Trigger_Source = 5;	
					SelectedEdgeExtern = 0;             // External
				}
				else if (MenuPopupStatus[8][1] == 3)
				{					
					Selected_Trigger_Source = 6;	
					SelectedEdgeExtern = 1;             // External
				}

				New_Menu = 14;
				Menu_Changed = 1;

				Hardware::UpdateTrigger();

				Display::StatusUpdate();
				Display::DRAWMENUPOPUP(8);
			}
			else
			{				
				if ((MenuPopupActive > -1) && (MenuPopupActive != 8)) { Display::DRAWMENUPOPDOWN(); }
				if (MenuPopupActive == 8)
				{
					if (MenuPopupStatus[8][0] == 3)	
					{
						SelectedEdgeExtern = 0;             // External LF
						Selected_Trigger_Source = 5;
						MenuPopupStatus[8][0] = 2;
						MenuPopupStatus[8][1] = 3;
						MenuPopupStatus[8][2] = 2;
					}
					else if (MenuPopupStatus[8][1] == 3)	
					{
						SelectedEdgeExtern = 1;             // External HF
						Selected_Trigger_Source = 6;
						MenuPopupStatus[8][0] = 2;
						MenuPopupStatus[8][1] = 2;
						MenuPopupStatus[8][2] = 3;
					}
					else if (MenuPopupStatus[8][2] == 3)	
					{
						SelectedEdgeExtern = 0;             // Line
						Selected_Trigger_Source = 5;
						MenuPopupStatus[8][0] = 3;
						MenuPopupStatus[8][1] = 2;
						MenuPopupStatus[8][2] = 2;
					} 			
				}	
*/


				TriggerLevelChanged = 1;
				TriggerWayChanged = 1;					
				
				New_Menu = 14;
				Menu_Changed = 1;

				Hardware::UpdateTrigger();

				Display::StatusUpdate();
				Display::DRAWMENUPOPUP(8);
			//}
			break;
		}
			
		// Pulse Width -> Dir
		case 15 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			if (MenuStatus[MENU_PULSEWIDTH][2] == 2)
			{
				MenuStatus[MENU_PULSEWIDTH][2] = 1;
				PulseToggle = 2;					
			}
			else if (MenuStatus[MENU_PULSEWIDTH][2] == 1)
			{
				MenuStatus[MENU_PULSEWIDTH][2] = 3;
				PulseToggle = 1;			
			}
			else
			{
				MenuStatus[MENU_PULSEWIDTH][2] = 2;
				PulseToggle = 1;
			}
#ifdef _Debug_					
			printf("PW MS[15/2] %d PT %d\n", MenuStatus[MENU_PULSEWIDTH][2], PulseToggle);
#endif					
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
			MenuItemChanged[5] = 1;
			MenuStatusChanged = 1;
			TriggerWayChanged = 1;
		
			New_Menu = 15;
			Menu_Changed = 1;

			Display::StatusUpdate();
			Hardware::UpdateTrigger();

			break;	
		}		
	
		// Cursor -> X2		
		case 16 :
		{
			if (Cursor_Enabled == 0) break;
			{
				if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

				if (Cursor_Vertical_Active_Old == 1) MenuItemChanged[1] = 1;
				else if (Cursor_Vertical_Active_Old == 4) MenuItemChanged[5] = 1;
				else if (Cursor_Horizontal_Active_Old == 1) MenuItemChanged[3] = 1;
				else if (Cursor_Horizontal_Active_Old == 2) MenuItemChanged[4] = 1;
				else if (Cursor_Horizontal_Active_Old == 4) MenuItemChanged[5] = 1;

				Cursor_Vertical_Active = 2;
				Cursor_Horizontal_Active = 3;
	
				if(FFT_Mode != FFT_OFF)
				Display::FFT_CalcCursorData();
				else
				Display::CALCCURSORDATA();

							
				New_Menu = 16;
				Menu_Changed = 1;
	
				Display::DRAW_ALL_CURSOR();
			}
			break;		
		}
		
		// Quick Print -> Save to CSV
		case 17 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			//MenuItemChanged[2] = 1;
							
			New_Menu = 17;
			Menu_Changed = 1;
			
			CommIF::DUMPCSV('C');	// save to CSV
	
			return;					
		}		
	
		// Hardware
		case 18 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			//n.a.

			break;
		}	

		// Quick Measurement -> Add Measurement
		case 19 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }				
			
			QM_Type_Old[0] = QM_Type[0];
			QM_Type_Old[1] = QM_Type[1];
			QM_Type_Old[2] = QM_Type[2];

			if (QM_Type[0] == 0)
			{
				QM_Type[0] = MenuStatus[MENU_QUICKMEASURE][1] - 51;
				QM_Changed[0] = 1;
				QM_Channel[0] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
			}
			else if (QM_Type[1] == 0)
			{
				if ((QM_Type[0] != (MenuStatus[MENU_QUICKMEASURE][1] - 51)) || (QM_Channel[0] != (MenuStatus[MENU_QUICKMEASURE][0] - 26)))
				{
					QM_Type[1] = MenuStatus[MENU_QUICKMEASURE][1] - 51;
					QM_Changed[1] = 1;
					QM_Channel[1] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
				}
			}
			else if (QM_Type[2] == 0)
			{
				if ((QM_Type[1] != (MenuStatus[MENU_QUICKMEASURE][1] - 51)) || (QM_Channel[1] != (MenuStatus[MENU_QUICKMEASURE][0] - 26)))
				{
					QM_Type[2] = MenuStatus[MENU_QUICKMEASURE][1] - 51;
					QM_Changed[2] = 1;
					QM_Channel[2] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
				}
			}
			else
			{
				if ((QM_Type[2] != (MenuStatus[MENU_QUICKMEASURE][1] - 51)) || (QM_Channel[2] != (MenuStatus[MENU_QUICKMEASURE][0] - 26)))
				{
					QM_Type[0] = QM_Type[1];
					QM_Type[1] = QM_Type[2];
					QM_Type[2] = MenuStatus[MENU_QUICKMEASURE][1] - 51;
		
					QM_Channel[0] = QM_Channel[1];
					QM_Channel[1] = QM_Channel[2];
					QM_Channel[2] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
		
					QM_Changed[0] = 1;
					QM_Changed[1] = 1;
					QM_Changed[2] = 1;
				}
			}

			if (NumberOfChannels == 2)
			{
				if (QM_Channel[0] == 3) QM_Channel[0] = 5;
				if (QM_Channel[1] == 3) QM_Channel[1] = 5;
				if (QM_Channel[2] == 3) QM_Channel[2] = 5;
			}

			Quick_Measure_First_Draw = 1;

			New_Menu = 19;
			Menu_Changed = 1;
#ifdef _Debug_
if (Debug_Mode) printf("QT1 : %d QT2 : %d QT3 : %d MS19,1 : %d\n", QM_Type[0], QM_Type[1], QM_Type[2], MenuStatus[MENU_QUICKMEASURE][1]);
#endif
			//QM_Vertical_Active = 0;
			//QM_Horizontal_Active = 0;

			Display::CALCQMDATA();

			break;
		}
		
		// Quick Measurement Delay Settings
		case 20 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if ((MenuPopupActive > -1) && (MenuPopupActive != 6)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 6)
			{
				pos = -1;
				MenuPopupStep(6, &MenuStatus[MENU_QMDELAY][2], &pos, &pos, 20, 27, 2);
				
				New_Menu = 20;
				Menu_Changed = 1;
			}				
				
			Display::DRAWMENUPOPUP(6);
			break;
		}	
		
		// Quick Measurement Phase Settings
		case 21 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if ((MenuPopupActive > -1) && (MenuPopupActive != 25)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 25)
			{
				pos = -1;
				MenuPopupStep(25, &MenuStatus[21][2], &pos, &pos, 21, 27, 2);
				
				New_Menu = 21;
				Menu_Changed = 1;
			}				
				
			Display::DRAWMENUPOPUP(25);
			break;
		}

		// Quick Measurement Threshold -> Lower
		case 22 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (Quick_Measure_Threshold_btn_select == 2) MenuItemChanged[3] = 1;
			else if (Quick_Measure_Threshold_btn_select == 3) MenuItemChanged[4] = 1;

			Quick_Measure_Threshold_btn_select = 1;

			New_Menu = 22;
			Menu_Changed = 1;

			break;
		} 

		// Trigger Mode TV
		case 24 :
		{
			if ((MenuPopupActive > -1) && (MenuPopupActive != 21)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 21)
			{
				pos = -1;
				MenuPopupStep(21, &MenuStatus[MENU_TRIGGERTV][2], &pos, &pos, 24, 114, 2);
				
				New_Menu = 24;
				Menu_Changed = 1;
			}				
			
			Display::DRAWMENUPOPUP(21);	
			break;
		}

		// More Utilities - CH3 Delay			BF #001
		case 25 :
		{	
			if (NumberOfChannels == 2){return;}	//only for 4 channel version

			if ((MenuPopupActive > -1) && (MenuPopupActive != 35))
			{ Display::DRAWMENUPOPDOWN(); }
			
			if (MenuPopupActive == 35)
			{
				pos = -1;
				MenuPopupStep(35, &MenuStatus[MENU_EXTUTILS][2], &pos, &pos, MENU_EXTUTILS, 203, 2);
			}

			New_Menu = MENU_EXTUTILS;
			Menu_Changed = 1;

			CH3_Del_Correct = MenuStatus[MENU_EXTUTILS][2] - 203;

			Display::DRAWMENUPOPUP(35);	

			break;
		}			


		// Math - 1 * 2
		case 26 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_MATH][2] == 0)
			{
				// If FFT was active bevore - switch back to old settings
				if (FFT_Mode != FFT_OFF)
				{
					FFT_Mode = FFT_OFF;
		
					Display::FFT_DrawStatus(1);						//clear UI-Planes	
					Hardware::FFT_Restore_Channels();					//restore channel setting
					Hardware::Zero_Levels_Restore();					//restore Zerolevels

					Display::RefreshScreen();
					
				}
	
				Channel_1_Active = 1;		// Math with only one channel makes no sense
				Channel_2_Active = 1;
				LED_ON[0] = 1;
				LED_ON[1] = 1;

				//switch off old active button
				if (MenuStatus[MENU_MATH][1] == 1)
				{
					MenuItemChanged[1] = 1;
					MenuStatus[MENU_MATH][1] = 0;
				}
				else if (MenuStatus[MENU_MATH][3] == 1)
				{
					MenuItemChanged[3] = 1;
					MenuStatus[MENU_MATH][3] = 0;
				}
				else if (MenuStatus[MENU_MATH][4] == 1)
				{
					MenuItemChanged[4] = 1;
					MenuStatus[MENU_MATH][4] = 0;
				}
	
				MenuStatus[MENU_MATH][2] = 1;		//set actual button to active

				New_Menu = MENU_MATH;
				Menu_Changed = 1;
			}
				
			break;
		}

		// FFT - Settings - FFT-Mode
		case 27 :
		{					
			if ((MenuPopupActive > -1) && (MenuPopupActive != 31)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 31)
			{
				pos = -1;
				MenuPopupStep(31, &MenuStatus[MENU_FFT][2], &pos, &pos, 27, 66, 2);
			}

			New_Menu = 27;
			Menu_Changed = 1;

			Display::DRAWMENUPOPUP(31);	

			FFT_Mode = MenuStatus[MENU_FFT][2] - 65;
			
			Display::RefreshScreen();

			break;	
		}


/* BF -> not needed for the new FFT		
		
		// FFT - Settings - Offset
		case 27 :
		{					
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
	
			FFTToggle = 1;
		
			MenuItemChanged[1] = 1;
			MenuItemChanged[2] = 1;					

			New_Menu = 27;
			Menu_Changed = 1;

			break;
		}
*/

	}
#ifdef _Debug_						
			if (Debug_Mode) printf("Function Button 3\n");
#endif
}
// BF insert end
//######################################################################################################################################################
// BF insert
//Function button 4 pressed
void UserIF::F4_Btnhandler(void)					// Button Handler for function button
{
			
	short pos = 0;
	int ix;
	int buf_int;

#ifdef _Debug_		
       	printf("F4 Btn start\n");
#endif	
	
	if (MenuPopupActive > 0) Hardware::ResetTimer();
//	if (ZeroPopupChanged > 0) Hardware::ResetTimer();
	
	if ((Active_Menu == 1) && (Channel_1_Active == false)) return;
	if ((Active_Menu == 2) && (Channel_2_Active == false)) return;
	if ((Active_Menu == 3) && (Channel_3_Active == false)) return;
	if ((Active_Menu == 4) && (Channel_4_Active == false)) return;
	//if ((Active_Menu == 26) && (Channel_Math_Active == false)) return;
				
	if ((Active_Menu == 16) && (Cursor_Enabled == false)) return;
	if ((Active_Menu == 19) && (QM_Enabled == false)) return;
	if ((Active_Menu == 20) && (QM_Enabled == false)) return;
	if ((Active_Menu == 21) && (QM_Enabled == false)) return;
	if ((Active_Menu == 22) && (QM_Enabled == false)) return;

	MenuButtonCheck(3);
			
	switch(Active_Menu)
	{				
		// Display -> Grid
		case 5 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			if(MenuStatus[MENU_DISPLAY][3] == 240)	//Check if Vectors are off
			{ MenuStatus[MENU_DISPLAY][3] = 241; }	//switch vectors on
			else
			{ MenuStatus[MENU_DISPLAY][3] = 240; }	//switch vectors off
			
			New_Menu = 5;
			Menu_Changed = 1;
			break;
		}	

		// Utility -> Calibrate DAC		-> BF added new menu function
		case 6 :
		{	
			UI_request = 0;
			printf("\nCalibrating ADC\n");

			Hardware::Calibrate_DAC_ZeroOffsets();
			break;
		}
	
		// Service - RS-232 Setup
		case 7 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			New_Menu = 21;
			Menu_Changed = 1;

			break;
		}	


//BF -> new overlay mode

		// Save / Recall -> overlay	#013
		case 8 :
		{
			//return;	//not active yet
			AMDFlash::RecallOverlay();

			break;
		}	
	



		
		// USTB-Rollmode
		case 10 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_TIMEBASE][3] == 0)
			{
				MenuStatus[MENU_TIMEBASE][3] = 1;	//set roll mode to on 
				MenuStatus[MENU_TIMEBASE][4] = 0;	//set shift mode to off

				New_Menu = MENU_TIMEBASE;
				Menu_Changed = 1;

				MenuItemChanged[3] = 1;
				MenuItemChanged[4] = 1;		

				if(USTB_Mode != USTB_OFF)
				{
					Signal::USTB_Clear_Buffer();
					USTB_Mode = USTB_ROLL;
				}
				Display::DRAWSTATUS(7, 1);
				//Display::StatusUpdate();
				//Hardware::ClearPlanes();
			}
			//Display::DRAW_ALL_CURSOR();
			config_changed = true; 
			break;							
		}		
					
		// Trigger Mode  -> Holdoff
		case 12 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
		
			if (EdgeToggle == 0)
			{		
				buf_int = (int) (HoldOff.Read_Value() * 100000000);	

				printf("HF bi : %d\n", buf_int);
		
				if (Rotary_Direction_mem_pulse == 1)
				{	
					if (buf_int == 0)
					{
						HoldOff.Write_Value(0.000000040);
		
						HoldOff_Value = 120;
						HoldOff_Steps = 40;
						HoldOff_Expo = 1;
					}
					else if ((buf_int >= 1) && (buf_int < 100))
					{
						HoldOff.Write_Value(0.000001);
		
						HoldOff_Value = 1;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;
					}
					else if ((buf_int >= 100) && (buf_int < 1000))
					{
						HoldOff.Write_Value(0.00001);
		
						HoldOff_Value = 10;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;
					}
					else if ((buf_int >= 1000) && (buf_int < 10000))
					{
						HoldOff.Write_Value(0.0001);
		
						HoldOff_Value = 100;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;
					}
					else if ((buf_int >= 10000) && (buf_int < 100000))
					{
						HoldOff.Write_Value(0.001);
		
						HoldOff_Value = 1;
						HoldOff_Steps = 1;
						HoldOff_Expo = 3;
					}
					else if ((buf_int >= 100000) && (buf_int < 1000000))
					{
						HoldOff.Write_Value(0.01);
		
						HoldOff_Value = 10;
						HoldOff_Steps = 1;
						HoldOff_Expo = 3;
					}
					else if ((buf_int >= 1000000) && (buf_int < 10000000))
					{
						HoldOff.Write_Value(0.1);
		
						HoldOff_Value = 100;
						HoldOff_Steps = 1;
						HoldOff_Expo = 3;
					}
					else if ((buf_int >= 10000000) && (buf_int < 100000000))
					{
						HoldOff.Write_Value(1);
		
						HoldOff_Value = 1;
						HoldOff_Steps = 1;
						HoldOff_Expo = 4;
					}
					else if ((buf_int >= 100000000) && (buf_int < 1000000000))
					{
						HoldOff.Write_Value(10);
		
						HoldOff_Value = 10;
						HoldOff_Steps = 1;
						HoldOff_Expo = 4;
					}
					else if ((((int) (HoldOff.Read_Value() * 1000000)) >= 10000000) && (((int) (HoldOff.Read_Value() * 1000000)) < 100000000))
					{
						HoldOff.Write_Value(100);
		
						HoldOff_Value = 100;
						HoldOff_Steps = 1;
						HoldOff_Expo = 4;
					}
					else
					{
						HoldOff.Write_Value(0);
		
						HoldOff_Value = 0;
						HoldOff_Steps = 40;
						HoldOff_Expo = 1;
					}
				}
				else 	                 		
				{
					if (buf_int == 0)
					{
						HoldOff.Write_Value(100);
		
						HoldOff_Value = 100;
						HoldOff_Steps = 1;
						HoldOff_Expo = 4;
					}
					else if (buf_int == 4)
					{
						HoldOff.Write_Value(0);
		
						HoldOff_Value = 0;
						HoldOff_Steps = 40;
						HoldOff_Expo = 1;
					}
					else if (buf_int == 12)
					{
						HoldOff.Write_Value(0.000000040);
		
						HoldOff_Value = 40;
						HoldOff_Steps = 40;
						HoldOff_Expo = 1;
					}
					else if ((buf_int > 10) && (buf_int <= 100))
					{
						HoldOff.Write_Value(0.000000120);
		
						HoldOff_Value = 120;
						HoldOff_Steps = 40;
						HoldOff_Expo = 1;
					}
					else if ((buf_int > 100) && (buf_int <= 1000))
					{
						HoldOff.Write_Value(0.000001);
		
						HoldOff_Value = 1;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;
					}
					else if ((buf_int > 1000) && (buf_int <= 10000))
					{
						HoldOff.Write_Value(0.00001);
		
						HoldOff_Value = 10;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;
					}
					else if ((buf_int > 10000) && (buf_int <= 100000))
					{
						HoldOff.Write_Value(0.0001);
		
						HoldOff_Value = 100;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;
					}
		
					else if ((buf_int > 100000) && (buf_int <= 1000000))
					{
						HoldOff.Write_Value(0.001);
		
						HoldOff_Value = 1;
						HoldOff_Steps = 1;
						HoldOff_Expo = 3;
					}
					else if ((buf_int > 1000000) && (buf_int <= 10000000))
					{
						HoldOff.Write_Value(0.01);
		
						HoldOff_Value = 10;
						HoldOff_Steps = 1;
						HoldOff_Expo = 3;
					}
					else if ((buf_int > 10000000) && (buf_int <= 100000000))
					{
						HoldOff.Write_Value(0.1);
		
						HoldOff_Value = 100;
						HoldOff_Steps = 1;
						HoldOff_Expo = 3;
					}
					else if ((buf_int > 100000000) && (buf_int <= 1000000000))
					{
						HoldOff.Write_Value(1);
		
						HoldOff_Value = 1;
						HoldOff_Steps = 1;
						HoldOff_Expo = 4;
					}
					else if ((((int) (HoldOff.Read_Value() * 1000000)) > 10000000) && (((int) (HoldOff.Read_Value() * 1000000)) <= 100000000))
					{
						HoldOff.Write_Value(10);
		
						HoldOff_Value = 10;
						HoldOff_Steps = 1;
						HoldOff_Expo = 4;
					}
					else
					{
						HoldOff.Write_Value(0.1);
		
						HoldOff_Value = 100;
						HoldOff_Steps = 1;
						HoldOff_Expo = 3;
					}
				}

		
				HoldOff.RenderText();				
			}
		
			EdgeToggle = 0;
			New_Menu = 12;
			Menu_Changed = 1;
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
	
			Hardware::UpdateTrigger();


			break;
		}	


		// Edge -> TV
		case 14 :
		{	
			if (MenuStatus[MENU_TRIGGEREDGE][1] != 142) return;	// BF only available if TV source is active

			Menu_Popup_visible = 1; // TMW added to repair multiple records after menu popup

			if ((MenuPopupActive > -1) && (MenuPopupActive != 11)) { Display::DRAWMENUPOPDOWN(); }			


			if (MenuPopupActive == 11)
			{
				pos = -1;
				MenuPopupStep(11, &MenuStatus[MENU_TRIGGEREDGE][3], &pos, &pos, 14, 131, 2);
			}				


/*BF del
			if (MenuStatus[MENU_TRIGGEREDGE][3] == 0)
			{				
				//BF del MenuItemChanged[1] = 1;
				//BF del MenuStatus[MENU_TRIGGEREDGE][1] = 0;
						
				MenuItemChanged[2] = 1;			
				MenuStatus[MENU_TRIGGEREDGE][2] = 0;	//BF set External trigger menu inactive
				
				MenuItemChanged[3] = 1;
				MenuStatus[MENU_TRIGGEREDGE][3] = 1;	//BF set TV trigger menu active
				
				New_Menu = 14;
				Menu_Changed = 1;
			}
			else
			{
				if (MenuPopupActive == 11)
				{
					if (MenuPopupStatus[11][0] == 3)	
					{
						MenuPopupStatus[11][0] = 2;
						MenuPopupStatus[11][1] = 3;
					}
					else
					{
						MenuPopupStatus[11][0] = 3;
						MenuPopupStatus[11][1] = 2;
					}
				}
			}
*/			
			TriggerLevelChanged = 1;
			TriggerWayChanged = 1;		
			//BF del Selected_Trigger_Source = 6;
			//BF del SelectedEdgeExtern = 2;               // TV CH 1	

			Display::StatusUpdate();
				
			Hardware::UpdateTrigger();	
			
			Display::DRAWMENUPOPUP(11);

			break;
		} 
	
		// Pulse Width
		case 15 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (MenuStatus[MENU_PULSEWIDTH][2] == 1) break;

			if (MenuStatus[MENU_PULSEWIDTH][2] == 3)
			{					
				if (PulseToggle == 1)
				{					
					buf_int = (int) (Pulse11.Read_Value() * 100000000);	
					
					if (Rotary_Direction_mem_pulse == 1)
					{				
						if ((buf_int >= 1) && (buf_int < 10))
						{
							Pulse11.Write_Value(0.000000104);
			
							Pulse11_Value = 104;
							Pulse11_Steps = 8;
							Pulse11_Expo = 1;
						}
						else if ((buf_int >= 10) && (buf_int < 100))
						{
							Pulse11.Write_Value(0.000001);
			
							Pulse11_Value = 1;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int >= 100) && (buf_int < 1000))
						{
							Pulse11.Write_Value(0.00001);
			
							Pulse11_Value = 10;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int >= 1000) && (buf_int < 10000))
						{
							Pulse11.Write_Value(0.0001);
			
							Pulse11_Value = 100;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int >= 10000) && (buf_int < 100000))
						{
							Pulse11.Write_Value(0.001);
			
							Pulse11_Value = 1;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else if ((buf_int >= 100000) && (buf_int < 1000000))
						{
							Pulse11.Write_Value(0.01);
			
							Pulse11_Value = 10;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else if ((buf_int >= 1000000) && (buf_int < 10000000))
						{
							Pulse11.Write_Value(0.1);
			
							Pulse11_Value = 100;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else
						{
							Pulse11.Write_Value(0.000000016);
			
							Pulse11_Value = 16;
							Pulse11_Steps = 8;
							Pulse11_Expo = 1;
						}
					}
					else 	
					{
						if (buf_int == 1)
						{
							Pulse11.Write_Value(0.1);
			
							Pulse11_Value = 100;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else if (buf_int == 10)
						{
							Pulse11.Write_Value(0.000000016);
			
							Pulse11_Value = 16;
							Pulse11_Steps = 8;
							Pulse11_Expo = 1;
						}
						else if ((buf_int > 10) && (buf_int <= 100))
						{
							Pulse11.Write_Value(0.000000104);
			
							Pulse11_Value = 104;
							Pulse11_Steps = 8;
							Pulse11_Expo = 1;
						}
						else if ((buf_int > 100) && (buf_int <= 1000))
						{
							Pulse11.Write_Value(0.000001);
			
							Pulse11_Value = 1;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int > 1000) && (buf_int <= 10000))
						{
							Pulse11.Write_Value(0.00001);
			
							Pulse11_Value = 10;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int > 10000) && (buf_int <= 100000))
						{
							Pulse11.Write_Value(0.0001);
			
							Pulse11_Value = 100;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int > 100000) && (buf_int <= 1000000))
						{
							Pulse11.Write_Value(0.001);
			
							Pulse11_Value = 1;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else if ((buf_int > 1000000) && (buf_int <= 10000000))
						{
							Pulse11.Write_Value(0.01);
			
							Pulse11_Value = 10;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else
						{
							Pulse11.Write_Value(0.1);
			
							Pulse11_Value = 100;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
					}					
		
					Pulse11.RenderText();
					trig_width_reg = (unsigned int) (Pulse11.Read_Value() / (float) 0.000000008);
				}
				else PulseToggle = 1;
			}
			else
			{
				if (PulseToggle == 1)
				{					
					buf_int = (int) (Pulse21.Read_Value() * 100000000);	
					
					if (Rotary_Direction_mem_pulse == 1)
					{				
						if ((buf_int >= 1) && (buf_int < 10))
						{
							Pulse21.Write_Value(0.000000104);
			
							Pulse21_Value = 104;
							Pulse21_Steps = 8;
							Pulse21_Expo = 1;
						}
						else if ((buf_int >= 10) && (buf_int < 100))
						{
							Pulse21.Write_Value(0.000001);
			
							Pulse21_Value = 1;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
						else if ((buf_int >= 100) && (buf_int < 1000))
						{
							Pulse21.Write_Value(0.00001);
			
							Pulse21_Value = 10;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
						else if ((buf_int >= 1000) && (buf_int < 10000))
						{
							Pulse21.Write_Value(0.0001);
			
							Pulse21_Value = 100;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
		
						else if ((buf_int >= 10000) && (buf_int < 100000))
						{
							Pulse21.Write_Value(0.001);
			
							Pulse21_Value = 1;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else if ((buf_int >= 100000) && (buf_int < 1000000))
						{
							Pulse21.Write_Value(0.01);
			
							Pulse21_Value = 10;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else if ((buf_int >= 1000000) && (buf_int < 10000000))
						{
							Pulse21.Write_Value(0.1);
			
							Pulse21_Value = 100;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else
						{
						Pulse21.Write_Value(0.000000016);
		
						Pulse21_Value = 16;
						Pulse21_Steps = 8;
						Pulse21_Expo = 1;
						}
					}
					else 
					{
						if (buf_int == 1)
						{
							Pulse21.Write_Value(0.1);
			
							Pulse21_Value = 100;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else if (buf_int == 10)
						{
							Pulse21.Write_Value(0.000000016);
			
							Pulse21_Value = 16;
							Pulse21_Steps = 8;
							Pulse21_Expo = 1;
						}
						else if ((buf_int > 10) && (buf_int <= 100))
						{
							Pulse21.Write_Value(0.000000104);
			
							Pulse21_Value = 104;
							Pulse21_Steps = 8;
							Pulse21_Expo = 1;
						}
						else if ((buf_int > 100) && (buf_int <= 1000))
						{
							Pulse21.Write_Value(0.000001);
			
							Pulse21_Value = 1;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
						else if ((buf_int > 1000) && (buf_int <= 10000))
						{
							Pulse21.Write_Value(0.00001);
			
							Pulse21_Value = 10;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
						else if ((buf_int > 10000) && (buf_int <= 100000))
						{
							Pulse21.Write_Value(0.0001);
			
							Pulse21_Value = 100;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
		
						else if ((buf_int > 100000) && (buf_int <= 1000000))
						{
							Pulse21.Write_Value(0.001);
			
							Pulse21_Value = 1;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else if ((buf_int > 1000000) && (buf_int <= 10000000))
						{
							Pulse21.Write_Value(0.01);
			
							Pulse21_Value = 10;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else
						{
							Pulse21.Write_Value(0.1);
			
							Pulse21_Value = 100;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
					}			
			
					Pulse21.RenderText();
					trig_width_reg = (unsigned int) ((Pulse21.Read_Value() / (float) 0.000000008));
				}
				else PulseToggle = 1;
			}

			
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
								
			New_Menu = 15;
			Menu_Changed = 1;
			TriggerWayChanged = 1;
			Hardware::UpdateTrigger();

			Display::StatusUpdate();

			break;	
		}

		// Cursor -> Y1
		case 16 :
		{	
			if (Cursor_Enabled == 0) break;
			{
				if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }		

				if (Cursor_Vertical_Active_Old == 1) MenuItemChanged[1] = 1;
				else if (Cursor_Vertical_Active_Old == 4) MenuItemChanged[5] = 1;
				else if (Cursor_Vertical_Active_Old == 2) MenuItemChanged[2] = 1;
				else if (Cursor_Horizontal_Active_Old == 2) MenuItemChanged[4] = 1;
				else if (Cursor_Horizontal_Active_Old == 4) MenuItemChanged[5] = 1;
	
				Cursor_Vertical_Active = 3;
				Cursor_Horizontal_Active = 1; 			
	
				if(FFT_Mode != FFT_OFF)
				Display::FFT_CalcCursorData();
				else
				Display::CALCCURSORDATA();

								
				New_Menu = 16;
				Menu_Changed = 1;
	
				Display::DRAW_ALL_CURSOR();
			}
			break;						
		}
		
		// Quick Print -> Save to ASCII
		case 17 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			//MenuItemChanged[3] = 1;
							
			New_Menu = 17;
			//Menu_Changed = 1;
			
			CommIF::DUMPCSV('A');	// save to ASCII

			return;					
		}		

		// Quick Measurement -> Clear
		case 19 :
		{		
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }				
		
			QM_Type_Old[0] = QM_Type[0];
			QM_Type_Old[1] = QM_Type[1];
			QM_Type_Old[2] = QM_Type[2];

			QM_Type[0] = 0;
			QM_Type[1] = 0;
			QM_Type[2] = 0;
	
			QM_Channel[0] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
			QM_Channel[1] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
			QM_Channel[2] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
	
			QM_Changed[0] = 0;
			QM_Changed[1] = 0;
			QM_Changed[2] = 0;
	
			Quick_Measure_First_Draw = 1;

			New_Menu = 19;
			Menu_Changed = 1;
	
			QM_Vertical_Active = 0;
			QM_Horizontal_Active = 0;
	
			Display::CALCQMDATA();

			break;
		}
	
		// Quick Measurement Settings
		case 20 :
		{		
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			if (MenuStatus[MENU_QMDELAY][3] == 2) MenuStatus[MENU_QMDELAY][3] = 3;
			else MenuStatus[MENU_QMDELAY][3] = 2;
		
			New_Menu = 20;
			Menu_Changed = 1;

			break;
		}	

		// Quick Measurement Threshold -> Middle
		case 22 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			if (Quick_Measure_Threshold_btn_select == 1) MenuItemChanged[2] = 1;
			else if (Quick_Measure_Threshold_btn_select == 3) MenuItemChanged[4] = 1;

			Quick_Measure_Threshold_btn_select = 2;
			
			New_Menu = 22;
			Menu_Changed = 1;

			break;
		}
	
		// Trigger Mode TV
		case 24 :
		{
			if ((MenuPopupActive > -1) && (MenuPopupActive != 22)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 22)
			{
				pos = -1;
				MenuPopupStep(22, &MenuStatus[MENU_TRIGGERTV][3], &pos, &pos, 24, 119, 2);
				
				New_Menu = 24;
				Menu_Changed = 1;
			}				
			
			Display::DRAWMENUPOPUP(22);	
			break;
		}		

		// More Utilities - CH4 Delay			BF #001
		case 25 :
		{	
			if (NumberOfChannels == 2){return;}	//only for 4 channel version

			if ((MenuPopupActive > -1) && (MenuPopupActive != 36))
			{ Display::DRAWMENUPOPDOWN(); }
			
			if (MenuPopupActive == 36)
			{
				pos = -1;
				MenuPopupStep(36, &MenuStatus[MENU_EXTUTILS][3], &pos, &pos, MENU_EXTUTILS, 203, 2);
			}

			New_Menu = MENU_EXTUTILS;
			Menu_Changed = 1;

			CH4_Del_Correct = MenuStatus[MENU_EXTUTILS][3] - 203;

			Display::DRAWMENUPOPUP(36);	

			//Save new values to flash -> done in ISR
			//config_changed = true;

			break;
		}			



		// Math  1 - 2
		case 26 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_MATH][3] == 0)
			{
				// If FFT was active bevore - switch back to old settings
				if (FFT_Mode != FFT_OFF)
				{
					FFT_Mode = FFT_OFF;

					Display::FFT_DrawStatus(1);					//clear UI-Planes	
					Hardware::FFT_Restore_Channels();						//restore channel setting
					Hardware::Zero_Levels_Restore();						//restore Zerolevels

					Display::RefreshScreen();
				}
			
				Channel_1_Active = 1;		// Math with only one channel makes no sense
				Channel_2_Active = 1;
				LED_ON[0] = 1;
				LED_ON[1] = 1;

				//switch off active button
				if (MenuStatus[MENU_MATH][1] == 1)
				{
					MenuItemChanged[1] = 1;
					MenuStatus[MENU_MATH][1] = 0;
				}
				
				else if (MenuStatus[MENU_MATH][2] == 1)
				{
					MenuItemChanged[2] = 1;
					MenuStatus[MENU_MATH][2] = 0;
				}
				
				else if (MenuStatus[MENU_MATH][4] == 1)
				{
					MenuItemChanged[4] = 1;
					MenuStatus[MENU_MATH][4] = 0;
				}

				MenuStatus[MENU_MATH][3] = 1;		//switch on new button

				New_Menu = MENU_MATH;
				Menu_Changed = 1;
			}
				
			break;
		}	
		
		// FFT - Settings - FFT-Length
		case 27 :
		{					
			if ((MenuPopupActive > -1) && (MenuPopupActive != 32)) { Display::DRAWMENUPOPDOWN(); }
			if (MenuPopupActive == 32)
			{
				pos = -1;
				MenuPopupStep(32, &MenuStatus[MENU_FFT][3], &pos, &pos, 27, 83, 2);
			}

			New_Menu = 27;
			Menu_Changed = 1;

			Display::DRAWMENUPOPUP(32);	

			if (MenuStatus[MENU_FFT][3] == 83)
			{
				 //if (FFT_Length !=  FFT_512)
				{ FFT_Length = FFT_512; FFT_Level = 9; Signal::FFT_BuildTrigoTables(); }
			 }
			else if (MenuStatus[MENU_FFT][3] == 84)
			{
				//if (FFT_Length !=  FFT_1024)
				{ FFT_Length = FFT_1024; FFT_Level = 10; Signal::FFT_BuildTrigoTables(); }
 			}

			//Display::RefreshScreen();
			Display::FFT_DrawStatus(0);

			break;	
		}

	}	
#ifdef _Debug_		
	if (Debug_Mode) printf("Function Button 4\n");		
#endif


}
// BF insert end
//######################################################################################################################################################
// BF insert
//Function button 5 pressed
void UserIF::F5_Btnhandler(void)					// Button Handler for function button
{
	short pos = 0;
	int buf_int;

#ifdef _Debug_		
       	printf("F5 Btn start\n");
#endif	
			
	if (MenuPopupActive > 0) Hardware::ResetTimer();
//	if (ZeroPopupChanged > 0) Hardware::ResetTimer();
			
	if ((Active_Menu == 1) && (Channel_1_Active == false)) return;
	if ((Active_Menu == 2) && (Channel_2_Active == false)) return;
	if ((Active_Menu == 3) && (Channel_3_Active == false)) return;
	if ((Active_Menu == 4) && (Channel_4_Active == false)) return;
	//if ((Active_Menu == 26) && (Channel_Math_Active == false)) return;
				
	if ((Active_Menu == 16) && (Cursor_Enabled == false)) return;
	if ((Active_Menu == 19) && (QM_Enabled == false)) return;
	if ((Active_Menu == 20) && (QM_Enabled == false)) return;
	if ((Active_Menu == 21) && (QM_Enabled == false)) return;
	if ((Active_Menu == 22) && (QM_Enabled == false)) return;
			
	MenuButtonCheck(4);
			
	switch(Active_Menu)
	{
		// Display -> Switch grid from dotted to solid	
		case 5 :
		{
			if(FFT_Mode == FFT_OFF)
			{
				if(dotted_grid)
				dotted_grid = 0;
				else
				dotted_grid = 1;
			}
			else
			{
				if(FFT_grid)
				{

					if(dotted_grid)
					dotted_grid = 0;
					else
					{FFT_grid = 0;}

/*
					if(dotted_grid)
					dotted_grid = 0;
					else
					{dotted_grid = 1; FFT_grid = 0;}
*/				}
				else
				{

					if(dotted_grid)
					FFT_grid = 1;
					else
					{dotted_grid = 1; }


/*
					if(dotted_grid)
					dotted_grid = 0;
					else
					{dotted_grid = 1; FFT_grid = 1;}
*/
				}

			}

			Display::RefreshScreen();

			New_Menu = Active_Menu;
			config_changed = true;

			break;
		}	
		

		//Utility -> test signal generator
		case 6 :
		{		
			if(test_signal)
			test_signal = 0;
			else
			test_signal = 1;

			break;
		}

		//  Save / Recall - > Clear Display
		case 8 :
		{		
			if ((Continius == false) || (MenuStatus[MENU_DISPLAY][0] == 241)) Hardware::ClearPlanes();	
			break;	
		}				

		// USTB-Shiftmode
		case 10 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_TIMEBASE][4] == 0)
			{
				MenuStatus[MENU_TIMEBASE][4] = 1;	//set shift mode to on
				MenuStatus[MENU_TIMEBASE][3] = 0;	//set roll mode to off 
				
				New_Menu = MENU_TIMEBASE;
				Menu_Changed = 1;
				
				MenuItemChanged[3] = 1;
				MenuItemChanged[4] = 1;

				if(USTB_Mode != USTB_OFF)
				{
					Signal::USTB_Clear_Buffer();
					USTB_Mode = USTB_SHIFT;
				}
				Display::DRAWSTATUS(7, 1);
				//Hardware::ClearPlanes();
				//Display::StatusUpdate();
			}
			//Display::DRAW_ALL_CURSOR();
							
			break;							
		}		

		
		// Trigger Mode  -> Probe
		case 12 :
		{
			EdgeToggle = 1;
			New_Menu = 12;
			Menu_Changed = 1;
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;

			break;
		}	
		
	
		// Pulse Width
		case 15 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (MenuStatus[MENU_PULSEWIDTH][2] == 2) break;

			if (MenuStatus[MENU_PULSEWIDTH][2] == 3)
			{					
				if (PulseToggle == 2)
				{					
					buf_int = (int) (Pulse12.Read_Value() * 100000000);	
					
					if (Rotary_Direction_mem_pulse == 1)
					{				
						if ((buf_int >= 1) && (buf_int < 10))
						{
							Pulse12.Write_Value(0.000000104);
			
							Pulse12_Value = 104;
							Pulse12_Steps = 8;
							Pulse12_Expo = 1;
						}
						else if ((buf_int >= 10) && (buf_int < 100))
						{
							Pulse12.Write_Value(0.000001);
			
							Pulse12_Value = 1;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int >= 100) && (buf_int < 1000))
						{
							Pulse12.Write_Value(0.00001);
			
							Pulse12_Value = 10;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int >= 1000) && (buf_int < 10000))
						{
							Pulse12.Write_Value(0.0001);
			
							Pulse12_Value = 100;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int >= 10000) && (buf_int < 100000))
						{
							Pulse12.Write_Value(0.001);
			
							Pulse12_Value = 1;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else if ((buf_int >= 100000) && (buf_int < 1000000))
						{
							Pulse12.Write_Value(0.01);
			
							Pulse12_Value = 10;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else if ((buf_int >= 1000000) && (buf_int < 10000000))
						{
							Pulse12.Write_Value(0.1);
			
							Pulse12_Value = 100;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else
						{
							Pulse12.Write_Value(0.000000016);
			
							Pulse12_Value = 16;
							Pulse12_Steps = 8;
							Pulse12_Expo = 1;
						}
					}
					else	
					{
						if (buf_int == 1)
						{
							Pulse12.Write_Value(0.1);
			
							Pulse12_Value = 100;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else if (buf_int == 10)
						{
							Pulse12.Write_Value(0.000000016);
			
							Pulse12_Value = 16;
							Pulse12_Steps = 8;
							Pulse12_Expo = 1;
						}
						else if ((buf_int > 10) && (buf_int <= 100))
						{
							Pulse12.Write_Value(0.000000104);
			
							Pulse12_Value = 104;
							Pulse12_Steps = 8;
							Pulse12_Expo = 1;
						}
						else if ((buf_int > 100) && (buf_int <= 1000))
						{
							Pulse12.Write_Value(0.000001);
			
							Pulse12_Value = 1;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int > 1000) && (buf_int <= 10000))
						{
							Pulse12.Write_Value(0.00001);
			
							Pulse12_Value = 10;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int > 10000) && (buf_int <= 100000))
						{
							Pulse12.Write_Value(0.0001);
			
							Pulse12_Value = 100;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int > 100000) && (buf_int <= 1000000))
						{
							Pulse12.Write_Value(0.001);
			
							Pulse12_Value = 1;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else if ((buf_int > 1000000) && (buf_int <= 10000000))
						{
							Pulse12.Write_Value(0.01);
			
							Pulse12_Value = 10;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else
						{
							Pulse12.Write_Value(0.1);
			
							Pulse12_Value = 100;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
					}

					Pulse12.RenderText();
					trig_range_reg = (unsigned int) (Pulse12.Read_Value() / (float) 0.000000008);
				}
				else PulseToggle = 2;
			}
			else
			{
				if (PulseToggle == 2)
				{					
					buf_int = (int) (Pulse22.Read_Value() * 100000000);	
					
					if (Rotary_Direction_mem_pulse == 1)
					{		
						if ((buf_int >= 1) && (buf_int < 10))
						{
							Pulse22.Write_Value(0.000000104);
			
							Pulse22_Value = 104;
							Pulse22_Steps = 8;
							Pulse22_Expo = 1;
						}
						else if ((buf_int >= 10) && (buf_int < 100))
						{
							Pulse22.Write_Value(0.000001);
			
							Pulse22_Value = 1;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
						else if ((buf_int >= 100) && (buf_int < 1000))
						{
							Pulse22.Write_Value(0.00001);
			
							Pulse22_Value = 10;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
						else if ((buf_int >= 1000) && (buf_int < 10000))
						{
							Pulse22.Write_Value(0.0001);
			
							Pulse22_Value = 100;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
		
						else if ((buf_int >= 10000) && (buf_int < 100000))
						{
							Pulse22.Write_Value(0.001);
			
							Pulse22_Value = 1;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else if ((buf_int >= 100000) && (buf_int < 1000000))
						{
							Pulse22.Write_Value(0.01);
			
							Pulse22_Value = 10;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else if ((buf_int >= 1000000) && (buf_int < 10000000))
						{
							Pulse22.Write_Value(0.1);
			
							Pulse22_Value = 100;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else
						{
							Pulse22.Write_Value(0.000000016);
			
							Pulse22_Value = 16;
							Pulse22_Steps = 8;
							Pulse22_Expo = 1;
						}
					}
					else 	
					{
						if (buf_int == 1)
						{
							Pulse22.Write_Value(0.1);
			
							Pulse22_Value = 100;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else if (buf_int == 10)
						{
							Pulse22.Write_Value(0.000000016);
			
							Pulse22_Value = 16;
							Pulse22_Steps = 8;
							Pulse22_Expo = 1;
						}
						else if ((buf_int > 10) && (buf_int <= 100))
						{
							Pulse22.Write_Value(0.000000104);
			
							Pulse22_Value = 104;
							Pulse22_Steps = 8;
							Pulse22_Expo = 1;
						}
						else if ((buf_int > 100) && (buf_int <= 1000))
						{
							Pulse22.Write_Value(0.000001);
			
							Pulse22_Value = 1;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
						else if ((buf_int > 1000) && (buf_int <= 10000))
						{
							Pulse22.Write_Value(0.00001);
			
							Pulse22_Value = 10;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
						else if ((buf_int > 10000) && (buf_int <= 100000))
						{
							Pulse22.Write_Value(0.0001);
			
							Pulse22_Value = 100;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
		
						else if ((buf_int > 100000) && (buf_int <= 1000000))
						{
							Pulse22.Write_Value(0.001);
			
							Pulse22_Value = 1;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else if ((buf_int > 1000000) && (buf_int <= 10000000))
						{
							Pulse22.Write_Value(0.01);
			
							Pulse22_Value = 10;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else
						{
							Pulse22.Write_Value(0.1);
			
							Pulse22_Value = 100;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
					}		
		
					Pulse22.RenderText();
					trig_width_reg = (unsigned int) ((Pulse22.Read_Value() / (float) 0.000000008));
				}
				else PulseToggle = 2;
			}

			
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
		
			New_Menu = 15;
			Menu_Changed = 1;
			TriggerWayChanged = 1;
	
			Hardware::UpdateTrigger();

			Display::StatusUpdate();

			break;	
		}	
	
		// Cursor -> Y2
		case 16 :
		{		
			if (Cursor_Enabled == 0) break;
			{
				if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
	
				if (Cursor_Vertical_Active_Old == 1) MenuItemChanged[1] = 1;
				else if (Cursor_Vertical_Active_Old == 2) MenuItemChanged[2] = 1;					
				else if (Cursor_Vertical_Active_Old == 4) MenuItemChanged[5] = 1;
				else if (Cursor_Horizontal_Active_Old == 1) MenuItemChanged[3] = 1;
				else if (Cursor_Horizontal_Active_Old == 4) MenuItemChanged[5] = 1;

				Cursor_Vertical_Active = 3;
				Cursor_Horizontal_Active = 2;
					
				if(FFT_Mode != FFT_OFF)
				Display::FFT_CalcCursorData();
				else
				Display::CALCCURSORDATA();

								
				New_Menu = 16;
				Menu_Changed = 1;

				Display::DRAW_ALL_CURSOR();
			}
			break;			
		}
		
		// Quick Print -> Save to ????
		case 17 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			//MenuItemChanged[4] = 1;
							
			New_Menu = 17;
			//Menu_Changed = 1;
			
			//CommIF::DUMPCSV('A');	// save to ASCII

			return;					
		}				


	
		// Quick Measurement -> Settings
		case 19 :
		{		
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if ((MenuStatus[MENU_QUICKMEASURE][1] - 52) == 4)
			{
				New_Menu = 20;
				Menu_Changed = 1;
			}
			if ((MenuStatus[MENU_QUICKMEASURE][1] - 52) == 13)
			{
				New_Menu = 21;
				Menu_Changed = 1;
			}

			break;
		}
		
		// Quick Measurement -> Add Measurement
		case 20 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }				

			QM_Type_Old[0] = QM_Type[0];
			QM_Type_Old[1] = QM_Type[1];
			QM_Type_Old[2] = QM_Type[2];

			if (QM_Type[0] == 0)
			{
				QM_Type[0] = MenuStatus[MENU_QUICKMEASURE][1] - 51;
				QM_Changed[0] = 1;
				QM_Channel[0] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
			}
			else if (QM_Type[1] == 0)
			{
				if ((QM_Type[0] != (MenuStatus[MENU_QUICKMEASURE][1] - 51)) || (QM_Channel[0] != (MenuStatus[MENU_QUICKMEASURE][0] - 26)))
				{
					QM_Type[1] = MenuStatus[MENU_QUICKMEASURE][1] - 51;
					QM_Changed[1] = 1;
					QM_Channel[1] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
				}
			}
			else if (QM_Type[2] == 0)
			{
				if ((QM_Type[1] != (MenuStatus[MENU_QUICKMEASURE][1] - 51)) || (QM_Channel[1] != (MenuStatus[MENU_QUICKMEASURE][0] - 26)))
				{
					QM_Type[2] = MenuStatus[MENU_QUICKMEASURE][1] - 51;
					QM_Changed[2] = 1;
					QM_Channel[2] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
				}
			}
			else
			{
				if ((QM_Type[2] != (MenuStatus[MENU_QUICKMEASURE][1] - 51)) || (QM_Channel[2] != (MenuStatus[MENU_QUICKMEASURE][0] - 26)))
				{
					QM_Type[0] = QM_Type[1];
					QM_Type[1] = QM_Type[2];
					QM_Type[2] = MenuStatus[MENU_QUICKMEASURE][1] - 51;
		
					QM_Channel[0] = QM_Channel[1];
					QM_Channel[1] = QM_Channel[2];
					QM_Channel[2] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
		
					QM_Changed[0] = 1;
					QM_Changed[1] = 1;
					QM_Changed[2] = 1;
				}
			}

			Quick_Measure_First_Draw = 1;

			New_Menu = 20;
			Menu_Changed = 1;

			//QM_Vertical_Active = 0;
			//QM_Horizontal_Active = 0;
	
			Display::CALCQMDATA();

			break;
		}

		// Quick Measurement -> Add Measurement
		case 21 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
			
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }				

			QM_Type_Old[0] = QM_Type[0];
			QM_Type_Old[1] = QM_Type[1];
			QM_Type_Old[2] = QM_Type[2];

			if (QM_Type[0] == 0)
			{
				QM_Type[0] = MenuStatus[MENU_QUICKMEASURE][1] - 51;
				QM_Changed[0] = 1;
				QM_Channel[0] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
			}
			else if (QM_Type[1] == 0)
			{
				if ((QM_Type[0] != (MenuStatus[MENU_QUICKMEASURE][1] - 51)) || (QM_Channel[0] != (MenuStatus[MENU_QUICKMEASURE][0] - 26)))
				{
					QM_Type[1] = MenuStatus[MENU_QUICKMEASURE][1] - 51;
					QM_Changed[1] = 1;
					QM_Channel[1] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
				}
			}
			else if (QM_Type[2] == 0)
			{
				if ((QM_Type[1] != (MenuStatus[MENU_QUICKMEASURE][1] - 51)) || (QM_Channel[1] != (MenuStatus[MENU_QUICKMEASURE][0] - 26)))
				{
					QM_Type[2] = MenuStatus[MENU_QUICKMEASURE][1] - 51;
					QM_Changed[2] = 1;
					QM_Channel[2] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
				}
			}
			else
			{
				if ((QM_Type[2] != (MenuStatus[MENU_QUICKMEASURE][1] - 51)) || (QM_Channel[2] != (MenuStatus[MENU_QUICKMEASURE][0] - 26)))
				{
					QM_Type[0] = QM_Type[1];
					QM_Type[1] = QM_Type[2];
					QM_Type[2] = MenuStatus[MENU_QUICKMEASURE][1] - 51;
		
					QM_Channel[0] = QM_Channel[1];
					QM_Channel[1] = QM_Channel[2];
					QM_Channel[2] = MenuStatus[MENU_QUICKMEASURE][0] - 26;
		
					QM_Changed[0] = 1;
					QM_Changed[1] = 1;
					QM_Changed[2] = 1;
				}
			}

			Quick_Measure_First_Draw = 1;

			New_Menu = 21;
			Menu_Changed = 1;

			//QM_Vertical_Active = 0;
			//QM_Horizontal_Active = 0;
	
			Display::CALCQMDATA();

			break;
		}

		// Quick Measurement Threshold -> Upper
		case 22 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			if (Quick_Measure_Threshold_btn_select == 1) MenuItemChanged[2] = 1;
			else if (Quick_Measure_Threshold_btn_select == 2) MenuItemChanged[3] = 1;

			Quick_Measure_Threshold_btn_select = 3;
			New_Menu = 22;
			Menu_Changed = 1;

			break;
		} 	

		// More Utilities - go to Hardware Menu		BF #004
		case 25 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			New_Menu = MENU_HARDWARE;	// 18
			Menu_Changed = 1;

			break;
		}			


		// Math  1 + 2
		case 26 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_MATH][4] == 0)
			{
				// If FFT was active bevore - switch back to old settings
				if (FFT_Mode != FFT_OFF)
				{
					FFT_Mode = FFT_OFF;
					
					Display::FFT_DrawStatus(1);							//clear UI-Planes	
					Hardware::FFT_Restore_Channels();						//restore channel setting
					Hardware::Zero_Levels_Restore();						//restore Zerolevels

					Display::RefreshScreen();

				}

				Channel_1_Active = 1;				// Math with only one channel makes no sense
				Channel_2_Active = 1;
				LED_ON[0] = 1;
				LED_ON[1] = 1;

				//switch off active button
				if (MenuStatus[MENU_MATH][1] == 1)
				{
					MenuItemChanged[1] = 1;
					MenuStatus[MENU_MATH][1] = 0;
				}
				
				else if (MenuStatus[MENU_MATH][2] == 1)
				{
					MenuItemChanged[2] = 1;
					MenuStatus[MENU_MATH][2] = 0;
				}
				
				else if (MenuStatus[MENU_MATH][3] == 1)
				{
					MenuItemChanged[3] = 1;
					MenuStatus[MENU_MATH][3] = 0;
				}

				MenuStatus[MENU_MATH][4] = 1;			//switch on new active button

				New_Menu = 26;
				Menu_Changed = 1;
			}
				
			break;
		}	
	
		// FFT Settings - Layout (yellow buttons vs. black design)
		case 27 :
		{				
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			if(FFT_Layout)
			{ Display::FFT_DrawStatus(1); FFT_Layout = 0; }
			else
			FFT_Layout = 1; 

			Display::RefreshScreen();	// draw new FFT grid area 
            		config_changed = true;	

			New_Menu = 27;
			Menu_Changed = 1;
			break;
		}
	}
#ifdef _Debug_		
	if (Debug_Mode) printf("Function Button 5\n");		
#endif			

}
// BF insert end
//######################################################################################################################################################
// BF insert
//Function button 6 pressed
void UserIF::F6_Btnhandler(void)					// Button Handler for function button
{
	short pos = 0;
	int ix;

#ifdef _Debug_		
       	printf("F6 Btn start\n");
#endif


	if (MenuPopupActive > 0) Hardware::ResetTimer();
//	if (ZeroPopupChanged > 0) Hardware::ResetTimer();
				
	if ((Active_Menu == 1) && (Channel_1_Active == false)) return;
	if ((Active_Menu == 2) && (Channel_2_Active == false)) return;
	if ((Active_Menu == 3) && (Channel_3_Active == false)) return;
	if ((Active_Menu == 4) && (Channel_4_Active == false)) return;
	//if ((Active_Menu == 26) && (Channel_Math_Active == false)) return;
							
	if ((Active_Menu == 16) && (Cursor_Enabled == false)) return;
	if ((Active_Menu == 19) && (QM_Enabled == false)) return;
	if ((Active_Menu == 20) && (QM_Enabled == false)) return;
	if ((Active_Menu == 21) && (QM_Enabled == false)) return;
	if ((Active_Menu == 22) && (QM_Enabled == false)) return;

	MenuButtonCheck(5);
			
	switch(Active_Menu)
	{	

		//Display -> Switch drawing from pixel connect to line drawing
		case 5 :
		{		

			if(draw_mode)
			{
				draw_mode = 0;	//pixel connecting
	
				Display::DRAWROUNDBUTTON(230, 180, 200, 80, 0, 0);
				Display::TEXTOUTxvbig("     Fast drawing with", 247, 200, 1, UI_Plane2);
				Display::TEXTOUTxvbig("vertical pixel connection.", 247, 220, 1, UI_Plane2);
				//Display::TEXTOUTxvbig("connection.", 247, 232, 1, UI_Plane2);
				
				nr_delay(800);

				//Delete popup
				Display::DRAWROUNDBUTTON(230, 180, 200, 80, 0, 1);
				Display::TEXTOUTxvbig("     Fast drawing with", 247, 200, 0, UI_Plane2);
				Display::TEXTOUTxvbig("vertical pixel connection.", 247, 220, 0, UI_Plane2);
				//Display::TEXTOUTxvbig("connection.", 247, 232, 0, UI_Plane2);


			}
			else
			{
				draw_mode = 1;	//line() drawing

				Display::DRAWROUNDBUTTON(230, 180, 200, 80, 0, 0);
				Display::TEXTOUTxvbig("Accurate drawing with", 247, 200, 1, UI_Plane2);
				Display::TEXTOUTxvbig("    Line() function.", 247, 220, 1, UI_Plane2);
				//Display::TEXTOUTxvbig("connection.", 247, 232, 1, UI_Plane2);
				
				nr_delay(800);

				//Delete popup
				Display::DRAWROUNDBUTTON(230, 180, 200, 80, 0, 1);
				Display::TEXTOUTxvbig("Accurate drawing with", 247, 200, 0, UI_Plane2);
				Display::TEXTOUTxvbig("    Line() function.", 247, 220, 0, UI_Plane2);
				//Display::TEXTOUTxvbig("connection.", 247, 232, 0, UI_Plane2);

			}
			config_changed = true;
			break;
		}

		// Utilities -> More		BF #001
		case 6 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			New_Menu = MENU_EXTUTILS;	// 25
			Menu_Changed = 1;
			break;		
		}			


		// Save / Recall -> restore settings
		case 8 :
		{
			//if (RC_overlay)
			//{ RC_overlay = 0; }
			//else
			//{
				RC_overlay = 0;
				RC_request = 0;
				Hardware::Stop_Record();
				Hardware::Restore_From_Flash();
				//Display::DrawInitialScreen();
				//Display::RefreshScreen();
				Hardware::Start_Record();
			//}
			break;
		}	


		//Timebase menu -> browse   BF transferred from display menu
		case 10 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (USTB_Mode != USTB_OFF) return;

			if (MenuStatus[MENU_TIMEBASE][5] == 241)
			MenuStatus[MENU_TIMEBASE][5] = 240;
			else
			MenuStatus[MENU_TIMEBASE][5] = 241;

			if (FFT_Mode == FFT_OFF)
			{
				if (MenuStatus[MENU_TIMEBASE][5] == 241)
				Display::DRAWMEMORY(0, 1, 1);		//open browser window
				else
				{
					Display::DRAWMEMORY(1, 0, 0);	//close browser window	
					Display::DRAW_ALL_CURSOR();
				}
			}
			New_Menu = MENU_TIMEBASE;
			Menu_Changed = 1;				

			break;

		}



		// Cursor -> X1X2/Y1Y2
		case 16 :
		{		
			if (Cursor_Enabled == 0) break;
			
			{
				if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
	
				if (Cursor_Vertical_Active_Old == 1) MenuItemChanged[1] = 1;
				else if (Cursor_Vertical_Active_Old == 2) MenuItemChanged[2] = 1;
				else if (Cursor_Horizontal_Active_Old == 1) MenuItemChanged[3] = 1;
				else if (Cursor_Horizontal_Active_Old == 2) MenuItemChanged[4] = 1;
	
				Cursor_Both_Selected_Old = Cursor_Both_Selected;

				if ((Cursor_Vertical_Active == 4) || (Cursor_Horizontal_Active == 4))
				{
					if (Cursor_Both_Selected == 0)
					{
						Cursor_Both_Selected = 1;
						Cursor_Vertical_Active = 3;
						Cursor_Horizontal_Active = 4;
					}
					else
					{
						Cursor_Both_Selected = 0;
						Cursor_Vertical_Active = 4;
						Cursor_Horizontal_Active = 3;
					}
				}
				else
				{
					if (Cursor_Both_Selected == 0)
					{
						Cursor_Vertical_Active = 4;
						Cursor_Horizontal_Active = 3;
					}
					else
					{
						Cursor_Vertical_Active = 3;
						Cursor_Horizontal_Active = 4;
					}
				}
					
				if(FFT_Mode != FFT_OFF)
				Display::FFT_CalcCursorData();
				else
				Display::CALCCURSORDATA();

								
				New_Menu = 16;
				Menu_Changed = 1;

				Display::DRAW_ALL_CURSOR();
			}
			break;	
		}	

		// Quick Print - Screenshot Version		BF #006
		case 17 :
		{	
			if ((MenuPopupActive > -1) && (MenuPopupActive != 39))
			{ Display::DRAWMENUPOPDOWN(); }
			
			if (MenuPopupActive == 39)
			{
				pos = -1;
				MenuPopupStep(39, &MenuStatus[MENU_QUICKPRINT][5], &pos, &pos, MENU_HARDWARE, 186, 2);
			}

			OS_CompMode = MenuStatus[MENU_QUICKPRINT][5] - 186;	//switch between OS and BF-Version

			New_Menu = MENU_QUICKPRINT;
			Menu_Changed = 1;
			
			config_changed = true;					//Save new value to flash

			Display::DRAWMENUPOPUP(39);	

			break;
		}			

		
		// Hardware -> Back to Extended Utilities		BF #004
		case 18 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			New_Menu = MENU_EXTUTILS;	// 25
			Menu_Changed = 1;
			break;		
		}			

	
		// Quick Measurement -> Thresholds
		case 19 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
			
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			New_Menu = 22;
			Menu_Changed = 1;
			break;		
		}				
			
		// Quick Measurement Delay Settings
		case 20 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
			
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			New_Menu = 19;
			Menu_Changed = 1;
			break;		
		}
		
		// Quick Measurement Phase Settings
		case 21 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			New_Menu = 19;
			Menu_Changed = 1;
			break;		
		}				
		
		// Quick Measurement Thresholds
		case 22 :
		{		
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = 19;
			Menu_Changed = 1;
			break;
		}	

		// More Utilities -> Back to Utilities			BF #001
		case 25 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			New_Menu = 6;
			Menu_Changed = 1;
			break;		
		}			

	
		// FFT settings
		case 27 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 1) break;

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = 26;
			Menu_Changed = 1;
			break;	
		}		

		// More FFT settings
		case 28 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = 27;
			Menu_Changed = 1;
			break;		
		}	
					
		// Math settings
		case 29 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = 26;
			Menu_Changed = 1;
			break;		
		}		
				
		// Edge -> Default Setup
		case 14 :
		{
			Hardware::Reset_To_Default();
			config_changed = true; 
			break;
		}
	}			
#ifdef _Debug_		
	if (Debug_Mode) printf("Function Button 6\n");
#endif			


}
// BF insert end
//######################################################################################################################################################

char UserIF::MenuButtonCheck(char BtnNr)
{
	char ct, found = 0;
	
	for (ct = 0; ct < 6; ct++)
	{
		if (MenuItemPushed[ct] == 1) { found = 1; MenuItemPushed[ct] = 0; MenuItemPushed_old[ct] = 1; MenuItemChanged[ct] = 1;}
	}
	
	if (found) Hardware::ResetTimer();

	if (BtnNr > -1)
	{
		MenuItemChanged[BtnNr] = 1;
		MenuItemPushed[BtnNr] = 1;	
	}
	return found;
}

//######################################################################################################################################################
// BF menu popup logic - stepping up or down
void UserIF::MenuPopupStep(int MenuPopupNr, short *MenuStatusNr, short *MenuStatusNr2, short *MenuStatusNr3, int DrawMenuNr, int start, char dir)
{
	int x, pos = 0;
	int newpos = 0;
	
	unsigned short count = 0;
	
	count = MenuPopupDef[MenuPopupActive][1];
	
	for (x = 0; x < count; x++)
	{
		if (MenuPopupStatus[MenuPopupNr][x] == 3) pos = x;
	}
	
	//BF from top to bottom down
	if (dir == 2)
	{
		newpos = -1;
		for (x = pos; x < count; x++)
		{
			if (MenuPopupStatus[MenuPopupNr][x] == 2)
			{
				newpos = x;
				break;
			}
		}	
		
		if (newpos == -1)
		{
			for (x = 0; x < pos; x++)
			{
				if (MenuPopupStatus[MenuPopupNr][x] == 2)
				{
					newpos = x;
					break;
				}
			}
		}
	}
	else //BF from bottom up
	{
		newpos = -1;
		for (x = pos; x >= 0; x--)
		{
	//            printf("DoStep (%d) down to %d = %d\n", MenuPopupNr, x, MenuPopupStatus[MenuPopupNr][x]);
			if (MenuPopupStatus[MenuPopupNr][x] == 2)
			{
				newpos = x;
				break;
			}
		}	
		
		if (newpos == -1)
		{
	//            printf("Nothing found\n");
			for (x = count; x > pos; x--)
			{
				if (MenuPopupStatus[MenuPopupNr][x] == 2)
				{
				newpos = x;
				break;
				}
			}
		}
    	}    	
    
//    printf("Pos : %2d NewPos : %2d dir : %2d\n", pos, newpos, dir);
	
    if (newpos == -1) return;	
	
	MenuPopupStatus[MenuPopupNr][pos] = 2;
	MenuPopupStatus[MenuPopupNr][newpos] = 3;
	
	MenuStatusNr[0] = start + newpos;	//BF -> check if start can be loaded from menu structure!!!!!!!!!!
    if (MenuStatusNr2[0] > -1) { MenuStatusNr2[0] = start + newpos; }
    if (MenuStatusNr3[0] > -1) { MenuStatusNr3[0] = start + newpos; }	
}		

//######################################################################################################################################################

void UserIF::ON_Rotary_Position(void)
{
	int pos = 0;
	int cd_size_buf = (int) (Cursor_Delayed_Size / 2);
	int rot_buf = Rotary_Steps;


	// BF -> if ultra slow timebase active leave
	if (USTB_Mode != USTB_OFF) return;
	if (FFT_Mode != FFT_OFF) return;

	if ((MenuStatus[MENU_TIMEBASE][1] == 0) || (MenuStatus[MENU_TIMEBASE][1] == 246))
	{
		//rot_buf = ((int) ((float)rot_buf * ZFT_float));
	
		//rot_buf = (rot_buf * rot_buf) + rot_buf; 		//BF new square function characteristic X² + X
		rot_buf = (rot_buf * rot_buf * rot_buf) + rot_buf; 	//BF new cubic function characteristic X³ + X
	
	
	/*BF del
		if ((rot_buf > ((int) ((float)5 * ZFT_float))) && (rot_buf < ((int) ((float)11 * ZFT_float)))) rot_buf = rot_buf * 3;
		else if (rot_buf > ((int) ((float)10 * ZFT_float))) rot_buf = rot_buf * 7;	
	*/
		//if ((rot_buf > 5) && (rot_buf < 11)) rot_buf = rot_buf * 15;
		//else if (rot_buf > 10) rot_buf = rot_buf * 40;	
		
		if (Rotary_Direction)
		{
			if (Selected_Timebase < 9)
			{
				//BF del if ((MemWinStart + SIG_Size[ZIT_short] + rot_buf) < 16250)
				//if ((MemWinStart + SignalSize[Timebase_Idx] + rot_buf) < 16250)
				if ((MemWinStart + SignalSize[Timebase_Idx] + rot_buf) < 16000)
				{ MemWinStart = MemWinStart + rot_buf; }
				else
				//BF del { MemWinStart = 16250 - SIG_Size[ZIT_short]; }
				//{ MemWinStart = 16250 - SignalSize[Timebase_Idx]; }
				{ MemWinStart = 16000 - SignalSize[Timebase_Idx]; }
			}
			else
			{
				//BF del if ((MemWinStart + SIG_Size[ZIT_short] + rot_buf) < 4070)
				//if ((MemWinStart + SignalSize[Timebase_Idx] + rot_buf) < 4070)
				if ((MemWinStart + SignalSize[Timebase_Idx] + rot_buf) < 4000)
				{ MemWinStart = MemWinStart + rot_buf; }
				else
				//BF del { MemWinStart = 4070 - SIG_Size[ZIT_short]; }
				//{ MemWinStart = 4070 - SignalSize[Timebase_Idx]; }
				{ MemWinStart = 4000 - SignalSize[Timebase_Idx]; }
			}
		}
		else
		{
		if ((MemWinStart - rot_buf) > 100)
		{ MemWinStart = MemWinStart - rot_buf; }
		else
		{ MemWinStart = 100; }
		}
	
	}    		
	else  // Delayed mode
	{
		if ((rot_buf > 5) && (rot_buf < 11)) rot_buf = rot_buf * 3;
		else if (rot_buf > 10) rot_buf = rot_buf * 7;	
		
		if (Rotary_Direction)
		{
		if ((dmode_Window_Offset_Pos + rot_buf) < (300 - cd_size_buf)) dmode_Window_Offset_Pos = dmode_Window_Offset_Pos + rot_buf;
		else dmode_Window_Offset_Pos = 300 - cd_size_buf;
		}
		else
		{
		if ((dmode_Window_Offset_Pos - rot_buf) > (-300 + cd_size_buf)) dmode_Window_Offset_Pos = dmode_Window_Offset_Pos - rot_buf;
		else dmode_Window_Offset_Pos = (-300 + cd_size_buf);
		}
	}

    	Hardware::RecalcTimeParameters();
    
 // TMW changed 
	if ((MenuStatus[MENU_TIMEBASE][1] == 0) || (MenuStatus[MENU_TIMEBASE][1] == 246)) 
	{
        	if (Memory_Window_visible)
            	  Display::DRAWMEMORY(0, 0, 1);
        	else
	          Display::DRAWMEMORY(0, 1, 1);
     	}
// TMW change ends
    
    
    Display::CALCPRETRIGGER();
    Display::DRAW_ALL_CURSOR();

    //Display::DRAWSTATUS(5, 1);									// Draw Pre Trigger

 
#ifdef _Debug_Memory_
    if (Debug_Mode) printf("TB Offset = %d\n", Timebase_Offset_Pos);
#endif
}

//######################################################################################################################################################

void UserIF::ON_Trigger_Level(void)
{
	
	if (MenuStatus[MENU_TRIGGEREDGE][1] == 142) return;					//BF TV -> no level
	if ((MenuStatus[MENU_TRIGGEREDGE][1] == 141) && (MenuPopupStatus[8][2] == 3)) return; 	//BF Line -> no level
	if (XY_Mode) return;

	if (FFT_Mode != FFT_OFF) return;	//BF test

	if (RC_overlay) return;	
	if (RC_request) return;	



/*BF del
    if ((Rotary_Steps > 5) && (Rotary_Steps < 11)) Rotary_Steps = Rotary_Steps * 3;
    else if (Rotary_Steps > 10) Rotary_Steps = Rotary_Steps * 7;
*/
	Rotary_Steps = ((Rotary_Steps * Rotary_Steps) >> 2) + Rotary_Steps; 	//BF new square function characteristic 1/4 * X² + x

	if (Rotary_Direction == 0)	//BF changed direction #019
	{
		//if (triggering == 0) return;
		if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
			
		switch(Selected_Trigger_Source)
		{
			case 1: if ((Trigger_Pos_CH1 + Rotary_Steps) < GRID_HEIGHT) Trigger_Pos_CH1 = Trigger_Pos_CH1 + Rotary_Steps; else Trigger_Pos_CH1 = GRID_HEIGHT; Trigger_Pos_CH1_os = 0; break;
			case 2: if ((Trigger_Pos_CH2 + Rotary_Steps) < GRID_HEIGHT) Trigger_Pos_CH2 = Trigger_Pos_CH2 + Rotary_Steps; else Trigger_Pos_CH2 = GRID_HEIGHT; Trigger_Pos_CH2_os = 0; break;
			case 3: if ((Trigger_Pos_CH3 + Rotary_Steps) < GRID_HEIGHT) Trigger_Pos_CH3 = Trigger_Pos_CH3 + Rotary_Steps; else Trigger_Pos_CH3 = GRID_HEIGHT; Trigger_Pos_CH3_os = 0; break;
			case 4: if ((Trigger_Pos_CH4 + Rotary_Steps) < GRID_HEIGHT) Trigger_Pos_CH4 = Trigger_Pos_CH4 + Rotary_Steps; else Trigger_Pos_CH4 = GRID_HEIGHT; Trigger_Pos_CH4_os = 0; break;
			case 5: if ((Trigger_Pos_CHE - 1) > 0) Trigger_Pos_CHE = Trigger_Pos_CHE - 1; else Trigger_Pos_CHE = 0; break;
		}
	
	}
	else
	{
		//if (triggering == 0) return;
		if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		
		switch(Selected_Trigger_Source)
		{
			case 1: if ((Trigger_Pos_CH1 - Rotary_Steps) > 0) Trigger_Pos_CH1 = Trigger_Pos_CH1 - Rotary_Steps; else Trigger_Pos_CH1 = 0; break;
			case 2: if ((Trigger_Pos_CH2 - Rotary_Steps) > 0) Trigger_Pos_CH2 = Trigger_Pos_CH2 - Rotary_Steps; else Trigger_Pos_CH2 = 0; break;
			case 3: if ((Trigger_Pos_CH3 - Rotary_Steps) > 0) Trigger_Pos_CH3 = Trigger_Pos_CH3 - Rotary_Steps; else Trigger_Pos_CH3 = 0; break;
			case 4: if ((Trigger_Pos_CH4 - Rotary_Steps) > 0) Trigger_Pos_CH4 = Trigger_Pos_CH4 - Rotary_Steps; else Trigger_Pos_CH4 = 0; break;
			case 5: if ((Trigger_Pos_CHE + 1) < 102) Trigger_Pos_CHE = Trigger_Pos_CHE + 1; else Trigger_Pos_CHE = 102; break;	//BF #019
			//case 5: if ((Trigger_Pos_CHE + 1) < 32) Trigger_Pos_CHE = Trigger_Pos_CHE + 1; else Trigger_Pos_CHE = 32; break;	//BF del
		}
	
	}
		Hardware::UpdateTrigger();

		Display::DRAWSTATUS(6, 1);			// Draw Trigger Level
		VS_TrigLevelChanged = Selected_Trigger_Source;

}
//######################################################################################################################################################
// Main wheel dispatcher
void UserIF::ON_Main_Wheel(void)
{
    if (Rotary_Direction)
    {
        HandleMainWheel(1);
    }
    else
    {
        HandleMainWheel(0);
    }
}
//######################################################################################################################################################
// Timebase wheel handler
void UserIF::ON_Timebase(void)
{
	int rbuf = Rotary_Steps;
	
	//    reset_watchdog->np_piodata = 0x00;
	
	//printf("On_TB_1_%d : rbuf : %d distb :%d = Sel %d + idx %d\n", Rotary_Direction, rbuf, Timebase_Idx, Selected_Timebase, SIGNALFaktor_idx);
	
	if (FFT_Mode != FFT_OFF)
	{
		if (Selected_Timebase == 23 && !Rotary_Direction)		// no FFT for ultra slow timebases
		{
			Rotary_Steps = 0;
			return;
		}
	}

	Timebase_Idx_Old  = Timebase_Idx;
	Selected_Timebase_Old = Selected_Timebase;
	SIGNALFaktor_idx_Old  = SIGNALFaktor_idx;

	//BF added for new start/stop logic
	Hardware::Stop_Record();
			
	if (Rotary_Direction)	//clockwise -> decrement timebase
	{
//		if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }          	
		
		// Delayed Mode
		if (MenuStatus[MENU_TIMEBASE][1] == 1)
		{

			while (rbuf > 0 && dmode_Selected_Timebase < Dm_Sel_Tb_End[Timebase_Idx])
			{
					dmode_Selected_Timebase++;
					TimebaseChanged = 1;
					SIGNALFaktorChanged = 1;
					rbuf--;
			}

		}
		// Main Mode
		else		
		{	  	
			if (Continius == 0)
			{
				while (rbuf > 0)
				{
				if (SIGNALFaktor_idx > 0)
				{	
					SIGNALFaktor_idx--;
					SIGNALFaktorChanged = 1;
				}
				//BF test delete   else if ((Selected_Timebase > 2) && (Selected_Timebase < 5) && (SIGNALFaktor_idx == 0))
				else if ((Selected_Timebase > 0) && (Selected_Timebase < 5) && (SIGNALFaktor_idx == 0)) //BF new timebase 5nS + 2nS
				{
					Selected_Timebase--;
					TimebaseChanged = 1;
					SIGNALFaktorChanged = 1;
				}
				rbuf--;
				}
			}
			else	//Continius == 1
			{
				while (rbuf > 0)
				{
					if ((Selected_Timebase > 4) && (SIGNALFaktor_idx == 4))
					{
						Selected_Timebase--;
						TimebaseChanged = 1;
						SIGNALFaktorChanged = 1;
					}
					else if ((Selected_Timebase > 6) && (SIGNALFaktor_idx == 2))
					{
						Selected_Timebase--;
						TimebaseChanged = 1;
						SIGNALFaktorChanged = 1;
					}
					else if (SIGNALFaktor_idx > 0)
					{	
						SIGNALFaktor_idx--;
						SIGNALFaktorChanged = 1;
					}
					
					//BF test delete   else if ((Selected_Timebase > 2) && (SIGNALFaktor_idx == 0))
					else if ((Selected_Timebase > 0) && (SIGNALFaktor_idx == 0)) //BF new timebase 5nS + 2nS
 					{
						Selected_Timebase--;
						TimebaseChanged = 1;
						SIGNALFaktorChanged = 1;
					}
					
					if ((Selected_Timebase == 7) && (SIGNALFaktor_idx == 4))
					{
						if (Selected_Timebase_Old < 6)
						{
							Selected_Timebase = 9;
							SIGNALFaktor_idx = 2;
						}
					}
			
					if ((Selected_Timebase == 8) && (SIGNALFaktor_idx == 2))
					{
						if (Selected_Timebase_Old == 9)
						{
							Selected_Timebase = 6;
							SIGNALFaktor_idx = 4;
						}
					}
			
					rbuf--;
				}
				
			}
		}
	}
	else	//direction is counterclockwise -> increment timebase
	{
		if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }

        	// Delayed Mode
		if (MenuStatus[MENU_TIMEBASE][1] == 1)
		{

			while (rbuf > 0 && dmode_Selected_Timebase > 0)
			{
					dmode_Selected_Timebase--;
					TimebaseChanged = 1;
					SIGNALFaktorChanged = 1;
					rbuf--;
			}

		}  
		// Main Mode
		else
		{
			if (Continius == 0)
			{
				while (rbuf > 0)
				{
					if ((Selected_Timebase < 4) && (SIGNALFaktor_idx == 0))
					{
						Selected_Timebase++;
						TimebaseChanged = 1;
						SIGNALFaktorChanged = 1;
					}
					else if ((Selected_Timebase < 8) && (SIGNALFaktor_idx < 4))
					{	
						SIGNALFaktor_idx++;
						SIGNALFaktorChanged = 1;
					}
					else if ((Selected_Timebase > 7) && (SIGNALFaktor_idx < 2))
					{	
						SIGNALFaktor_idx++;
						SIGNALFaktorChanged = 1;
					}
			
					rbuf--;
				}
			}	
			else	//Continius == 1
			{
				//printf("Here we are %d %d %d\n", Selected_Timebase, SIGNALFaktor_idx, Selected_Timebase_Old);
						
				while (rbuf > 0)
				{
					if (Selected_Timebase < 4)
					{
						Selected_Timebase++;
						TimebaseChanged = 1;
						SIGNALFaktorChanged = 1;
					}
					else if ((Selected_Timebase < 7) && (SIGNALFaktor_idx < 4))
					{	
						SIGNALFaktor_idx++;
						SIGNALFaktorChanged = 1;
					}
					else if ((Selected_Timebase > 6) && (SIGNALFaktor_idx < 2))
					{	
						SIGNALFaktor_idx++;
						SIGNALFaktorChanged = 1;
					}
					else if ((Selected_Timebase < 7) && (SIGNALFaktor_idx == 4))
					{
						if (Selected_Timebase < 31)
						{
							Selected_Timebase++;
							TimebaseChanged = 1;
							SIGNALFaktorChanged = 1;
						}
					}
					else if ((Selected_Timebase > 6) && (SIGNALFaktor_idx == 2))
					{
						if (Selected_Timebase < 31)
						{
							Selected_Timebase++;
							TimebaseChanged = 1;
							SIGNALFaktorChanged = 1;
						}
					}
					
					if ((Selected_Timebase == 7) && (SIGNALFaktor_idx == 4))
					{
						if (Selected_Timebase_Old < 7)
						{
							Selected_Timebase = 9;
							SIGNALFaktor_idx = 2;
						}
					}
			
					if ((Selected_Timebase == 8) && (SIGNALFaktor_idx == 2))
					{
						if (Selected_Timebase_Old > 8)
						{
							Selected_Timebase = 6;
							SIGNALFaktor_idx = 4;
						}
					}
			
					rbuf--;
				}
				
			//printf("Here we are2 %d %d %d\n", Selected_Timebase, SIGNALFaktor_idx, Selected_Timebase_Old);		
			}
		}		
	}

	//activate new settings
	timebase_reg = tb_value[Selected_Timebase];
    	Timebase_Idx = Selected_Timebase + SIGNALFaktor_idx;

   	Hardware::RecalcTimeParameters();

	UI_request = 0;
	//config_changed = 1; -> is triggered in timer ISR of rotation timer


	//------------------------------------------------------------
	//BF add new FFT mode
	//------------------------------------------------------------
	Display::FFT_DrawStatus(0);		// redraw FFT status informations 
	

	//------------------------------------------------------------
	//BF add new ultra slow timebase mode
	//------------------------------------------------------------
	if (Selected_Timebase > 23) 	//new timebase > 500mS/Div? -> USTB
	{
		
		Signal::USTB_Clear_Buffer();	//clear all buffers
		
		Hardware::Reset_Timer2();

		if(USTB_Mode == USTB_OFF)	// if USTB was not active before -> activate USTB mode
		{
			//restore roll/shift mode setting in menu
			if (USTB_Mode_bak == USTB_ROLL)
			{
				MenuStatus[MENU_TIMEBASE][3] = 1;
				MenuStatus[MENU_TIMEBASE][4] = 0;
			}
			else if (USTB_Mode_bak == USTB_SHIFT)
			{
				MenuStatus[MENU_TIMEBASE][3] = 0;
				MenuStatus[MENU_TIMEBASE][4] = 1;
			}
			//set USTB-mode to previous setting
			USTB_Mode = USTB_Mode_bak;

			MenuStatus[MENU_TIMEBASE][5] = 246;	// set browse function inactive

			if (Active_Menu == MENU_TIMEBASE)	// main/delayed menu active?
			{
				Menu_Changed = 1;
				MenuItemChanged[3] = 1;
				MenuItemChanged[4] = 1;
				MenuItemChanged[5] = 1;
				New_Menu = Active_Menu;
			}
			else
			{
				New_Menu = MENU_TIMEBASE;
				Menu_Changed = 1;
			}

			//Backup triggersetting and force auto mode	
			TriggerMode_bak = MenuStatus[MENU_TRIGGERMODE][0];
			MenuStatus[MENU_TRIGGERMODE][0] = TRIG_AUTO;		//set trigger auto mode
			Display::MenuPopupInit(9, MENU_TRIGGERMODE, 92);
			if (Active_Menu == MENU_TRIGGERMODE)	
			{
				Menu_Changed = 1;
				MenuItemChanged[0] = 1;
				New_Menu = Active_Menu;
			}
			triggering_bak = triggering;	//BF #022
			triggering = 0;			//BF #022
			Display::DRAWSTATUS(8, 1);	//BF delete edge symbol

			//triggerway must be Edge!!
			TriggerWay_bak = TriggerWay;
			TriggerWay = TRIG_EDGE;
			TriggerWayChanged = 1;
			LED_ON[5]  = 0;
			LED_ON[8]  = 1;
			LED_ON[10] = 0;

			Hardware::Send_LED();

		}

	}
	else	//normal timebase
	{
		if (USTB_Mode != USTB_OFF)	//was USTB mode active?
		{
			Hardware::Stop_Timer2();

			//backup and deactivate roll/shift mode setting in menu
			USTB_Mode_bak = USTB_Mode;
			MenuStatus[MENU_TIMEBASE][3] = 246;
			MenuStatus[MENU_TIMEBASE][4] = 246;
			MenuStatus[MENU_TIMEBASE][5] = 240;	// set browse function active but switched off
			
			if (Active_Menu == MENU_TIMEBASE)	// main/delayed menu active?
			{
				Menu_Changed = 1;
				MenuItemChanged[3] = 1;
				MenuItemChanged[4] = 1;
				MenuItemChanged[5] = 1;
				New_Menu = Active_Menu;
			}
			
			USTB_Mode = USTB_OFF;				//switch off USTB mode
			
			//restore triggermode
			MenuStatus[MENU_TRIGGERMODE][0] = TriggerMode_bak;	
			Display::MenuPopupInit(9, MENU_TRIGGERMODE, 92);

			if (Active_Menu == MENU_TRIGGERMODE)	
			{
				Menu_Changed = 1;
				MenuItemChanged[0] = 1;
				New_Menu = Active_Menu;
			}
			triggering = triggering_bak;
		}
	} 
	TriggerLevelChanged = 1;
	TriggerModeChanged = 1;
	Hardware::UpdateTrigger();

	//No delayed mode for timebase 2ns and USTB-timebases
	if (Selected_Timebase == 0 || USTB_Mode != USTB_OFF)
	{ MenuStatus[MENU_TIMEBASE][1] = 246; }	
	else
	{
		if(MenuStatus[MENU_TIMEBASE][0] == 1 || MenuStatus[MENU_TIMEBASE][2] == 1)
		MenuStatus[MENU_TIMEBASE][1] = 0;
		else
		MenuStatus[MENU_TIMEBASE][1] = 1;
	}


	if (Active_Menu == MENU_TIMEBASE)	// main/delayed menu active?
	{
		MenuButtonCheck(-1);
		if (MenuPopupActive > -1)
	 	{ Display::DRAWMENUPOPDOWN(); }
		New_Menu = Active_Menu;
		Menu_Changed = 1;
		MenuItemChanged[1] = 1;
		//MenuItemChanged[2] = 1;
	}
	
	//------------------------------------------------
	//         memory window
	//------------------------------------------------
	if (USTB_Mode == USTB_OFF && FFT_Mode == FFT_OFF && !AS_request && !RC_request)	//USTB mode off?
	{
		if (Memory_Window_visible) 		// if Memory Window visible
			Display::DRAWMEMORY(0, 0, 1); 	// redraw Memory Window
		else
			Display::DRAWMEMORY(0, 1, 1); 	// if Memory Window not visible yet, make it visible.
	}
	else
	{
		if (Memory_Window_visible) 
		Display::DRAWMEMORY(1, 0, 0);		//close memory window
		config_changed = 1;
	}

 	//-------------------------------------------------
	//         Cursor
	//-------------------------------------------------
	if (Cursor_Enabled)
	{
		//BF redundant Display::CALCCURSORDATA();
	
		if (Active_Menu == 16)
		{
			MenuItemChanged[1] = 1;
			MenuItemChanged[2] = 1;
			New_Menu = Active_Menu;
		}
		Menu_Changed = 1;
		CursorChanged = 1;
	}
	
	MenuStatusChanged = 1;
	
	Display::CALCPRETRIGGER();
	
	if(FFT_Mode != FFT_OFF)
	Display::FFT_CalcCursorData();
	else
	Display::CALCCURSORDATA();

	Display::DRAW_ALL_CURSOR();

	Display::StatusUpdate();
	Display::DRAWSTATUS(0, 1);	//write new timebase to status bar
	Hardware::SetupADC();	

	//BF add new start/stop logic
	if (!SingleMode && Continius && !AS_request && !RC_request)
	{ Hardware::Start_Record(); } 

}
//######################################################################################################################################################
// call wheel handler routines depending on used wheel
void UserIF::Rotary_Interface(void)
{
	if (!Rotary_Changed) return;
	Rotary_Changed = 0;
	
	UI_request = 0;		//reset UI-request flag	
	
	if ((Active_Menu == 12) || (Active_Menu == 15)) Rotary_Direction_mem_pulse = Rotary_Direction;


//printf("Steps = %i Dir = %i \n", Rotary_Steps, Rotary_Direction);

	if ((Rotary_Switch & 0x00000001) == 0x00000001) { Hardware::ResetTimer(); ON_Rotary_Position(); RC_user_if = 1;}	//memory browser
	else if ((Rotary_Switch & 0x00000002) == 0x00000002) { Hardware::ResetTimer(); ON_Trigger_Level(); }			//trigger level
	else if ((Rotary_Switch & 0x00000004) == 0x00000004) { Hardware::ResetTimer(); ON_Main_Wheel(); RC_user_if = 1; }	//main wheel
	else if ((Rotary_Switch & 0x00000008) == 0x00000008) { Hardware::ResetTimer(); ON_Timebase(); RC_user_if = 1; }
	else if ((Rotary_Switch & 0x00000010) == 0x00000010 && Continius) { Hardware::ResetTimer(); ON_Zero_Channel_2(); }
	else if ((Rotary_Switch & 0x00000020) == 0x00000020 && Continius) { Hardware::ResetTimer(); ON_Voltage_Channel_2(); }
	else if ((Rotary_Switch & 0x00000040) == 0x00000040 && Continius) { Hardware::ResetTimer(); ON_Voltage_Channel_1(); }
	else if ((Rotary_Switch & 0x00000080) == 0x00000080 && Continius) { Hardware::ResetTimer(); ON_Zero_Channel_1(); }
	else if ((Rotary_Switch & 0x00000100) == 0x00000100 && Continius) { Hardware::ResetTimer(); ON_Zero_Channel_4(); }
	else if ((Rotary_Switch & 0x00000200) == 0x00000200 && Continius) { Hardware::ResetTimer(); ON_Voltage_Channel_4(); }
	else if ((Rotary_Switch & 0x00000400) == 0x00000400 && Continius) { Hardware::ResetTimer(); ON_Voltage_Channel_3(); }
	else if ((Rotary_Switch & 0x00000800) == 0x00000800 && Continius) { Hardware::ResetTimer(); ON_Zero_Channel_3(); }
	
	Rotary_Steps = 0;
	
}
//##########################################################################################################################################
// Set voltage range for channel 1
void UserIF::ON_Voltage_Channel_1(void)
{
	int cnt;
	float fvolt_factor = 0;
	float fvolt_factor2 = 0;
	
	int shift_cnt = 0;
	
	if (Channel_1_Active == false) return;

	//Adjust voltage range
	if (Rotary_Direction == 1)
	{
		//if (Selected_Voltage_CH1 == 3) return;	//BF del
		if (Selected_Voltage_CH1 == 0) return;		//BF test
	//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
			if ((Selected_Voltage_CH1 - Rotary_Steps) > 3)
			{
				Selected_Voltage_CH1 -= Rotary_Steps;
			}
			else Selected_Voltage_CH1 = 3;
			
			Hardware::SetSwitches(1, Selected_Voltage_CH1);
			VoltageChangedCh1 = 1;
	
		if (Cursor_Enabled)
		{
			if(FFT_Mode != FFT_OFF)
			Display::FFT_CalcCursorData();
			else
			Display::CALCCURSORDATA();

			Menu_Changed = 1;
			CursorChanged = 4;
		}
	
		if (QM_Enabled)
		{
			Display::CALCQMDATA();
			Menu_Changed = 1;
		}
				
		Display::DRAWSTATUS(1, 1);											// Draw Voltage Channel 1
		Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
		if ((Active_Menu == 16) || (MenuButtonCheck(-1)))
		{
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
					
			New_Menu = Active_Menu;
			Menu_Changed = 1;
		}
		if (Active_Menu == 19)
		{
			New_Menu = Active_Menu;
			Menu_Changed = 1;
		}	
	}
	else
	{
		if (Selected_Voltage_CH1 == 11) return;

//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		if ((Selected_Voltage_CH1 + Rotary_Steps) < 11)
		{
			Selected_Voltage_CH1 += Rotary_Steps;       			
		}
		else Selected_Voltage_CH1 = 11;	
	
		Hardware::SetSwitches(1, Selected_Voltage_CH1);
		VoltageChangedCh1 = 1;
				
		if (Cursor_Enabled)
		{
			if(FFT_Mode != FFT_OFF)
			Display::FFT_CalcCursorData();
			else
			Display::CALCCURSORDATA();

			Menu_Changed = 1;
			CursorChanged = 4;
		}
		
		if (QM_Enabled)
		{
			Display::CALCQMDATA();
			Menu_Changed = 1;
		}
				
		Display::DRAWSTATUS(1, 1);											// Draw Voltage Channel 1
		Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
			
		if ((Active_Menu == 16) || (MenuButtonCheck(-1)))
		{
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
			New_Menu = Active_Menu;
			Menu_Changed = 1;
		}
		if (Active_Menu == 19)
		{
			New_Menu = Active_Menu;
			Menu_Changed = 1;
		}
	}

	Rotary_Steps = 0;
	ON_Zero_Channel_1();
}
//##########################################################################################################################################
//set zerolevel for channel 1 (zero wheel handler)
void UserIF::ON_Zero_Channel_1(void)
{
	int rotbuf;
	
	if (Channel_1_Active == false) return;

	if (FFT_Mode != FFT_OFF)
	{
		Rotary_Steps = 0;
		return;
	}
/*	
	if ((Rotary_Steps > 5) && (Rotary_Steps < 11)) rotbuf = Rotary_Steps * 3;
	else if (Rotary_Steps > 10) rotbuf = Rotary_Steps * 7;
	else rotbuf = Rotary_Steps;
*/
	//rotbuf = ((Rotary_Steps * Rotary_Steps) >> 1) + 1; 	//BF new square function characteristic 1/2 * X²
	rotbuf = ((Rotary_Steps * Rotary_Steps) >> 2) + Rotary_Steps; 	//BF new square function characteristic 1/4 * X² + x
	
	
	if (rotbuf != 0)
	{
		
		if (Rotary_Direction == 0)	//clockwise rotary direction
		{
			if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
				
			if (XY_Mode)	//XY-mode
			{
				if ((Virtual_ZeroLevelXYCH1 - rotbuf) > -4095)  
				{ Virtual_ZeroLevelXYCH1 -= rotbuf; }		
				else
				{ Virtual_ZeroLevelXYCH1 = -4095; }       //Limiter
			}
			else	//Main mode TY
			{
				if ((Virtual_ZeroLevelCH1 + rotbuf) < 4095) // 0
				{ Virtual_ZeroLevelCH1 += rotbuf;	}	
				else
				{ Virtual_ZeroLevelCH1 = 4095; } //Limiter
			}
		
			if ((Virtual_ZeroLevelCH1 < 4095) && (Virtual_ZeroLevelCH1 > -4095))
			{
				if (Trigger_Pos_CH1_os < 0)
				{
					while ((rotbuf > 0) && (Trigger_Pos_CH1_os != 0))
					{ rotbuf--; Trigger_Pos_CH1_os++; }
				}
				

				if ((Trigger_Pos_CH1 + rotbuf) <= GRID_HEIGHT)
				{ Trigger_Pos_CH1 = Trigger_Pos_CH1 + rotbuf; }
				else
				{
					Trigger_Pos_CH1_os = Trigger_Pos_CH1_os + (rotbuf - (GRID_HEIGHT - Trigger_Pos_CH1));
					Trigger_Pos_CH1    = GRID_HEIGHT;	
				}
			}
			
			if (Selected_Trigger_Source == 1)
			{
				Hardware::UpdateTrigger();	
			}
		}
		else	//counter clockwise rotary direction
		{
			if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
				
			if (XY_Mode)	//XY-mode
			{
				if ((Virtual_ZeroLevelXYCH1 + rotbuf) < 4095)
				{ Virtual_ZeroLevelXYCH1 += rotbuf; }		
				else
				{ Virtual_ZeroLevelXYCH1 = 4095; }	// limiter
			}
			else
			{
				if ((Virtual_ZeroLevelCH1 - rotbuf) > -4095)
				{ Virtual_ZeroLevelCH1 -= rotbuf; }	
				else
				{ Virtual_ZeroLevelCH1 = -4095; }
			}
				
			if ((Virtual_ZeroLevelCH1 < 4095) && (Virtual_ZeroLevelCH1 > -4095))
			{
				if (Trigger_Pos_CH1_os > 0)
				{
					while ((rotbuf > 0) && (Trigger_Pos_CH1_os != 0))
					{ rotbuf--; Trigger_Pos_CH1_os--; }
				}
				if ((Trigger_Pos_CH1 - rotbuf) >= 0)
				{ Trigger_Pos_CH1 = Trigger_Pos_CH1 - rotbuf; }
				else
				{
					Trigger_Pos_CH1_os = Trigger_Pos_CH1_os - (rotbuf - Trigger_Pos_CH1);
					Trigger_Pos_CH1 = 0;
				}
			}
			
			if (Selected_Trigger_Source == 1)
			{
				Hardware::UpdateTrigger();	
			}
		}
		VS_ZeroLevelChanged = 1;	//flag for zero sign drawing
   		ZL_changed = 1;			//flag for signal drawing
	}
 
	if (XY_Mode)
	{
		ZeroLevelCH1 = Virtual_ZeroLevelXYCH1 + (GRID_XY / 2);
		if (ZeroLevelCH1 < 0) ZeroLevelCH1 = 0;
		if (ZeroLevelCH1 > GRID_XY) ZeroLevelCH1 = GRID_XY;
		
		switch(Selected_Voltage_CH1)
		{
			case 0: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[0][0]; break;//1 mV
			case 1: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[0][1]; break;//2 mV
			case 2: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[0][2]; break;//5 mV
			
			case 3: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[0][0]; break;//10 mV
			case 4: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[0][1]; break;//20 mV
			case 5: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[0][2]; break;//50 mV
			
			case 6: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[0][0]; break;//100 mV
			case 7: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[0][1]; break;//200 mV
			case 8: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[0][2]; break;//500 mV
			
			case 9: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[0][0]; break;// 1 V
			case 10: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[0][1]; break;//2 V
			case 11: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH1 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[0][2]; break;//5 V
		}
	}
	else
	{
		ZeroLevelCH1 = Virtual_ZeroLevelCH1 + (GRID_HEIGHT / 2);
		if (ZeroLevelCH1 < 0) ZeroLevelCH1 = 0;
		if (ZeroLevelCH1 > (GRID_HEIGHT + 1)) ZeroLevelCH1 = (GRID_HEIGHT + 1);
		
		switch(Selected_Voltage_CH1)
		{
			case 0: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[0][0]; break;//1 mV
			case 1: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[0][1]; break;//2 mV
			case 2: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[0][2]; break;//5 mV
		
			case 3: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[0][0]; break;//10 mV
			case 4: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[0][1]; break;//20 mV
			case 5: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[0][2]; break;//50 mV
		
			case 6: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[0][0]; break;//100 mV
			case 7: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[0][1]; break;//200 mV
			case 8: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[0][2]; break;//500 mV
		
			case 9:  CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[0][0]; break;// 1 V
			case 10: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[0][1]; break;// 2 V
			case 11: CH1_DAC_Offset = int ((float (Virtual_ZeroLevelCH1 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[0][2]; break;// 5 V
		}

	}

    	Hardware::SetDacOffset(1);
 
}

//##########################################################################################################################################
// Set voltage range for channel 2
void UserIF::ON_Voltage_Channel_2(void)
{
	int cnt;
	float fvolt_factor = 0;
	float fvolt_factor2 = 0;
	
	int shift_cnt = 0;
	
	if (Channel_2_Active == false) return;

	if (Rotary_Direction == 1)
	{
		if (Selected_Voltage_CH2 == 3) return;

	//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		if ((Selected_Voltage_CH2 - Rotary_Steps) > 3)
		{
			Selected_Voltage_CH2 -= Rotary_Steps;
		}
		else Selected_Voltage_CH2 = 3;
		
		Hardware::SetSwitches(2, Selected_Voltage_CH2);
		VoltageChangedCh2 = 1;
	
		if (Cursor_Enabled)
		{
			if(FFT_Mode != FFT_OFF)
			Display::FFT_CalcCursorData();
			else
			Display::CALCCURSORDATA();

			Menu_Changed = 1;
			CursorChanged = 4;
		}
	
		if (QM_Enabled)
		{
			Display::CALCQMDATA();
			Menu_Changed = 1;
		}
				
		Display::DRAWSTATUS(2, 1);											// Draw Voltage Channel 1
		Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
		if ((Active_Menu == 16) || (MenuButtonCheck(-1)))
		{
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
					
			New_Menu = Active_Menu;
			Menu_Changed = 1;
		}
		if (Active_Menu == 19)
		{
			New_Menu = Active_Menu;
			Menu_Changed = 1;
		}	
	}
	else
	{
		if (Selected_Voltage_CH2 == 11) return;

	//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		if ((Selected_Voltage_CH2 + Rotary_Steps) < 11)
		{
			Selected_Voltage_CH2 += Rotary_Steps;       			
		}
		else Selected_Voltage_CH2 = 11;	
	
		Hardware::SetSwitches(2, Selected_Voltage_CH2);
		VoltageChangedCh2 = 1;
			
		if (Cursor_Enabled)
		{
			if(FFT_Mode != FFT_OFF)
			Display::FFT_CalcCursorData();
			else
			Display::CALCCURSORDATA();

			Menu_Changed = 1;
			CursorChanged = 4;
		}
		if (QM_Enabled)
		{
			Display::CALCQMDATA();
			Menu_Changed = 1;
		}
			
		Display::DRAWSTATUS(2, 1);											// Draw Voltage Channel 1
		Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
			
		if ((Active_Menu == 16) || (MenuButtonCheck(-1)))
		{
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
			New_Menu = Active_Menu;
			Menu_Changed = 1;
		}
		if (Active_Menu == 19)
		{
			New_Menu = Active_Menu;
			Menu_Changed = 1;
		}
	}
	
	Rotary_Steps = 0;
	ON_Zero_Channel_2();
}
//##########################################################################################################################################
//set zerolevel for channel 2 (zero wheel handler)
void UserIF::ON_Zero_Channel_2(void)
{
	int rotbuf;
	
	if (Channel_2_Active == false) return;

	if (FFT_Mode != FFT_OFF)
	{
		Rotary_Steps = 0;
		return;
	}
/*	
	if ((Rotary_Steps > 5) && (Rotary_Steps < 11)) rotbuf = Rotary_Steps * 3;
	else if (Rotary_Steps > 10) rotbuf = Rotary_Steps * 7;
	else rotbuf = Rotary_Steps;
*/
	//rotbuf = ((Rotary_Steps * Rotary_Steps) >> 1) + 1; 	//BF new square function characteristic
	rotbuf = ((Rotary_Steps * Rotary_Steps) >> 2) + Rotary_Steps; 	//BF new square function characteristic 1/4 * X² + x

	if (rotbuf != 0)
	{
		if (Rotary_Direction == 0) //clockwise rotary direction
		{
			if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
			
			if (XY_Mode)	//XY-mode
			{
				if ((Virtual_ZeroLevelXYCH2 + rotbuf) < 4095) 
				{ Virtual_ZeroLevelXYCH2 += rotbuf; }		
				else
				{ Virtual_ZeroLevelXYCH2 = 4095; } //Limiter
			}
			else	//Main mode TY
			{
				if ((Virtual_ZeroLevelCH2 + rotbuf) < 4095) // 0
				{ Virtual_ZeroLevelCH2 += rotbuf;	}	
				else
				{ Virtual_ZeroLevelCH2 = 4095; } //Limiter
			}

			if ((Virtual_ZeroLevelCH2 < 4095) && (Virtual_ZeroLevelCH2 > -4095))
			{
				if (Trigger_Pos_CH2_os < 0)
				{
				while ((rotbuf > 0) && (Trigger_Pos_CH2_os != 0))
				{
					rotbuf--;
					Trigger_Pos_CH2_os++;
				}
				}
				if ((Trigger_Pos_CH2 + rotbuf) <= GRID_HEIGHT)
				{ Trigger_Pos_CH2 = Trigger_Pos_CH2 + rotbuf; }	
				else
				{
					Trigger_Pos_CH2_os = Trigger_Pos_CH2_os + (rotbuf - (GRID_HEIGHT - Trigger_Pos_CH2));
					Trigger_Pos_CH2 = GRID_HEIGHT;	
				}
			}
			
		
			if (Selected_Trigger_Source == 2)
			{
				Hardware::UpdateTrigger();	
			}
		}
		else 	//counter clockwise rotary direction
		{
			if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
		
			if (XY_Mode)	//XY-mode
			{
				if ((Virtual_ZeroLevelXYCH2 - rotbuf) > -4095)
				{ Virtual_ZeroLevelXYCH2 -= rotbuf; }		
				else
				{ Virtual_ZeroLevelXYCH2 = -4095; }
			}
			else
			{
				if ((Virtual_ZeroLevelCH2 - rotbuf) > -4095)
				{ Virtual_ZeroLevelCH2 -= rotbuf; }	
				else
				{ Virtual_ZeroLevelCH2 = -4095; }
			}
		
			if ((Virtual_ZeroLevelCH2 < 4095) && (Virtual_ZeroLevelCH2 > -4095))
			{
				if (Trigger_Pos_CH2_os > 0)
				{
					while ((rotbuf > 0) && (Trigger_Pos_CH2_os != 0))
					{
						rotbuf--;
						Trigger_Pos_CH2_os--;
					}
				}
				if ((Trigger_Pos_CH2 - rotbuf) >= 0) Trigger_Pos_CH2 = Trigger_Pos_CH2 - rotbuf;
				else
				{
					Trigger_Pos_CH2_os = Trigger_Pos_CH2_os - (rotbuf - Trigger_Pos_CH2);
					Trigger_Pos_CH2 = 0;
				}
			}
		
			if (Selected_Trigger_Source == 2)
			{
				Hardware::UpdateTrigger();
			}	
		}
		VS_ZeroLevelChanged = 2;	//flag for zero sign drawing
   		ZL_changed = 2;			//flag for signal drawing
	}

	if (XY_Mode)
	{
   		ZeroLevelCH2 = Virtual_ZeroLevelXYCH2 + (GRID_XY / 2);
		if (ZeroLevelCH2 < 0) ZeroLevelCH2 = 0;
		if (ZeroLevelCH2 > GRID_XY) ZeroLevelCH2 = GRID_XY;
   	
		switch(Selected_Voltage_CH2)
		{
			case 0: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH2 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[1][0]; break;//1 mV
			case 1: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH2 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[1][1]; break;//2 mV
			case 2: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH2 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[1][2]; break;//5 mV
			
			case 3: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH2 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[1][0]; break;//10mV
			case 4: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH2 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[1][1]; break;//20mV
			case 5: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH2 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[1][2]; break;//50mV
			
			case 6: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH2 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[1][0]; break;//100 mV
			case 7: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH2 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[1][1]; break;//200 mV
			case 8: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH2 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[1][2]; break;//500 mV
			
			case 9:  CH2_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH2 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[1][0]; break;//1 V
			case 10: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH2 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[1][1]; break;//2 V
			case 11: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH2 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[1][2]; break;//5 V
		}
	}
	else
	{
		ZeroLevelCH2 = Virtual_ZeroLevelCH2 + (GRID_HEIGHT / 2);
		if (ZeroLevelCH2 < 0) ZeroLevelCH2 = 0;
		if (ZeroLevelCH2 > (GRID_HEIGHT + 1)) ZeroLevelCH2 = (GRID_HEIGHT + 1);

		switch(Selected_Voltage_CH2)
		{
			case 0: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[1][0]; break;//1 mV
			case 1: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[1][1]; break;//2 mV
			case 2: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[1][2]; break;//5 mV
		
			case 3: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[1][0]; break;//10 mV
			case 4: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[1][1]; break;//20 mV
			case 5: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[1][2]; break;//50 mV
		
			case 6: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[1][0]; break;//100 mV
			case 7: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[1][1]; break;//200 mV
			case 8: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[1][2]; break;//500 mV
		
			case 9:  CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[1][0]; break;//1 V
			case 10: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[1][1]; break;//2 V
			case 11: CH2_DAC_Offset = int ((float (Virtual_ZeroLevelCH2 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[1][2]; break;//5 V
		}
	}

    	Hardware::SetDacOffset(2);	

}
//##########################################################################################################################################
void UserIF::ON_Voltage_Channel_3(void)
{
    int cnt;
    float fvolt_factor = 0;
    float fvolt_factor2 = 0;

    int shift_cnt = 0;

    if (Channel_3_Active == false) return;

    if (Rotary_Direction == 1)
    {
        if (Selected_Voltage_CH3 == 3) return;
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		if ((Selected_Voltage_CH3 - Rotary_Steps) > 3)
		{
			Selected_Voltage_CH3 -= Rotary_Steps;
		}
		else Selected_Voltage_CH3 = 3;
		
		Hardware::SetSwitches(3, Selected_Voltage_CH3);
		VoltageChangedCh3 = 1;

        if (Cursor_Enabled)
        {
		if(FFT_Mode != FFT_OFF)
		Display::FFT_CalcCursorData();
		else
		Display::CALCCURSORDATA();

		Menu_Changed = 1;
		CursorChanged = 4;
        }

        if (QM_Enabled)
        {
            Display::CALCQMDATA();
            Menu_Changed = 1;
        }
			
        Display::DRAWSTATUS(3, 1);											// Draw Voltage Channel 1
        Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
        if ((Active_Menu == 16) || (MenuButtonCheck(-1)))
        {
            MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
				
            New_Menu = Active_Menu;
            Menu_Changed = 1;
        }
        if (Active_Menu == 19)
        {
            New_Menu = Active_Menu;
            Menu_Changed = 1;
        }	

    }
    else
    {
        if (Selected_Voltage_CH3 == 11) return;
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		if ((Selected_Voltage_CH3 + Rotary_Steps) < 11)
		{
			Selected_Voltage_CH3 += Rotary_Steps;       			
		}
        else Selected_Voltage_CH3 = 11;	

		Hardware::SetSwitches(3, Selected_Voltage_CH3);
		VoltageChangedCh3 = 1;
			
	if (Cursor_Enabled)
        {
		if(FFT_Mode != FFT_OFF)
		Display::FFT_CalcCursorData();
		else
		Display::CALCCURSORDATA();

		Menu_Changed = 1;
		CursorChanged = 4;
        }
		if (QM_Enabled)
        {
            Display::CALCQMDATA();
            Menu_Changed = 1;
        }
			
		Display::DRAWSTATUS(3, 1);											// Draw Voltage Channel 1
		Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
			
		if ((Active_Menu == 16) || (MenuButtonCheck(-1)))
		{
            MenuItemChanged[3] = 1;
            MenuItemChanged[4] = 1;
            New_Menu = Active_Menu;
            Menu_Changed = 1;
		}
		if (Active_Menu == 19)
		{
            New_Menu = Active_Menu;
            Menu_Changed = 1;
		}
 
    }

    Rotary_Steps = 0;
    ON_Zero_Channel_3();
}
//##########################################################################################################################################
//set zerolevel for channel 3 (zero wheel handler)
void UserIF::ON_Zero_Channel_3(void)
{
	int rotbuf;

	if (Channel_3_Active == false) return;

	if (FFT_Mode != FFT_OFF)
	{
		Rotary_Steps = 0;
		return;
	}

/*	
	if ((Rotary_Steps > 5) && (Rotary_Steps < 11)) rotbuf = Rotary_Steps * 3;
	else if (Rotary_Steps > 10) rotbuf = Rotary_Steps * 7;
	else rotbuf = Rotary_Steps;
*/	
	//rotbuf = ((Rotary_Steps * Rotary_Steps) >> 1) + 1; 	//BF new square function characteristic
	rotbuf = ((Rotary_Steps * Rotary_Steps) >> 2) + Rotary_Steps; 	//BF new square function characteristic 1/4 * X² + x

	if (rotbuf != 0)
	{
		if (Rotary_Direction == 0)	//clockwise rotary direction
		{
			if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }

			if (XY_Mode)	//XY-mode
			{
				if ((Virtual_ZeroLevelXYCH3 - rotbuf) > -4095)
				{ Virtual_ZeroLevelXYCH3 -= rotbuf; }		
				else
				{ Virtual_ZeroLevelXYCH3 = -4095; }  
			}
			else	//Main mode TY
			{
				if ((Virtual_ZeroLevelCH3 + rotbuf) < 4095) // 0
				{ Virtual_ZeroLevelCH3 = Virtual_ZeroLevelCH3 + rotbuf;	}	
				else
				{ Virtual_ZeroLevelCH3 = 4095; } //Limiter
			}

			if ((Virtual_ZeroLevelCH3 < 4095) && (Virtual_ZeroLevelCH3 > -4095))
			{
				if (Trigger_Pos_CH3_os < 0)
				{
					while ((rotbuf > 0) && (Trigger_Pos_CH3_os != 0))
					{
						rotbuf--;
						Trigger_Pos_CH3_os++;
					}
				}
				if ((Trigger_Pos_CH3 + rotbuf) <= GRID_HEIGHT)
				 Trigger_Pos_CH3 = Trigger_Pos_CH3 + rotbuf;	// BF old 386
				else
				{
					Trigger_Pos_CH3_os = Trigger_Pos_CH3_os + (rotbuf - (GRID_HEIGHT - Trigger_Pos_CH3));	// BF old 386
					Trigger_Pos_CH3 = GRID_HEIGHT;								// BF old 386
				}
			}
		
			if (Selected_Trigger_Source == 3)
			{ Hardware::UpdateTrigger(); }
		}
		else	//counter clockwise rotary direction
		{
			if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
			
			if (XY_Mode)	//XY-mode
			{
				if ((Virtual_ZeroLevelXYCH3 + rotbuf) < 4095)
				{ Virtual_ZeroLevelXYCH3 += rotbuf; }		
				else
				{ Virtual_ZeroLevelXYCH3 = 4095; }
			}
			else
			{
				if ((Virtual_ZeroLevelCH3 - rotbuf) > -4095)
				{ Virtual_ZeroLevelCH3 -= rotbuf;	}	
				else
				{ Virtual_ZeroLevelCH3 = -4095;  }
			}

			if ((Virtual_ZeroLevelCH3 < 4095) && (Virtual_ZeroLevelCH3 > -4095))
			{
				if (Trigger_Pos_CH3_os > 0)
				{
					while ((rotbuf > 0) && (Trigger_Pos_CH3_os != 0))
					{
						rotbuf--;
						Trigger_Pos_CH3_os--;
					}
				}
				if ((Trigger_Pos_CH3 - rotbuf) >= 0) Trigger_Pos_CH3 = Trigger_Pos_CH3 - rotbuf;
				else
				{
					Trigger_Pos_CH3_os = Trigger_Pos_CH3_os - (rotbuf - Trigger_Pos_CH3);
					Trigger_Pos_CH3 = 0;
				}
			}
		
			if (Selected_Trigger_Source == 3)
			{
				Hardware::UpdateTrigger();
			}	
		}
		VS_ZeroLevelChanged = 3;	//flag for zero sign drawing
   		ZL_changed = 3;			//flag for signal drawing
	}

	if (XY_Mode)
	{
		ZeroLevelCH3 = Virtual_ZeroLevelXYCH3 + (GRID_XY / 2);
		if (ZeroLevelCH3 < 0) ZeroLevelCH3 = 0;
		if (ZeroLevelCH3 > GRID_XY) ZeroLevelCH3 = GRID_XY;
		
		switch(Selected_Voltage_CH3)
		{
		    case 0: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH3 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[2][0]; break;//  1 mV
		    case 1: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH3 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[2][1]; break;//  2 mV
		    case 2: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH3 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[2][2]; break;//  5 mV

		    case 3: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH3 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[2][0]; break;// 10 mV
		    case 4: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH3 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[2][1]; break;// 20 mV
		    case 5: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH3 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[2][2]; break;// 50 mV

		    case 6: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH3 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[2][0]; break;// 100 mV
		    case 7: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH3 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[2][1]; break;// 200 mV
		    case 8: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH3 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[2][2]; break;// 500 mV

		    case 9:  CH3_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH3 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[2][0]; break;// 1 V
		    case 10: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH3 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[2][1]; break;// 2 V
		    case 11: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH3 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[2][2]; break;// 5 V
		}
	}
	else
	{
		ZeroLevelCH3 = Virtual_ZeroLevelCH3 + (GRID_HEIGHT / 2);
		if (ZeroLevelCH3 < 0) ZeroLevelCH3 = 0;
		if (ZeroLevelCH3 > (GRID_HEIGHT + 1)) ZeroLevelCH3 = (GRID_HEIGHT + 1);

	        switch(Selected_Voltage_CH3)
	        {
	            case 0: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[2][0]; break;//  1 mV
	            case 1: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[2][1]; break;//  2 mV
	            case 2: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[2][2]; break;//  5 mV
	
	            case 3: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[2][0]; break;//  10 mV
	            case 4: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[2][1]; break;//  20 mV
	            case 5: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[2][2]; break;//  50 mV
	
	            case 6: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[2][0]; break;// 100 mV
	            case 7: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[2][1]; break;// 200 mV
	            case 8: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[2][2]; break;// 500 mV
	
	            case 9:  CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[2][0]; break;// 1 V
	            case 10: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[2][1]; break;// 2 V
	            case 11: CH3_DAC_Offset = int ((float (Virtual_ZeroLevelCH3 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[2][2]; break;// 5 V
	        }
	}

    	Hardware::SetDacOffset(3);

}
//##########################################################################################################################################
void UserIF::ON_Voltage_Channel_4(void)
{
    int cnt;
    float fvolt_factor = 0;
    float fvolt_factor2 = 0;

    int shift_cnt = 0;

    if (Channel_4_Active == false) return;

    if (Rotary_Direction == 1)
    {
        if (Selected_Voltage_CH4 == 3) return;
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		if ((Selected_Voltage_CH4 - Rotary_Steps) > 3)
		{
			Selected_Voltage_CH4 -= Rotary_Steps;
		}
		else Selected_Voltage_CH4 = 3;
		
		Hardware::SetSwitches(4, Selected_Voltage_CH4);
		VoltageChangedCh4 = 1;

        if (Cursor_Enabled)
        {
		if(FFT_Mode != FFT_OFF)
		Display::FFT_CalcCursorData();
		else
		Display::CALCCURSORDATA();

		Menu_Changed = 1;
		CursorChanged = 4;
        }

        if (QM_Enabled)
        {
            Display::CALCQMDATA();
            Menu_Changed = 1;
        }
			
        Display::DRAWSTATUS(4, 1);											// Draw Voltage Channel 1
        Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
        if ((Active_Menu == 16) || (MenuButtonCheck(-1)))
        {
            MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
				
            New_Menu = Active_Menu;
            Menu_Changed = 1;
        }
        if (Active_Menu == 19)
        {
            New_Menu = Active_Menu;
            Menu_Changed = 1;
        }	
    }
    else
    {
        if (Selected_Voltage_CH4 == 11) return;
//		if (ZeroPopupChanged) { Display::DRAWZEROPOPDOWN(); }
		if ((Selected_Voltage_CH4 + Rotary_Steps) < 11)
		{
			Selected_Voltage_CH4 += Rotary_Steps;       			
		}
        else Selected_Voltage_CH4 = 11;	

		Hardware::SetSwitches(4, Selected_Voltage_CH4);
		VoltageChangedCh4 = 1;
			
	if (Cursor_Enabled)
        {
		if(FFT_Mode != FFT_OFF)
		Display::FFT_CalcCursorData();
		else
		Display::CALCCURSORDATA();

		Menu_Changed = 1;
		CursorChanged = 4;
        }
		if (QM_Enabled)
        {
            Display::CALCQMDATA();
            Menu_Changed = 1;
        }
			
		Display::DRAWSTATUS(4, 1);											// Draw Voltage Channel 1
		Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
			
		if ((Active_Menu == 16) || (MenuButtonCheck(-1)))
		{
            MenuItemChanged[3] = 1;
            MenuItemChanged[4] = 1;
            New_Menu = Active_Menu;
            Menu_Changed = 1;
		}
		if (Active_Menu == 19)
		{
            New_Menu = Active_Menu;
            Menu_Changed = 1;
		}
     }

    Rotary_Steps = 0;
    ON_Zero_Channel_4();
}
//##########################################################################################################################################
//set zerolevel for channel 4 (zero wheel handler)
void UserIF::ON_Zero_Channel_4(void)
{
	int rotbuf;

	if (Channel_4_Active == false) return;

	if (FFT_Mode != FFT_OFF)
	{
		Rotary_Steps = 0;
		return;
	}

/*	
	if ((Rotary_Steps > 5) && (Rotary_Steps < 11)) rotbuf = Rotary_Steps * 3;
	else if (Rotary_Steps > 10) rotbuf = Rotary_Steps * 7;
	else rotbuf = Rotary_Steps;
*/	
	//rotbuf = ((Rotary_Steps * Rotary_Steps) >> 1) + 1; 	//BF new square function characteristic
	rotbuf = ((Rotary_Steps * Rotary_Steps) >> 2) + Rotary_Steps; 	//BF new square function characteristic 1/4 * X² + x


	if (rotbuf !=  0)
	{
		if (Rotary_Direction == 0)	//clockwise rotary direction
		{
			if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }

			if (XY_Mode)	//XY-mode
			{
				if ((Virtual_ZeroLevelXYCH4 + rotbuf) < 4095)
				{ Virtual_ZeroLevelXYCH4 += rotbuf; }		
				else
				{ Virtual_ZeroLevelXYCH4 = 4095; }      //Limiter
			}
			else	//Main mode TY
			{
				if ((Virtual_ZeroLevelCH4 + rotbuf) < 4095) // 0
				{ Virtual_ZeroLevelCH4 = Virtual_ZeroLevelCH4 + rotbuf;	}	
				else
				{ Virtual_ZeroLevelCH4 = 4095; } //Limiter
			}
		
			if ((Virtual_ZeroLevelCH4 < 4095) && (Virtual_ZeroLevelCH4 > -4095))
			{
				if (Trigger_Pos_CH4_os < 0)
				{
					while ((rotbuf > 0) && (Trigger_Pos_CH4_os != 0))
					{
						rotbuf--;
						Trigger_Pos_CH4_os++;
					}
				}
				if ((Trigger_Pos_CH4 + rotbuf) <= GRID_HEIGHT) Trigger_Pos_CH4 = Trigger_Pos_CH4 + rotbuf;	// BF old 386
				else
				{
					Trigger_Pos_CH4_os = Trigger_Pos_CH4_os + (rotbuf - (GRID_HEIGHT - Trigger_Pos_CH4));	// BF old 386
					Trigger_Pos_CH4 = GRID_HEIGHT;								// BF old 386
				}
			}
		
			if (Selected_Trigger_Source == 4)
			{ Hardware::UpdateTrigger(); }
		}
		else	//counter clockwise rotary direction
		{
			if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }

			if (XY_Mode)	//XY-mode
			{
				if ((Virtual_ZeroLevelXYCH4 - rotbuf) > -4095)
				{ Virtual_ZeroLevelXYCH4 -= rotbuf; }		
				else
				{ Virtual_ZeroLevelXYCH4 = -4095; }
			}
			else
			{
				if ((Virtual_ZeroLevelCH4 - rotbuf) > -4095)
				{ Virtual_ZeroLevelCH4 -= rotbuf;	}	
				else
				{ Virtual_ZeroLevelCH4 = -4095; }
			}
		
			if ((Virtual_ZeroLevelCH4 < 4095) && (Virtual_ZeroLevelCH4 > -4095))
			{
				if (Trigger_Pos_CH4_os > 0)
				{
					while ((rotbuf > 0) && (Trigger_Pos_CH4_os != 0))
					{
						rotbuf--;
						Trigger_Pos_CH4_os--;
					}
				}
				if ((Trigger_Pos_CH4 - rotbuf) >= 0) Trigger_Pos_CH4 = Trigger_Pos_CH4 - rotbuf;
				else
				{
					Trigger_Pos_CH4_os = Trigger_Pos_CH4_os - (rotbuf - Trigger_Pos_CH4);
					Trigger_Pos_CH4 = 0;
				}
			}
		
			if (Selected_Trigger_Source == 4)
			{
				Hardware::UpdateTrigger();
			}	
		}
		VS_ZeroLevelChanged = 4;	//flag for zero sign drawing
   		ZL_changed = 4;			//flag for signal drawing
	}


	if (XY_Mode)
	{
		ZeroLevelCH4 = Virtual_ZeroLevelXYCH4 + (GRID_XY / 2);
		if (ZeroLevelCH4 < 0) ZeroLevelCH4 = 0;
		if (ZeroLevelCH4 > GRID_XY) ZeroLevelCH4 = GRID_XY;

		switch(Selected_Voltage_CH4)
		{
			case 0: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH4 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[3][0]; break;//  1 mV
			case 1: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH4 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[3][1]; break;//  2 mV
			case 2: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH4 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[3][2]; break;//  5 mV

			case 3: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH4 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[3][0]; break;// 10 mV
			case 4: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH4 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[3][1]; break;// 20 mV
			case 5: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH4 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[3][2]; break;// 50 mV

			case 6: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH4 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[3][0]; break;//100 mV
			case 7: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH4 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[3][1]; break;//200 mV
			case 8: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH4 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[3][2]; break;//500 mV

			case 9:  CH4_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH4 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[3][0]; break;// 1 V
			case 10: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH4 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[3][1]; break;// 2 V
			case 11: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelXYCH4 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[3][2]; break;// 5 V
		}
	}
	else
	{
		ZeroLevelCH4 = Virtual_ZeroLevelCH4 + (GRID_HEIGHT / 2);
		if (ZeroLevelCH4 < 0) ZeroLevelCH4 = 0;
		if (ZeroLevelCH4 > (GRID_HEIGHT + 1)) ZeroLevelCH4 = (GRID_HEIGHT + 1);

		switch(Selected_Voltage_CH4)
		{
			case 0: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[3][0]; break;//   1 mV
			case 1: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[3][1]; break;//   2 mV
			case 2: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[3][2]; break;//   5 mV
			
			case 3: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[3][0]; break;//  10 mV
			case 4: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[3][1]; break;//  20 mV
			case 5: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[3][2]; break;//  50 mV
			
			case 6: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[3][0]; break;// 100 mV
			case 7: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[3][1]; break;// 200 mV
			case 8: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[3][2]; break;// 500 mV
			
			case 9:  CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 1) / DAC_ScaleFactor[0][GainIdx])) + 8192 + DAC_Correction[3][0]; break;// 1 V
			case 10: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 2) / DAC_ScaleFactor[1][GainIdx])) + 8192 + DAC_Correction[3][1]; break;// 2 V
			case 11: CH4_DAC_Offset = int ((float (Virtual_ZeroLevelCH4 * 3) / DAC_ScaleFactor[2][GainIdx])) + 8192 + DAC_Correction[3][2]; break;// 5 V
		}
	}

    	Hardware::SetDacOffset(4);
	
}
//##########################################################################################################################################

void UserIF::HandleMainWheel(char Direction)						// Main Wheel Handler
{
	bool doit = false;
	bool changing = false;
	double voltoff = 0;
	double timeoff = 0;
	short pos = 0;
	
	int rot_buf = 0;
	int buf_int = 0; 	
	float buf_float = 0;
	
	int rbuf = Rotary_Steps;
    		
//	Display::DRAWP(550, 50, 80, 20, 0, 6);
//	sprintf(speedt, "%i\n" , Speed);
//	Display::TEXTOUTxvbig(speedt, 550, 50, 1, 6);				// Draw the Ground Sign
	
	Rot_Time = 0;
	
//	if (RoteryChanged == 0) return;
	
	switch(Active_Menu)
	{      /*
		// Averaging
		case 0:
		{
			if (MenuItemPushed[3] == 0) doit = true;
			MenuButtonCheck(3);

            changing = false;
            while (rbuf > 0)
            {
                switch(Direction)
                {
                    case 0: if (MenuStatus[MENU_ACQUIRE][2] > 74) {MenuStatus[MENU_ACQUIRE][2]--; changing = true;} break;
                    case 1: if (MenuStatus[MENU_ACQUIRE][2] < 81) {MenuStatus[MENU_ACQUIRE][2]++; changing = true;} break;
                }
                rbuf--;
			}
			
			if (changing)
			{
                Display::DRAWP(248, 454, 60, 14, 0, Buffer_UI2Plane);
                Display::TEXTOUTxvbig(MenuData[MenuStatus[MENU_ACQUIRE][2]], 219 + MenuDataDef[MenuStatus[MENU_ACQUIRE][2]], 455, 1, Buffer_UI2Plane);
                Display::DRAWSTATUS(Active_Menu, 1);			
            }
			
			switch(MenuStatus[MENU_ACQUIRE][2])
			{
                case 74 : Average_Max = 1; break;
                case 75 : Average_Max = 2; break;
                case 76 : Average_Max = 4; break;
                case 77 : Average_Max = 8; break;
                case 78 : Average_Max = 16; break;
                case 79 : Average_Max = 32; break;
                case 80 : Average_Max = 64; break;
                case 81 : Average_Max = 128; break;
                case 82 : Average_Max = 256; break;
                case 83 : Average_Max = 512; break;
                case 84 : Average_Max = 1024; break;
                case 85 : Average_Max = 2048; break;
                case 86 : Average_Max = 4096; break;
                case 87 : Average_Max = 8192; break;
                case 88 : Average_Max = 16384; break;
            }
            Average_Cnt = 0;
						
			Menu_Changed = 1;

			break;
		}
        */	
		// Channel 1
		case 1:
		{
            		if (Channel_1_Active == 0) return;

			if (MenuItemPushed[3] == 0) doit = true;
			MenuButtonCheck(3);

		changing = false;
		while (rbuf > 0)
		{
			switch(Direction)
			{
				    case 0: if (MenuStatus[MENU_CHANNEL1][3] > 104) {MenuStatus[MENU_CHANNEL1][3]--; changing = true;} break;
				    case 1: if (MenuStatus[MENU_CHANNEL1][3] < 113) {MenuStatus[MENU_CHANNEL1][3]++; changing = true;} break;
			}
			rbuf--;
		}
			
		if (changing)
		{
			Display::DRAWP(345, 454, 60, 14, 0, Buffer_UI2Plane);
			Display::TEXTOUTxvbig(MenuData[MenuStatus[MENU_CHANNEL1][3]], 354, 455, 1, Buffer_UI2Plane);
			Display::DRAWSTATUS(Active_Menu, 1);		
			Display::DRAWSTATUS(6, 0);				
		}                		
			
			if (Cursor_Enabled)
			{
               			CursorChanged = 4;
				if(FFT_Mode != FFT_OFF)
				Display::FFT_CalcCursorData();
				else
				Display::CALCCURSORDATA();
			}
			if (QM_Enabled)
			{					
				Display::CALCQMDATA();
			}
			
			//Display::CALCTRIGGER();
			TriggerLevelChanged = 1;
			Display::StatusUpdate();
			
			Menu_Changed = 1;

			break;
		}
		
		// Channel 2
		case 2:
		{
            	if (Channel_2_Active == 0) return;

			if (MenuItemPushed[3] == 0) doit = true;
			MenuButtonCheck(3);
			
            	changing = false;
		while (rbuf > 0)
		{
			switch(Direction)
			{
					case 0: if (MenuStatus[MENU_CHANNEL2][3] > 104) {MenuStatus[MENU_CHANNEL2][3]--; changing = true;} break;
					case 1: if (MenuStatus[MENU_CHANNEL2][3] < 113) {MenuStatus[MENU_CHANNEL2][3]++; changing = true;} break;
			}
                	rbuf--;
		}
			
			if (changing)
			{
				Display::DRAWP(345, 454, 60, 14, 0, Buffer_UI2Plane);
				Display::TEXTOUTxvbig(MenuData[MenuStatus[MENU_CHANNEL2][3]], 354, 455, 1, Buffer_UI2Plane);
				Display::DRAWSTATUS(Active_Menu, 1);		
				Display::DRAWSTATUS(6, 0);				
            		}

			if (Cursor_Enabled)
			{
                		CursorChanged = 4;
				if(FFT_Mode != FFT_OFF)
				Display::FFT_CalcCursorData();
				else
				Display::CALCCURSORDATA();
			}
			if (QM_Enabled)
			{					
				Display::CALCQMDATA();
			}		
			
			//Display::CALCTRIGGER();
			TriggerLevelChanged = 1;
			Display::StatusUpdate();			

            		Menu_Changed = 1;	

			break;
		}
		
		// Channel 3
		case 3:
		{
            		if (Channel_3_Active == 0) return;

			if (MenuItemPushed[3] == 0) doit = true;
			MenuButtonCheck(3);
			
            changing = false;
            while (rbuf > 0)
            {
                switch(Direction)
                {
				    case 0: if (MenuStatus[MENU_CHANNEL3][3] > 104) {MenuStatus[MENU_CHANNEL3][3]--; changing = true;} break;
				    case 1: if (MenuStatus[MENU_CHANNEL3][3] < 113) {MenuStatus[MENU_CHANNEL3][3]++; changing = true;} break;
                }
                rbuf--;
			}
			
			if (changing)
			{
                Display::DRAWP(345, 454, 60, 14, 0, Buffer_UI2Plane);
                Display::TEXTOUTxvbig(MenuData[MenuStatus[MENU_CHANNEL3][3]], 354, 455, 1, Buffer_UI2Plane);
                Display::DRAWSTATUS(Active_Menu, 1);		
                Display::DRAWSTATUS(6, 0);				
            }
			
			if (Cursor_Enabled)
			{
                		CursorChanged = 4;
				if(FFT_Mode != FFT_OFF)
				Display::FFT_CalcCursorData();
				else
				Display::CALCCURSORDATA();

			}
			if (QM_Enabled)
			{					
				Display::CALCQMDATA();
			}
			
			//Display::CALCTRIGGER();
			TriggerLevelChanged = 1;
			Display::StatusUpdate();
            			
			Menu_Changed = 1;

			break;
		}
		
		// Channel 4
		case 4:
		{
			if (Channel_4_Active == 0) return;
		
					if (MenuItemPushed[3] == 0) doit = true;
					MenuButtonCheck(3);
					
			changing = false;
			while (rbuf > 0)
			{
				switch(Direction)
				{
						case 0: if (MenuStatus[MENU_CHANNEL4][3] > 104) {MenuStatus[MENU_CHANNEL4][3]--; changing = true;} break;
						case 1: if (MenuStatus[MENU_CHANNEL4][3] < 113) {MenuStatus[MENU_CHANNEL4][3]++; changing = true;} break;
				}
				rbuf--;
					}
					
					if (changing)
					{
				Display::DRAWP(345, 454, 60, 14, 0, Buffer_UI2Plane);
				Display::TEXTOUTxvbig(MenuData[MenuStatus[MENU_CHANNEL4][3]], 354, 455, 1, Buffer_UI2Plane);
				Display::DRAWSTATUS(Active_Menu, 1);		
				Display::DRAWSTATUS(6, 0);				
			}
					
			if (Cursor_Enabled)
			{
				CursorChanged = 4;
				if(FFT_Mode != FFT_OFF)
				Display::FFT_CalcCursorData();
				else
				Display::CALCCURSORDATA();

			}
			if (QM_Enabled)
			{					
				Display::CALCQMDATA();
			}	
			
			//Display::CALCTRIGGER();
			TriggerLevelChanged = 1;
			Display::StatusUpdate();			
		
			Menu_Changed = 1;		

			break;
		}
		
		// Display Menu -> grid brightness
		case 5:
		{
			if (MenuItemPushed[2] == 0) doit = true;
			MenuButtonCheck(2);
			
			changing = false;
			
			while (rbuf > 0)
			{		
			
				switch(Direction)
				{
					case 0:
					{
						
						if (GridColorArrayPos > 0)
						{
							GridColorArrayPos--;
							GridColor_Val = GridColorArray[GridColorArrayPos];
			
							changing = true;
						}				
						
						break;
					}
			
					case 1:
					{
						if (GridColorArrayPos < 3)
						{
							GridColorArrayPos++;
							GridColor_Val = GridColorArray[GridColorArrayPos];
									
							changing = true;
						}				

						break;
					}				
				}
				rbuf--;
			}			
			
			if (changing)
			{			
				Hardware::SetupADC();
								
				MenuStatus[MENU_DISPLAY][2] = GridColorArrayPos + 133;
								
				Display::DRAWP(240, 454, 60, 14, 0, Buffer_UI2Plane);
				Display::TEXTOUTxvbig(MenuData[MenuStatus[MENU_DISPLAY][2]], 218 + MenuDataDef[MenuStatus[MENU_DISPLAY][2]], 455, 1, Buffer_UI2Plane);			
			}			
			
#ifdef _Debug_			
			if (Debug_Mode) printf("GV %i : %2x\n", GridColorArrayPos, GridColor_Val);
#endif			
			//Hardware::ResetTimer();
			
			MenuItemChanged[2] = 1;
			Menu_Changed = 1;

			break;
		}
		
		// Save / Recall Menu
		case 8:
		{		
			if (MenuItemPushed[0] == 0) doit = true;
			MenuButtonCheck(0);
			
			while (rbuf > 0)
			{				
				switch(Direction)
				{
				case 0: if (SavePointer > 1) SavePointer--; break;
				case 1: if (SavePointer < 80) SavePointer++; break;
				}
				rbuf--;
			}
		
			MenuItemChanged[0] = 1;
								
			New_Menu = 8;
			Menu_Changed = 1;
		
			break;	            			
		}
		
		// Edge
		case 12:
		{
            if (EdgeToggle == 0)
            {
                if (MenuItemPushed[3] == 0) doit = true;
                MenuButtonCheck(3);

                while (rbuf > 0)
                {
                    if (Direction)
                    {
                        if ((HoldOff_Expo == 4) && (HoldOff_Value == 300)) break;
                        HoldOff_Value = HoldOff_Value + HoldOff_Steps;
                    }
                    else
                    {
                        if ((HoldOff_Expo == 1) && (HoldOff_Value == 0)) break;
                        HoldOff_Value = HoldOff_Value - HoldOff_Steps;
                    }

                    if (HoldOff_Value > 1000)
                    {
                        HoldOff_Value = 1;
                        HoldOff_Steps = 1;
                        HoldOff_Expo++;
                    }
/*                  else if ((HoldOff_Value > 100) && (HoldOff_Expo != 1))
                    {
                        HoldOff_Steps = 10;
                    }*/
                    else if (HoldOff_Value <= 0)
                    {
                        if (HoldOff_Expo > 2)
                        {
                            HoldOff_Expo--;
                            HoldOff_Value = 999;
                            HoldOff_Steps = 1;
                        }
                        else if (HoldOff_Expo > 1)
                        {
                            HoldOff_Expo = 1;
                            HoldOff_Value = 960;
                            HoldOff_Steps = 40;
                        }
                    }

                    switch(HoldOff_Expo)
                    {
                        case 1:
                        {
                            //HoldOff.Write_StepSize(0.00000004);
                            HoldOff.Write_Value((float) HoldOff_Value / (float) 1000000000);
                            break;
                        }
                        case 2:
                        {
                            //HoldOff.Write_StepSize(0.0000001);
                            HoldOff.Write_Value((float) HoldOff_Value / (float) 1000000);
                            break;
                        }
                        case 3:
                        {
                            //HoldOff.Write_StepSize(0.001);
                            HoldOff.Write_Value((float) HoldOff_Value / (float) 1000);
                            break;
                        }
                        case 4:
                        {
                            //HoldOff.Write_StepSize(1);
                            HoldOff.Write_Value((float) HoldOff_Value);
                            break;
                        }
                    }
                    rbuf--;
                }

                HoldOff.RenderText();

                if (HoldOff_Value) trig_holdoff_reg = (unsigned long) (HoldOff.Read_Value() / (float) 0.000000008);
                else trig_holdoff_reg = 0x00000000;

                Hardware::UpdateTrigger();
            }
            else if (EdgeToggle == 1)
            {
                if (MenuItemPushed[4] == 0) doit = true;
                MenuButtonCheck(4);

                changing = false;

                while (rbuf > 0)
                {
                    switch(Direction)
                    {
                        case 0: if (MenuStatus[MENU_TRIGGERMODE][4] > 104) {MenuStatus[MENU_TRIGGERMODE][4]--; changing = true;} break;
				        case 1: if (MenuStatus[MENU_TRIGGERMODE][4] < 113) {MenuStatus[MENU_TRIGGERMODE][4]++; changing = true;} break;
                    }
                    rbuf--;
                }

                if (changing)
                {
                    Display::DRAWP(442, 454, 60, 14, 0, Buffer_UI2Plane);
                    Display::TEXTOUTxvbig(MenuData[MenuStatus[MENU_TRIGGERMODE][4]], 444, 455, 1, Buffer_UI2Plane);
                }
            }


			TriggerLevelChanged = 1;
			Display::StatusUpdate();
            Menu_Changed = 1;		

			break;
		}		
			
		
	// Pre Trigger
        case 14:
	{	
		if (XY_Mode) return;
		if(FFT_Mode != FFT_OFF) return;
		if(USTB_Mode != USTB_OFF) return;
		
		//BFTEST	
		//printf("Trig_Pos_Mem : %d  Rotation buffer : %d Trig_Pos_Display : %d\r\n", Trig_Pos_Mem, rot_buf, Trig_Pos_Display);

		if (rbuf > 1)
		rbuf = ((Rotary_Steps * Rotary_Steps)>>2) * ((int) ZoomFactor + 1);
		
		if (Selected_Timebase == 3 && rbuf > 16)
		rbuf = 16;
		else if (Selected_Timebase == 2 && rbuf > 10)
		rbuf = 10;
		else if (Selected_Timebase == 1 && rbuf > 8)
		rbuf = 8;
		else if (Selected_Timebase == 0 && rbuf > 4)
		rbuf = 4;

		
		while (rbuf > 0)
		{
			if (Rotary_Direction)
			{
				if (Trig_Pos_Mem < 0x3FFF)
				 Trig_Pos_Mem++ ;
				else
				 Trig_Pos_Mem = 0x3FFF;
			}
			else
			{
				if (Trig_Pos_Mem >= 0x0064) 
				 Trig_Pos_Mem--;
				else
				 Trig_Pos_Mem = 0x0064;
			}
			rbuf--;
		}	
		Hardware::RecalcTriggerPos();
		Hardware::SetupADC();
		TriggerOffsetChanged = true;	//BF where used???
			
		//printf("Trig_Pos_Mem : %d  Rotation buffer : %d Trig_Pos_Display : %d\r\n", Trig_Pos_Mem, rot_buf, Trig_Pos_Display);
              	
		if (Memory_Window_visible)
		Display::DRAWMEMORY(0, 0, 1);	//BF draw grid position in memory
		else
		Display::DRAWMEMORY(0, 1, 1);
	
		Display::CALCPRETRIGGER();
		Display::DRAW_ALL_CURSOR();
	
		MenuItemPushed[4] = 1;
		MenuButtonCheck(4);
	
		Menu_Changed = 1;
	
		break;
        }

        	// Pulse/Width
		case 15:
		{
            if (MenuStatus[MENU_PULSEWIDTH][2] == 3)     // range
            {
#ifdef _Debug_
                printf("A Dir %d PT %d \n", Direction, PulseToggle);
                printf("A PV11 %d PE11 %d PS11 %d\n", Pulse11_Value, Pulse11_Expo, Pulse11_Steps);
                printf("A PV12 %d PE12 %d PS12 %d\n", Pulse12_Value, Pulse12_Expo, Pulse12_Steps);
#endif

                if (PulseToggle == 1)
                {
                    while (rbuf > 0)
                    {
                        if (Direction)
                        {
                            if ((Pulse11_Expo == 3) && (Pulse11_Value >= 268)) break;
                            // if ((Pulse12_Expo == 3) && (Pulse12_Value >= 268)) break;
                            Pulse11_Value = Pulse11_Value + Pulse11_Steps;
                        }
                        else
                        {
                            if ((Pulse11_Expo == 1) && (Pulse11_Value <= 16)) break;
                            Pulse11_Value = Pulse11_Value - Pulse11_Steps;
                        }

                        if (Pulse11_Value >= 1000)
                        {
                            Pulse11_Value = 1;
                            Pulse11_Steps = 1;
                            Pulse11_Expo++;
                            /*
                            if ((Pulse11_Value >= Pulse12_Value) && (Pulse11_Expo == Pulse12_Expo))
                            {
                            printf("Update Val2 1\n");

                            Pulse12_Value = 2;
                            Pulse12_Steps = 1;
                            Pulse12_Expo = Pulse11_Expo;

                            switch(Pulse12_Expo)
                            {
                                case 1:
                                {
                                    Pulse12.Write_Value((float) Pulse12_Value / (float) 1000000000);
                                    break;
                                }
                                case 2:
                                {
                                    Pulse12.Write_Value((float) Pulse12_Value / (float) 1000000);
                                    break;
                                }
                                case 3:
                                {
                                    Pulse12.Write_Value((float) Pulse12_Value / (float) 1000);
                                    break;
                                }
                            }
                            Pulse12.RenderText();
                            } */
                        }
                        else if ((Pulse11_Value >= 100) && (Pulse11_Expo == 2))
                        {
                            Pulse11_Steps = 1;
                        }
                        else if (Pulse11_Value <= 0)
                        {
                            if (Pulse11_Expo == 3)
                            {
                                Pulse11_Expo--;
                                Pulse11_Value = 999;
                                Pulse11_Steps = 1;
                            }
                            else if (Pulse11_Expo == 2)
                            {
                                Pulse11_Expo = 1;
                                Pulse11_Value = 992;
                                Pulse11_Steps = 8;
                            }
                        }
                        rbuf--;
                    }

                    switch(Pulse11_Expo)
                    {
                        case 1:
                        {
                            Pulse11.Write_Value((float) Pulse11_Value / (float) 1000000000);
                            break;
                        }
                        case 2:
                        {
                            Pulse11.Write_Value((float) Pulse11_Value / (float) 1000000);
                            break;
                        }
                        case 3:
                        {
                            Pulse11.Write_Value((float) Pulse11_Value / (float) 1000);
                            break;
                        }
                    }

                    Pulse11.RenderText();
                }
                else
                {
                    while (rbuf > 0)
                    {
                        if (Direction)
                        {
                            if ((Pulse12_Expo == 2) && (Pulse12_Value >= 524)) break;
                            Pulse12_Value = Pulse12_Value + Pulse12_Steps;
                        }
                        else
                        {
                            if ((Pulse12_Expo == 1) && (Pulse12_Value <= 8)) break;
                            Pulse12_Value = Pulse12_Value - Pulse12_Steps;
                        }

                        if (Pulse12_Value >= 1000)
                        {
                            Pulse12_Value = 1;
                            Pulse12_Steps = 1;
                            Pulse12_Expo++;
                        }
                        else if ((Pulse12_Value >= 100) && (Pulse12_Expo == 2))
                        {
                            Pulse12_Steps = 1;
                        }
                        else if (Pulse12_Value <= 0)
                        {
                            if (Pulse12_Expo == 3)
                            {
                                Pulse12_Expo--;
                                Pulse12_Value = 999;
                                Pulse12_Steps = 1;
                            }
                            else if (Pulse12_Expo == 2)
                            {
                                Pulse12_Expo = 1;
                                Pulse12_Value = 992;
                                Pulse12_Steps = 8;
                            }
                        }
                        rbuf--;
                    }

                    switch(Pulse12_Expo)
                    {
                        case 1:
                        {
                            Pulse12.Write_Value((float) Pulse12_Value / (float) 1000000000);
                            break;
                        }
                        case 2:
                        {
                            Pulse12.Write_Value((float) Pulse12_Value / (float) 1000000);
                            break;
                        }
                        case 3:
                        {
                            Pulse12.Write_Value((float) Pulse12_Value / (float) 1000);
                            break;
                        }
                    }
                    Pulse12.RenderText();
                }

                trig_range_reg = (unsigned int) (Pulse12.Read_Value() / (float) 0.000000008);
                trig_width_reg = (unsigned int) (Pulse11.Read_Value() / (float) 0.000000008);
#ifdef _Debug_
                printf("B PV11 %d PE11 %d PS11 %d\n", Pulse11_Value, Pulse11_Expo, Pulse11_Steps);
                printf("B PV12 %d PE12 %d PS12 %d\n", Pulse12_Value, Pulse12_Expo, Pulse12_Steps);
#endif
                MenuItemChanged[3] = 1;
                MenuItemChanged[4] = 1;
            }
            else
            {
                if (PulseToggle == 1)
                {
                    while (rbuf > 0)
                    {
                        if (Direction)
                        {
                            if ((Pulse21_Expo == 3) && (Pulse21_Value >= 268)) break;
                            Pulse21_Value = Pulse21_Value + Pulse21_Steps;
                        }
                        else
                        {
                            if ((Pulse21_Expo == 1) && (Pulse21_Value <= 16)) break;
                            Pulse21_Value = Pulse21_Value - Pulse21_Steps;
                        }

                        if (Pulse21_Value >= 1000)
                        {
                            Pulse21_Value = 1;
                            Pulse21_Steps = 1;
                            Pulse21_Expo++;
                        }
                        else if ((Pulse21_Value >= 100) && (Pulse21_Expo == 2))
                        {
                            Pulse21_Steps = 10;
                        }
                        else if (Pulse21_Value <= 0)
                        {
                            if (Pulse21_Expo > 2)
                            {
                                Pulse21_Expo--;
                                Pulse21_Value = 999;
                                Pulse21_Steps = 1;
                            }
                            else if (Pulse21_Expo > 1)
                            {
                                Pulse21_Expo = 1;
                                Pulse21_Value = 992;
                                Pulse21_Steps = 8;
                            }
                        }
                        rbuf--;
                    }

                    switch(Pulse21_Expo)
                    {
                        case 1:
                        {
                            Pulse21.Write_StepSize(0.000000008);
                            Pulse21.Write_Value((float) Pulse21_Value / (float) 1000000000);
                            break;
                        }
                        case 2:
                        {
                            Pulse21.Write_StepSize(0.0000001);
                            Pulse21.Write_Value((float) Pulse21_Value / (float) 1000000);
                            break;
                        }
                        case 3:
                        {
                            Pulse21.Write_StepSize(0.001);
                            Pulse21.Write_Value((float) Pulse21_Value / (float) 1000);
                            break;
                        }
                    }

                    Pulse21.RenderText();

                    trig_width_reg = (unsigned int) ((Pulse21.Read_Value() / (float) 0.000000008));
                    MenuItemChanged[3] = 1;
                }
                else
                {
                    while (rbuf > 0)
                    {
                        if (Direction)
                        {
                            if ((Pulse22_Expo == 3) && (Pulse22_Value >= 268)) break;
                            Pulse22_Value = Pulse22_Value + Pulse22_Steps;
                        }
                        else
                        {
                            if ((Pulse22_Expo == 1) && (Pulse22_Value <= 16)) break;
                            Pulse22_Value = Pulse22_Value - Pulse22_Steps;
                        }

                        if (Pulse22_Value >= 1000)
                        {
                            Pulse22_Value = 1;
                            Pulse22_Steps = 1;
                            Pulse22_Expo++;
                        }
                        else if ((Pulse22_Value >= 100) && (Pulse22_Expo == 2))
                        {
                            Pulse22_Steps = 10;
                        }
                        else if (Pulse22_Value <= 0)
                        {
                            if (Pulse22_Expo > 2)
                            {
                                Pulse22_Expo--;
                                Pulse22_Value = 999;
                                Pulse22_Steps = 1;
                            }
                            else if (Pulse22_Expo > 1)
                            {
                                Pulse22_Expo = 1;
                                Pulse22_Value = 992;
                                Pulse22_Steps = 8;
                            }
                        }
                        rbuf--;
                    }

                    switch(Pulse22_Expo)
                    {
                        case 1:
                        {
                            Pulse22.Write_StepSize(0.000000008);
                            Pulse22.Write_Value((float) Pulse22_Value / (float) 1000000000);
                            break;
                        }
                        case 2:
                        {
                            Pulse22.Write_StepSize(0.0000001);
                            Pulse22.Write_Value((float) Pulse22_Value / (float) 1000000);
                            break;
                        }
                        case 3:
                        {
                            Pulse22.Write_StepSize(0.001);
                            Pulse22.Write_Value((float) Pulse22_Value / (float) 1000);
                            break;
                        }
                    }

                    Pulse22.RenderText();

                    trig_width_reg = (unsigned int) ((Pulse22.Read_Value() / (float) 0.000000008));
                    MenuItemChanged[4] = 1;
                }
            }

            New_Menu = 15;
            Menu_Changed = 1;
            Hardware::UpdateTrigger();

			break;
		}

        case 16: // Main Wheel -> Cursor ( comment TMW added)
	{		
           	 if (Cursor_Enabled == 0) break;

/*
		rot_buf = (int) ZoomFactor;
		if (rot_buf < 1) rot_buf = Rotary_Steps; // For interpolation (TMW enabled this line)		

		if ((rbuf > 5) && (rbuf < 11)) rbuf = rbuf * 3;
		else if (rbuf > 10) rbuf = rbuf * 7;
*/


	
		rot_buf = ((Rotary_Steps * Rotary_Steps) >> 4) + 1; 	//BF new square function characteristic 1/8 * X² + 1
		//rbuf   = rot_buf; 


            while (rbuf > 0)
            {            				
  				if (Cursor_Horizontal_Active == 3)	
				{
				    if (XY_Mode == 1)
				    {

                    switch(Cursor_Vertical_Active)
					{
						case 1:
						{
							CursorChanged = 1;
							
							if (MenuItemPushed[1] == 0) doit = true;
							MenuButtonCheck(1);
							
							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Vertical_Position_Real_XY_1 - rot_buf) > DrawXYOffsetX1) Cursor_Vertical_Position_Real_XY_1 = Cursor_Vertical_Position_Real_XY_1 - rot_buf;

									break;
								}
								case 1:
								{
									if ((Cursor_Vertical_Position_Real_XY_1 + rot_buf) < DrawXYOffsetX2) Cursor_Vertical_Position_Real_XY_1 = Cursor_Vertical_Position_Real_XY_1 + rot_buf;

									break;
								}							
							}

							break;
						}
						case 2:
						{
							CursorChanged = 2;
							
							if (MenuItemPushed[2] == 0) doit = true;
							MenuButtonCheck(2);
							
							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Vertical_Position_Real_XY_2 - rot_buf) > DrawXYOffsetX1) Cursor_Vertical_Position_Real_XY_2 = Cursor_Vertical_Position_Real_XY_2 - rot_buf;

									break;
								}
								case 1:
								{
									if ((Cursor_Vertical_Position_Real_XY_2 + rot_buf) < DrawXYOffsetX2) Cursor_Vertical_Position_Real_XY_2 = Cursor_Vertical_Position_Real_XY_2 + rot_buf;

									break;
								}							
							}
							break;
						}
						case 4:
						{
							CursorChanged = 1;
							
							//if (MenuItemPushed[5] == 0) doit = true;
							//MenuButtonCheck(5);
							MenuItemPushed[1] = 1;
							MenuItemChanged[1] = 1;
							MenuItemChanged[2] = 1;
							
							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Vertical_Position_Real_XY_1 - rot_buf) > DrawXYOffsetX1) Cursor_Vertical_Position_Real_XY_1 = Cursor_Vertical_Position_Real_XY_1 - rot_buf;
                                    if ((Cursor_Vertical_Position_Real_XY_2 - rot_buf) > DrawXYOffsetX1) Cursor_Vertical_Position_Real_XY_2 = Cursor_Vertical_Position_Real_XY_2 - rot_buf;

									break;
								}
								case 1:
								{
									if ((Cursor_Vertical_Position_Real_XY_1 + rot_buf) < DrawXYOffsetX2) Cursor_Vertical_Position_Real_XY_1 = Cursor_Vertical_Position_Real_XY_1 + rot_buf;
                                    if ((Cursor_Vertical_Position_Real_XY_2 + rot_buf) < DrawXYOffsetX2) Cursor_Vertical_Position_Real_XY_2 = Cursor_Vertical_Position_Real_XY_2 + rot_buf;

									break;
								}							
							}
							break;
						}                        						
					}				
				
				    }
				    else // TMW comment added: else means XY_Mode ==0
				    {
				
					switch(Cursor_Vertical_Active)
					{
						case 1: // TMW comment added: 1 means Cursor X1 is active
						{
							CursorChanged = 1;					
							if (MenuItemPushed[1] == 0) doit = true;
							MenuButtonCheck(1);
							
                            //if (Cursor_Vertical_Position_Real1 < (SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real1 = SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
                            //if (Cursor_Vertical_Position_Real1 > (600 + SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real1 = 600 + SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
							
							if (Cursor_Vertical_Position_Real1 < (SignalStartStop[Timebase_Idx][0] + (int)((float) Timebase_Offset_Pos * OffsetFactor))) 
								Cursor_Vertical_Position_Real1 = SignalStartStop[Timebase_Idx][0] + (int)((float) Timebase_Offset_Pos * OffsetFactor);
                            if (Cursor_Vertical_Position_Real1 > (SignalStartStop[Timebase_Idx][1] + (int)((float) Timebase_Offset_Pos * OffsetFactor))) 
								Cursor_Vertical_Position_Real1 = SignalStartStop[Timebase_Idx][1] + (int)((float) Timebase_Offset_Pos * OffsetFactor);

							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Vertical_Position_Real1 - rot_buf) > 0) Cursor_Vertical_Position_Real1 = Cursor_Vertical_Position_Real1 - rot_buf;		
 				             	
									break;
								}
								case 1:
								{
									if ((Cursor_Vertical_Position_Real1 + rot_buf) < 16384) Cursor_Vertical_Position_Real1 = Cursor_Vertical_Position_Real1 + rot_buf;		

									break;
								}
							}

							break;
						}
						case 2: // TMW comment added: 2 means Cursor X2 is active
						{
							CursorChanged = 2;
							
							if (MenuItemPushed[2] == 0) doit = true;
							MenuButtonCheck(2);
							
                            //if (Cursor_Vertical_Position_Real2 < (SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real2 = SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
                            //if (Cursor_Vertical_Position_Real2 > (600 + SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real2 = 600 + SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);		

							if (Cursor_Vertical_Position_Real2 < (SignalStartStop[Timebase_Idx][0] + (int)((float) Timebase_Offset_Pos * OffsetFactor))) Cursor_Vertical_Position_Real2 = SignalStartStop[Timebase_Idx][0] + (int)((float) Timebase_Offset_Pos * OffsetFactor);
                            if (Cursor_Vertical_Position_Real2 > (SignalStartStop[Timebase_Idx][1] + (int)((float) Timebase_Offset_Pos * OffsetFactor))) Cursor_Vertical_Position_Real2 = SignalStartStop[Timebase_Idx][1] + (int)((float) Timebase_Offset_Pos * OffsetFactor);

							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Vertical_Position_Real2 - rot_buf) > 0) Cursor_Vertical_Position_Real2 = Cursor_Vertical_Position_Real2 - rot_buf;

									break;
								}
								case 1:
								{
									if ((Cursor_Vertical_Position_Real2 + rot_buf) < 16384) Cursor_Vertical_Position_Real2 = Cursor_Vertical_Position_Real2 + rot_buf;

									break;
								}
							}
							break;
						}	
						case 4:
						{
							CursorChanged = 1;					
							//if (MenuItemPushed[5] == 0) doit = true;
							MenuItemPushed[1] = 1;
							//MenuButtonCheck(5);
				            MenuItemChanged[1] = 1;
				            MenuItemChanged[2] = 1;							
						    /*
                            if (Cursor_Vertical_Position_Real1 < (SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real1 = SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
                            if (Cursor_Vertical_Position_Real1 > (600 + SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real1 = 600 + SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);
						
                            if (Cursor_Vertical_Position_Real2 < (SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real2 = SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);		
                            if (Cursor_Vertical_Position_Real2 > (600 + SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float))) Cursor_Vertical_Position_Real2 = 600 + SIG_Start_Stop[ZIT_short][0] + (int)((float) Timebase_Offset_Pos * OFT_float);		
						    */
							if (Cursor_Vertical_Position_Real1 < (SignalStartStop[Timebase_Idx][0] + (int)((float) Timebase_Offset_Pos * OffsetFactor))) Cursor_Vertical_Position_Real1 = SignalStartStop[Timebase_Idx][0] + (int)((float) Timebase_Offset_Pos * OffsetFactor);
                            if (Cursor_Vertical_Position_Real1 > (SignalStartStop[Timebase_Idx][1] + (int)((float) Timebase_Offset_Pos * OffsetFactor))) Cursor_Vertical_Position_Real1 = SignalStartStop[Timebase_Idx][1] + (int)((float) Timebase_Offset_Pos * OffsetFactor);							
							
							if (Cursor_Vertical_Position_Real2 < (SignalStartStop[Timebase_Idx][0] + (int)((float) Timebase_Offset_Pos * OffsetFactor))) Cursor_Vertical_Position_Real2 = SignalStartStop[Timebase_Idx][0] + (int)((float) Timebase_Offset_Pos * OffsetFactor);
                            if (Cursor_Vertical_Position_Real2 > (SignalStartStop[Timebase_Idx][1] + (int)((float) Timebase_Offset_Pos * OffsetFactor))) Cursor_Vertical_Position_Real2 = SignalStartStop[Timebase_Idx][1] + (int)((float) Timebase_Offset_Pos * OffsetFactor);
						
							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Vertical_Position_Real1 - rot_buf) > 0) Cursor_Vertical_Position_Real1 = Cursor_Vertical_Position_Real1 - rot_buf;
                                    if ((Cursor_Vertical_Position_Real2 - rot_buf) > 0) Cursor_Vertical_Position_Real2 = Cursor_Vertical_Position_Real2 - rot_buf;		

									break;
								}
								case 1:
								{
									if ((Cursor_Vertical_Position_Real1 + rot_buf) < 16384) Cursor_Vertical_Position_Real1 = Cursor_Vertical_Position_Real1 + rot_buf;		
                                    if ((Cursor_Vertical_Position_Real2 + rot_buf) < 16384) Cursor_Vertical_Position_Real2 = Cursor_Vertical_Position_Real2 + rot_buf;

									break;
								}
							}

							break;
						}                        					
					}
                    } // if (XY_Mode == 1)				
				}
				
				else if (Cursor_Vertical_Active == 3)
				{
					switch(Cursor_Horizontal_Active)
					{
						case 1:
						{
							CursorChanged = 4;
							
							if (MenuItemPushed[3] == 0) doit = true;
							MenuButtonCheck(3);
							
							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Horizontal_Position_Real1 + 1) < 384) Cursor_Horizontal_Position_Real1 = Cursor_Horizontal_Position_Real1 + 1;

									break;
								}							
								case 1:
								{
									if ((Cursor_Horizontal_Position_Real1 - 1) > 0) Cursor_Horizontal_Position_Real1 = Cursor_Horizontal_Position_Real1 - 1;

									break;
								}
							}
#ifdef _Debug_Cursor_							
							if (Debug_Mode) printf("Cur H1 Pos %i\n", Cursor_Horizontal_Position_Real1);
#endif							
							break;
						}
						case 2:
						{
							CursorChanged = 5;
							
							if (MenuItemPushed[4] == 0) doit = true;
							MenuButtonCheck(4);
							
							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Horizontal_Position_Real2 + 1) < 384) Cursor_Horizontal_Position_Real2 = Cursor_Horizontal_Position_Real2 + 1;

									break;
								}							
								case 1:
								{
									if ((Cursor_Horizontal_Position_Real2 - 1) > 0) Cursor_Horizontal_Position_Real2 = Cursor_Horizontal_Position_Real2 - 1;

									break;
								}
							}
#ifdef _Debug_Cursor_							
							if (Debug_Mode) printf("Cur H2 Pos %i\n", Cursor_Horizontal_Position_Real2);
#endif							
							break;
						}
						case 4:
						{
							CursorChanged = 4;
							
							if (MenuItemPushed[5] == 0) doit = true;
							MenuButtonCheck(5);
				            MenuItemChanged[3] = 1;
				            MenuItemChanged[4] = 1;
							
							switch(Direction)
							{
								case 0:
								{
									if ((Cursor_Horizontal_Position_Real1 + 1) < 384) Cursor_Horizontal_Position_Real1 = Cursor_Horizontal_Position_Real1 + 1;
                                    if ((Cursor_Horizontal_Position_Real2 + 1) < 384) Cursor_Horizontal_Position_Real2 = Cursor_Horizontal_Position_Real2 + 1;

									break;
								}							
								case 1:
								{
									if ((Cursor_Horizontal_Position_Real1 - 1) > 0) Cursor_Horizontal_Position_Real1 = Cursor_Horizontal_Position_Real1 - 1;
                                    if ((Cursor_Horizontal_Position_Real2 - 1) > 0) Cursor_Horizontal_Position_Real2 = Cursor_Horizontal_Position_Real2 - 1;

									break;
								}
							}
#ifdef _Debug_Cursor_							
							if (Debug_Mode) printf("Cur H1H2 Pos %i  %i\n", Cursor_Horizontal_Position_Real1, Cursor_Horizontal_Position_Real2);
#endif							
							break;
						}                        						
					}			
				}	

                rbuf--;
            }
							
			if (Cursor_Enabled)
			{	
				if(FFT_Mode != FFT_OFF)
				Display::FFT_CalcCursorData();
				else
				Display::CALCCURSORDATA();
				
				Display::DRAW_ALL_CURSOR();
			}		
			
			break;	
		} // Ende Cursor Menu
		
		
		case 19:
		{
            if (QM_Enabled == 0) break; 		

            while (rbuf > 0)
            {
                if ((MenuPopupActive > -1) && (MenuPopupActive != 4)) Display::DRAWMENUPOPDOWN();
                if (MenuPopupActive == 4)
                {

                    pos = -1;
                    if (Direction == 0) MenuPopupStep(4, &MenuStatus[MENU_QUICKMEASURE][1], &MenuStatus[MENU_QUICKMEASURE][2], &MenuStatus[MENU_QMDELAY][4], 19, 52, 2);
                    else if (Direction == 1) MenuPopupStep(4, &MenuStatus[MENU_QUICKMEASURE][1], &MenuStatus[MENU_QUICKMEASURE][2], &MenuStatus[MENU_QMDELAY][4], 19, 52, 1);

                    MenuStatus[21][4] = MenuStatus[MENU_QMDELAY][4];

                    if (((MenuStatus[MENU_QUICKMEASURE][1] - 52) == 4) || ((MenuStatus[MENU_QUICKMEASURE][1] - 52) == 13))
                    {
                        if (MenuStatus[MENU_QUICKMEASURE][4] == 244) MenuItemChanged[4] = 1;
                        MenuStatus[MENU_QUICKMEASURE][4] = 242;
                    }
                    else
                    {
                        if (MenuStatus[MENU_QUICKMEASURE][4] == 242) MenuItemChanged[4] = 1;
                        MenuStatus[MENU_QUICKMEASURE][4] = 244;
                    }

                    MenuItemChanged[1] = 1;
                    MenuItemChanged[2] = 1;
						
                    New_Menu = 19;
                    Menu_Changed = 1;
                }
                else if (MenuPopupActive == -1)
                {
                    New_Menu = 19;
                    Menu_Changed = 1;
                }


                rbuf--;
            }

            Display::DRAWMENUPOPUP(4);		

            Hardware::ResetTimer();
/*			
		
			if (QM_Enabled)
			{					
				Display::CALCQMDATA();
				if (doit == 0) Hardware::ResetTimer();
			}						
*/
            break;
        }		

		case 22:
		{
			if (QM_Enabled == 0) break;
		
			while (rbuf > 0)
			{
				switch(Quick_Measure_Threshold_btn_select)
				{
					case 1:
					{
						MenuButtonCheck(2);
						//MenuItemPushed[2] = 1;
						//MenuItemChanged[2] = 1;
							
						QM_Threshold_lower.DoStep(Direction);
						QM_Threshold_lower.RenderText();
			
						break;
					}
					case 2:
					{
						MenuButtonCheck(3);
			
						//MenuItemPushed[3] = 1;
						//MenuItemChanged[3] = 1;
			
						//Hardware::ResetTimer();
					
						QM_Threshold_middle.DoStep(Direction);
						QM_Threshold_middle.RenderText();
			
						break;
					}
					case 3:
					{
						MenuButtonCheck(4);
					
						//MenuItemPushed[4] = 1;
						//MenuItemChanged[4] = 1;
						//Hardware::ResetTimer();
			
						QM_Threshold_upper.DoStep(Direction);
						QM_Threshold_upper.RenderText();
			
						break;
					}
				}
				rbuf--;
			}
		
			Hardware::ResetTimer();
			New_Menu = 22;
			Menu_Changed = 1;

            	
			break;
		}
		
		//-----------------------------------------------------------
		// Math Settings - Scale and Offset
		//-----------------------------------------------------------
		case 29:
		{		
			// set new scale factors
			if (MathToggle == 0)
			{
				if (MenuItemPushed[0] == 0) doit = true;
				
				MenuButtonCheck(0);
					
				while (rbuf > 0)
				{				
					switch(Direction)
					{
						case 0:
						{
							if (MenuStatus[MENU_MATH][2] == 1){ if (math_mul_scale < 181) math_mul_scale++; }
							else if (MenuStatus[MENU_MATH][3] == 1){ if (math_sub_scale < 165) math_sub_scale++; }
							else if (MenuStatus[MENU_MATH][4] == 1){ if (math_add_scale < 165) math_add_scale++; }
							break;
						}

						case 1:
						{
							if (MenuStatus[MENU_MATH][2] == 1){ if (math_mul_scale > 166) math_mul_scale--; }
							else if (MenuStatus[MENU_MATH][3] == 1){ if (math_sub_scale > 153) math_sub_scale--; }
							else if (MenuStatus[MENU_MATH][4] == 1){ if (math_add_scale > 153) math_add_scale--; }
							break;
						}
					}
					rbuf--;
				}

                		MenuItemChanged[0] = 1;
			}

			// set new offsets
			if (MathToggle == 1)
			{
				if (MenuItemPushed[1] == 0) doit = true;
				MenuButtonCheck(1);
					
				//if ((rbuf > 5) && (rbuf < 11)) rbuf = rbuf * 3;
				//else if (rbuf > 10) rbuf = rbuf * 7;
printf("Rotation Buffer = %d\n",rbuf);
				if (MenuStatus[MENU_MATH][2] == 1) // function key 3 - multiply
				{
					//change offset value
					while (rbuf > 0)
					{
						if (Direction)
						{ Math_Mul_Offset += math_voltage_factor[math_mul_scale - 166]; }
						else
						{ Math_Mul_Offset -= math_voltage_factor[math_mul_scale - 166]; }
						rbuf--;
					}
/*
					//limiter -> max 20 000 000 / min -20 000 000
					if (Math_Mul_Offset > (math_voltage_factor[15] * (GRID_HEIGHT/2)))
					Math_Mul_Offset = (math_voltage_factor[15] * (GRID_HEIGHT/2));
					else if (Math_Mul_Offset < (-1 * math_voltage_factor[15] * (GRID_HEIGHT/2))) 
					Math_Mul_Offset = -1 * (math_voltage_factor[15] * (GRID_HEIGHT/2));
*/
printf("Mul Offset = %d\n",Math_Mul_Offset);
					//display offset value	
					//Math_Offset_mul.Write_StepSize(1);
					Math_Offset_mul.Write_Value(float((float)Math_Mul_Offset / (float)50000));
					Math_Offset_mul.RenderText();

				}
				else if (MenuStatus[MENU_MATH][3] == 1) // function key 4 - subtract
				{
//change offset value
					while (rbuf > 0)
					{
						if (Direction)
						{ Math_Sub_Offset += math_voltage_factor[math_sub_scale - 150]; }
						else
						{ Math_Sub_Offset -= math_voltage_factor[math_sub_scale - 150]; }
						rbuf--;
					}
/*
					//limiter -> max 20 000 000 / min -20 000 000
					if (Math_Sub_Offset > (math_voltage_factor[15] * (GRID_HEIGHT/2)))
					Math_Sub_Offset = (math_voltage_factor[15] * (GRID_HEIGHT/2));
					else if (Math_Sub_Offset < (-1 * math_voltage_factor[15] * (GRID_HEIGHT/2))) 
					Math_Sub_Offset = -1 * (math_voltage_factor[15] * (GRID_HEIGHT/2));
*/
printf("Sub Offset = %d\n",Math_Sub_Offset);
					//display offset value	
					//Math_Offset_sub.Write_StepSize(1);
					Math_Offset_sub.Write_Value(float((float)Math_Sub_Offset / (float)50000));
					Math_Offset_sub.RenderText();
	             		}
               
				else if (MenuStatus[MENU_MATH][4] == 1) // add
				{
					//change offset value
					while (rbuf > 0)
					{
						if (Direction)
						{ Math_Add_Offset += math_voltage_factor[math_add_scale - 150]; }
						else
						{ Math_Add_Offset -= math_voltage_factor[math_add_scale - 150]; }
						rbuf--;
					}
/*
					//limiter -> max 20 000 000 / min -20 000 000
					if (Math_Add_Offset > (math_voltage_factor[15] * (GRID_HEIGHT/2)))
					Math_Add_Offset = (math_voltage_factor[15] * (GRID_HEIGHT/2));
					else if (Math_Add_Offset < (-1 * math_voltage_factor[15] * (GRID_HEIGHT/2))) 
					Math_Add_Offset = -1 * (math_voltage_factor[15] * (GRID_HEIGHT/2));
*/
printf("Add Offset = %d\n",Math_Mul_Offset);
					//display offset value	
					//Math_Offset_add.Write_StepSize(1);
					Math_Offset_add.Write_Value(float((float)Math_Add_Offset / (float)50000));
					Math_Offset_add.RenderText();	
		
				}

		                MenuItemChanged[1] = 1;
			}
			
                        			
			New_Menu = 29;
			Menu_Changed = 1;
/*
printf("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
printf("math_sub_scale %d\n", math_sub_scale);
printf("math_add_scale %d\n", math_add_scale);
printf("math_mul_scale %d\n", math_mul_scale);

printf("Math_Off_Sub_Value %d\n", Math_Off_Sub_Value);
printf("Math_Off_Add_Value %d\n", Math_Off_Add_Value);
printf("Math_Off_Mul_Value %d\n", Math_Off_Mul_Value);
printf("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
*/
            		break;
		}//Math settings end		
		
		
	}	
	
	if (doit)
	{
		//printf("Do it\n");
		//Hardware::ResetTimer();
		Display::DRAWSTATUS(Active_Menu, 1);		
		Display::DRAWSTATUS(6, 0);											// Draw TriggerLevel
		
		New_Menu = Active_Menu;
		Menu_Changed = 1;
	}
	UpdateMenuTextPlane = true;	

}//HandleMainWheel end





